/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.editor.ResultsTreePanel;
import oracle.dbtools.unit_test.editor.TestDetails;
import oracle.dbtools.unit_test.editor.UtEditor;
import oracle.dbtools.unit_test.runner.Debugger;
import oracle.dbtools.unit_test.runner.Runner;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.testObjects.UtTest;
import oracle.dbtools.unit_test.testObjects.UtTestImpl;
import oracle.dbtools.unit_test.utils.UiUtils;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;

public class UtTestEditor
extends UtEditor {
    private CustomTabbedPane _tabbed = new CustomTabbedPane();
    private TestDetails _details;
    private ResultsTreePanel _results;

    public String getUtId() {
        return this._details.getTestImpl().getUtId();
    }

    public String getUtiId() {
        return this._details.getTestImpl().getUtiId();
    }

    @Override
    protected void init() {
        this._details = new TestDetails(this){
            private static final long serialVersionUID = 1L;
            private Toolbar _toolbar;

            @Override
            public Toolbar getToolbar() {
                if (null == this._toolbar) {
                    this._toolbar = new Toolbar();
                    this._toolbar.addToggleButton((ToggleAction)UtTestEditor.this.getPinToggleAction());
                    this._toolbar.add((ToggleAction)UtTestEditor.this.getRefreshAction());
                    this._toolbar.addSeparator();
                    this._toolbar.add((ToggleAction)UtTestEditor.this.getDebugAction());
                    this._toolbar.add((ToggleAction)UtTestEditor.this.getRunAction(UtAddinArb.getString("RUN_TEST")));
                    this._toolbar.addSeparator();
                    this._toolbar.add((ToggleAction)UtTestEditor.this.getEditAction());
                    this._toolbar.add((ToggleAction)UtTestEditor.this.getCommitAction());
                    this._toolbar.add((ToggleAction)UtTestEditor.this.getRollbackAction());
                    UtTestEditor.this.addConnectionCombo(this._toolbar);
                    View.updateToolbarActions((Toolbar)this._toolbar);
                    UiUtils.nameButtonsForQA(this._toolbar, "TestDetails");
                }
                return this._toolbar;
            }
        };
        this._results = new ResultsTreePanel(){
            private static final long serialVersionUID = 1L;
            private Toolbar _toolbar;

            @Override
            protected Toolbar getToolbar() {
                if (null == this._toolbar) {
                    this._toolbar = new Toolbar();
                    this._toolbar.addToggleButton((ToggleAction)UtTestEditor.this.getPinToggleAction());
                    this._toolbar.add((ToggleAction)UtTestEditor.this.getRefreshAction());
                    this._toolbar.addSeparator();
                    this._toolbar.add((ToggleAction)UtTestEditor.this.getRunAction(UtAddinArb.getString("RUN_TEST")));
                    UtTestEditor.this.addConnectionCombo(this._toolbar);
                    View.updateToolbarActions((Toolbar)this._toolbar);
                    UiUtils.nameButtonsForQA(this._toolbar, "TestResults");
                }
                return this._toolbar;
            }
        };
        JPanel jPanel = this.getEditorPanel();
        jPanel.setLayout(new BorderLayout());
        this._tabbed.addTab(null, UtAddinArb.getString("DETAILS"), (Component)this._details);
        this._tabbed.addTab(null, UtAddinArb.getString("RESULTS"), (Component)this._results);
        jPanel.add((Component)this._tabbed, "Center");
    }

    public void editorShown() {
        View.updateToolbarActions((Toolbar)this._details.getToolbar());
        View.updateToolbarActions((Toolbar)this._results.getToolbar());
    }

    @Override
    protected void commit() throws ObjectUpdateException {
        if (null != this._details) {
            this._details.commit();
        }
    }

    @Override
    protected void rollback() {
        if (null != this._details) {
            this._details.rollback();
        }
    }

    @Override
    public void updateContent(boolean bl) {
        this.updateContent(this.getImplName(), bl);
    }

    public String getImplName() {
        return this._details.getTestImpl().getName();
    }

    public void updateContent(String string, boolean bl) {
        if (bl) {
            this.releaseEditLock();
        }
        UtTest utTest = new UtTest(this.getElementId());
        this._details.updateUI(utTest, string);
        this._results.updateUI(utTest);
        if (bl) {
            this.obtainEditLock();
        }
        this.editorShown();
    }

    @Override
    protected void run(String string) {
        try {
            Runner runner = new Runner(string);
            UtTest utTest = new UtTest(this.getElementId());
            runner.executeTest(utTest, null, true, true);
            int n = this._tabbed.getPanelIndex((Component)this._results);
            this._tabbed.setSelectedIndex(n);
        }
        catch (ConnectionCanceledException connectionCanceledException) {
            // empty catch block
        }
    }

    @Override
    protected void debug(String string) {
        UtTestImpl utTestImpl = this._details.getTestImpl();
        try {
            Debugger debugger = new Debugger(string);
            debugger.debugImpl(utTestImpl);
        }
        catch (ConnectionCanceledException connectionCanceledException) {
            // empty catch block
        }
    }

    @Override
    protected void setHaveEditLock(boolean bl) {
        super.setHaveEditLock(bl);
        if (null != this._details) {
            this._details.setEditable(this.haveEditLock());
        }
    }

    @Override
    protected void stopEditing() {
        if (null != this._details) {
            this._details.stopEditing();
        }
        super.stopEditing();
    }
}

