/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.create_wizard;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.create_wizard.CreateWizArb;
import oracle.dbtools.unit_test.create_wizard.CreateWizPanel;
import oracle.dbtools.unit_test.testObjects.UtLibraryItem;
import oracle.dbtools.unit_test.testObjects.UtTest;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class CreateWizOptions
extends CreateWizPanel {
    private static final long serialVersionUID = 1L;
    private boolean _nameSet = false;
    private JTextField _testNameField = new JTextField("");
    private JRadioButton _jbSeed = new JRadioButton();
    private JRadioButton _jbNoSeed = new JRadioButton();
    private HashSet<String> _testNames = new HashSet();

    public CreateWizOptions() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(10, 10, 10, 10);
        JLabel jLabel = new JLabel(CreateWizArb.getString("TEST_NAME_LABEL"));
        this.add(jLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 2, 10), 0, 0));
        this.add(this._testNameField, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(2, 10, 10, 10), 0, 0));
        this._testNameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string = CreateWizOptions.this._testNameField.getText();
                if (string != null && string.equals("") || CreateWizOptions.this._testNames.contains(string)) {
                    string = null;
                }
                boolean bl = string != null;
                CreateWizOptions.this.getCreateWizContext().getTest().setTestName(string);
                if (bl != CreateWizOptions.this._nameSet) {
                    CreateWizOptions.this._nameSet = bl;
                    CreateWizOptions.this.enableButtons(true, CreateWizOptions.this._nameSet);
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        this._jbNoSeed.setSelected(true);
        buttonGroup.add(this._jbNoSeed);
        this._jbSeed.setSelected(false);
        buttonGroup.add(this._jbSeed);
        JTextArea jTextArea = new JTextArea(CreateWizArb.getString("SEED_BUTTON_LABEL"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setBorder(null);
        JTextArea jTextArea2 = new JTextArea(CreateWizArb.getString("NO_SEED_BUTTON_LABEL"));
        jTextArea2.setLineWrap(true);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setEditable(false);
        jTextArea2.setBorder(null);
        this.add(this._jbNoSeed, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add(jTextArea2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
        this.add(this._jbSeed, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add(jTextArea, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTestNames() {
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            ResultSet resultSet;
            block6: {
                resultSet = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    String string = UtUtils.getQuery("testNames");
                    resultSet = dBUtil.executeOracleQuery(string, null);
                    this._testNames.clear();
                    if (resultSet == null) break block6;
                    while (resultSet.next()) {
                        this._testNames.add(resultSet.getString("NAME"));
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        Logger.getLogger(UtLibraryItem.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
    }

    @Override
    public void onEntry(TraversableContext traversableContext) {
        this.loadTestNames();
        super.onEntry(traversableContext);
        String string = this.getCreateWizContext().getTest().getTestName();
        if (this._testNames.contains(string)) {
            this.setTestName(string);
        }
        this.enableButtons(true, this._nameSet);
    }

    @Override
    protected void onEntryTestChanged() {
        UtTest utTest = this.getCreateWizContext().getTest();
        String string = utTest.getObjectName();
        String string2 = utTest.getObjectCall();
        if (string2 != null) {
            string = string + '.' + string2;
        }
        this.setTestName(string);
    }

    private void setTestName(String string) {
        String string2 = string;
        int n = 1;
        while (this._testNames.contains(string2)) {
            string2 = string + '_' + n++;
        }
        this._testNameField.setText(string2);
        this._nameSet = true;
        this.getCreateWizContext().getTest().setTestName(string2);
        this.enableButtons(true, this._nameSet);
    }

    @Override
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        super.onExit(traversableContext);
        this.getCreateWizContext().setUseSeeding(this._jbSeed.isSelected());
    }

    public Object getExitTransition() {
        return "STARTUP_TRANS";
    }
}

