/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test;

import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.unit_test.UtDataTypeConnectionProvider;
import oracle.dbtools.unit_test.UtRepositoryManager;
import oracle.dbtools.unit_test.UtRepositoryStateListener;
import oracle.dbtools.unit_test.config.UtConfig;
import oracle.dbtools.unit_test.editor.UtEditor;
import oracle.dbtools.unit_test.navigator.UtNavigatorManager;
import oracle.dbtools.unit_test.navigator.nodes.RootFolder;
import oracle.dbtools.unit_test.repository.RepositoryManager;
import oracle.ide.Addin;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.SwingUtils;

public class UtAddin
implements Addin {
    private static UtRepositoryManager s_repositoryManager;
    private static UtDataTypeConnectionProvider s_datatypeConnectionProvider;
    private static UtConfig s_Config;
    private static ArrayList<UtRepositoryStateListener> s_repositoryListeners;
    private static UtNavigatorManager s_utNavMgr;
    public static final String UT_MENU_ID = "UtMenu";
    public static final String CREATE_REPO = "CreateUTRepository";
    public static final String DEFAULT_REPO = "DefaultUTRepository";
    public static final String UNSET_REPO = "UnsetUTRepository";
    public static final String DROP_REPO = "DropUTRepository";
    public static final String PURGE_RESULTS = "PurgeUTResults";
    public static final String PURGE_REPO = "PurgeUTRepository";
    public static final String SHOW_SHARED = "ShowShared";
    public static final String CREATE_SYNS = "CreateSynonyms";
    public static final String DROP_SYNS = "DropSynonyms";
    public static final String MANAGE_USERS = "ManageUsers";
    public static final String IMPORT_FILE = "ImportFile";
    public static final String CREATE_DEMO = "CreateDemo";
    public static final Icon rootIcon;
    public static final Icon suiteFolderIcon;
    public static final Icon reportFolderIcon;
    public static final Icon suiteNodeIcon;
    public static final Icon testFolderIcon;
    public static final Icon testNodeIcon;
    public static final Icon testEditorIcon;
    public static final Icon testImplIcon;
    public static final Icon libStartupTypesFolderIcon;
    public static final Icon libTeardownTypesFolderIcon;
    public static final Icon libValidationTypesFolderIcon;
    public static final Icon libStartupsFolderIcon;
    public static final Icon libTeardownsFolderIcon;
    public static final Icon libValidationsFolderIcon;
    public static final Icon libStartupIcon;
    public static final Icon libTeardownIcon;
    public static final Icon libValidationIcon;
    public static final Icon libraryFolderIcon;
    public static final Icon lookupFolderIcon;
    public static final Icon lookupNodeIcon;
    public static final Icon libEditorIcon;
    public static final Icon navIcon;
    public static final Icon testParamIcon;
    public static final Icon suiteEditorIcon;
    public static final Icon lookupEditorIcon;

    public void initialize() {
        s_utNavMgr = UtNavigatorManager.getInstance();
        UtAddin.getRepositoryManager().initialize();
    }

    public static UtNavigatorManager getNavigatorManager() {
        return s_utNavMgr;
    }

    public static void addRepositoryStateListener(UtRepositoryStateListener utRepositoryStateListener) {
        if (s_repositoryListeners == null) {
            s_repositoryListeners = new ArrayList();
        }
        s_repositoryListeners.add(utRepositoryStateListener);
    }

    public static UtRepositoryManager getRepositoryManager() {
        if (s_repositoryManager == null) {
            s_repositoryManager = new UtRepositoryManager();
        }
        return s_repositoryManager;
    }

    public static UtDataTypeConnectionProvider getDataTypeConnectionProvider() {
        if (s_datatypeConnectionProvider == null) {
            s_datatypeConnectionProvider = new UtDataTypeConnectionProvider();
        }
        return s_datatypeConnectionProvider;
    }

    public static boolean isRepositoryOpen() {
        return UtAddin.getRepositoryManager().isConnected();
    }

    public static boolean defaultDefined() {
        return !UtAddin.getConfig().getRepository().equals("");
    }

    public static String getRepositoryConnectionName() {
        if (UtAddin.getRepositoryManager().isConnected()) {
            return UtAddin.getRepositoryManager().getName();
        }
        return null;
    }

    public static void closeRepository() {
        UtAddin.getRepositoryManager().closeConnection();
        s_repositoryManager = null;
        if (s_repositoryListeners != null) {
            for (UtRepositoryStateListener utRepositoryStateListener : s_repositoryListeners) {
                utRepositoryStateListener.repositoryClosed();
            }
        }
        RootFolder.getInstance().clearTree();
    }

    public static void openRepository(String string) {
        if (UtAddin.getRepositoryManager().openConnectionNoChecks(string)) {
            if (!RepositoryManager.doesRepositoryExist(UtAddin.getRepositoryManager().getConnection())) {
                RootFolder.getInstance().clearTree();
            } else if (!RepositoryManager.isCurrentVersion(UtAddin.getRepositoryManager().getConnection())) {
                RootFolder.getInstance().clearTree();
            } else {
                if (s_repositoryListeners != null) {
                    for (UtRepositoryStateListener utRepositoryStateListener : s_repositoryListeners) {
                        utRepositoryStateListener.repositoryOpened(string);
                    }
                }
                RootFolder.getInstance().loadTree();
            }
            RootFolder.getInstance().reset();
        }
    }

    public static boolean isReposPingable() {
        return UtAddin.getRepositoryManager().isReposPingable();
    }

    public static UtConfig getConfig() {
        if (s_Config == null) {
            Preferences preferences = Preferences.getPreferences();
            s_Config = UtConfig.getInstance((PropertyStorage)preferences);
        }
        return s_Config;
    }

    public static void closeAllUnitTestUI() {
        Window[] windowArray = Window.getOwnerlessWindows();
        UtAddin.closeDialogs(windowArray);
        UtAddin.closeAllEditors();
        RootFolder.getInstance().clearTree();
    }

    public static void closeAllUnitTestUIDefer() {
        SwingUtils.dispatch((Runnable)new Runnable(){

            @Override
            public void run() {
                UtAddin.closeAllUnitTestUI();
            }
        });
    }

    public static void closeAllEditors() {
        ArrayList<Editor> arrayList = new ArrayList<Editor>();
        List list = EditorManager.getEditorManager().getAllEditors();
        for (Editor editor : list) {
            if (!(editor instanceof UtEditor)) continue;
            arrayList.add(editor);
        }
        EditorManager.getEditorManager().closeEditors(arrayList);
    }

    public static void closeAllEditorsDefer() {
        SwingUtils.dispatch((Runnable)new Runnable(){

            @Override
            public void run() {
                UtAddin.closeAllEditors();
            }
        });
    }

    private static void closeDialogs(Window[] windowArray) {
        for (Window window : windowArray) {
            UtAddin.closeDialogs(window.getOwnedWindows());
            if (!(window instanceof Dialog) || !window.isVisible()) continue;
            window.setVisible(false);
        }
    }

    static {
        s_Config = null;
        rootIcon = RaptorImagesArb.getIcon((String)"UNIT_TEST_ROOT");
        suiteFolderIcon = RaptorImagesArb.getIcon((String)"SUITE_FOLDER");
        reportFolderIcon = RaptorImagesArb.getIcon((String)"REPORT_ROOT");
        suiteNodeIcon = RaptorImagesArb.getIcon((String)"SUITE_FOLDER");
        testFolderIcon = RaptorImagesArb.getIcon((String)"TEST_FOLDER");
        testNodeIcon = RaptorImagesArb.getIcon((String)"TEST_NODE");
        testEditorIcon = RaptorImagesArb.getIcon((String)"TEST_NODE");
        testImplIcon = RaptorImagesArb.getIcon((String)"TEST_IMPL");
        libStartupTypesFolderIcon = RaptorImagesArb.getIcon((String)"LIB_STARTUPS_FOLDER");
        libTeardownTypesFolderIcon = RaptorImagesArb.getIcon((String)"LIB_TEARDOWNS_FOLDER");
        libValidationTypesFolderIcon = RaptorImagesArb.getIcon((String)"LIB_VALIDATION_FOLDER");
        libStartupsFolderIcon = RaptorImagesArb.getIcon((String)"LIB_STARTUPS_FOLDER");
        libTeardownsFolderIcon = RaptorImagesArb.getIcon((String)"LIB_TEARDOWNS_FOLDER");
        libValidationsFolderIcon = RaptorImagesArb.getIcon((String)"LIB_VALIDATION_FOLDER");
        libStartupIcon = RaptorImagesArb.getIcon((String)"LIB_STARTUP");
        libTeardownIcon = RaptorImagesArb.getIcon((String)"LIB_TEARDOWN");
        libValidationIcon = RaptorImagesArb.getIcon((String)"VALIDATE_REG_EXP");
        libraryFolderIcon = RaptorImagesArb.getIcon((String)"LIBRARY_FOLDER");
        lookupFolderIcon = RaptorImagesArb.getIcon((String)"LOOKUP_FOLDER");
        lookupNodeIcon = RaptorImagesArb.getIcon((String)"DATATYPE_FOLDER");
        libEditorIcon = RaptorImagesArb.getIcon((String)"LIB_EDITOR");
        navIcon = RaptorImagesArb.getIcon((String)"UNIT_TEST_ROOT");
        testParamIcon = RaptorImagesArb.getIcon((String)"TEST_IMPL");
        suiteEditorIcon = RaptorImagesArb.getIcon((String)"SUITES");
        lookupEditorIcon = RaptorImagesArb.getIcon((String)"LOOKUP_ATTRIBUTE");
    }
}

