/*
 * Decompiled with CFR 0.152.
 */
package oracle.annotation.logging.processor;

import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.FieldDoc;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import oracle.annotation.logging.Category;
import oracle.annotation.logging.Publish;
import oracle.annotation.logging.Severity;
import oracle.annotation.logging.processor.BundleProcessor;
import oracle.annotation.logging.processor.MessageDescriptor;

public class Util {
    public static final String NL = "\n";
    public static final int INDENT = 4;
    public static final String START_TEXT_ESCAPE = "<![CDATA[";
    public static final String END_TEXT_ESCAPE = "]]>";
    private static boolean debug = false;
    private static boolean verbose = false;
    private static String srchome = null;
    private static String[] srcdirs = null;
    private static String[] resdirs = null;
    private static String srcdir = null;
    private static List<String> filterFiles = null;
    private static String filterFileName = null;
    private static boolean checkWptg = false;
    private static boolean fishing = false;
    private static String space = "                                                             ";
    private static HashMap<String, String> canonicalNames = new HashMap();
    private static String canonicalSrchome = null;
    private static String[] canonicalSrcdirs = null;
    private static String canonicalSrcdir = null;
    private static HashMap<Class, String> fileForClass = new HashMap();
    private static HashMap<Integer, String> productMap = null;
    private static final boolean HAVE_CONSTANT_VALUE_BUG = true;

    public static boolean getDebug() {
        return debug;
    }

    public static void setDebug(boolean flag) {
        debug = flag;
    }

    public static boolean getVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean flag) {
        verbose = flag;
    }

    public static String getSrchome() {
        return srchome;
    }

    public static void setSrchome(String dir) {
        srchome = dir;
    }

    public static String[] getSrcdirs() {
        return srcdirs;
    }

    public static String[] getResdirs() {
        return resdirs;
    }

    public static void setSrcdir(String dirsArg) {
        int i;
        ArrayList<String> dirs = new ArrayList<String>();
        ArrayList<String> resDirs = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(dirsArg, ":,");
        while (st.hasMoreTokens()) {
            String sd = st.nextToken().trim();
            if (sd.equals("")) continue;
            if (sd.startsWith("@")) {
                resDirs.add(sd.substring(1));
                continue;
            }
            dirs.add(sd);
        }
        srcdirs = new String[dirs.size()];
        for (i = 0; i < srcdirs.length; ++i) {
            Util.srcdirs[i] = Util.normalizeSrcdir((String)dirs.get(i));
        }
        if (srcdirs != null && srcdirs.length == 1) {
            srcdir = srcdirs[0];
        }
        resdirs = new String[resDirs.size()];
        for (i = 0; i < resdirs.length; ++i) {
            Util.resdirs[i] = Util.normalizeSrcdir((String)resDirs.get(i));
        }
    }

    static void setSrcdirs(String[] dirs) {
        srcdirs = dirs;
        resdirs = dirs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setFilterFile(String filter) {
        File filterFile = new File(filter);
        BufferedReader lnr = null;
        if (filterFile.exists() && filterFile.canRead()) {
            try {
                lnr = new LineNumberReader(new FileReader(filter));
                filterFiles = new ArrayList<String>();
                String line = null;
                while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                    if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                    filterFiles.add(line);
                }
                filterFileName = filter;
                return;
            }
            catch (IOException ioe) {
                System.out.println("SEVERE: error reading filter file " + filter + ": " + ioe);
                if (filterFiles.size() != 0) return;
                filterFiles = null;
                return;
            }
            finally {
                if (lnr != null) {
                    try {
                        lnr.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        System.out.println("SEVERE: unable to read filter file " + filter + ".");
    }

    public static List<String> getFilterFile() {
        return filterFiles;
    }

    public static String getFilterFileName() {
        return filterFileName;
    }

    public static void setCheckWptg(boolean b) {
        checkWptg = b;
    }

    public static boolean getCheckWptg() {
        return checkWptg;
    }

    private static String normalizeSrcdir(String s) {
        if (s.startsWith("$ADE_VIEW_ROOT/")) {
            s = s.substring("$ADE_VIEW_ROOT/".length());
        } else if (s.startsWith("$SRCHOME/")) {
            s = s.substring("$SRCHOME/".length());
        } else if (s.startsWith("${ADE_VIEW_ROOT}/")) {
            s = s.substring("${ADE_VIEW_ROOT}/".length());
        } else if (s.startsWith("${SRCHOME}/")) {
            s = s.substring("${SRCHOME}/".length());
        } else if (s.startsWith("./")) {
            s = s.substring("./".length());
        } else if (s.startsWith("/") || s.startsWith("..")) {
            BundleProcessor.explain("Option -srcdir must provide the Java source root directory as a _relative_ path under $ADE_VIEW_ROOT.\nFound: -srcdir " + s + NL + "Please adjust the setting of the -srcdir option.");
        }
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static boolean getFishing() {
        return fishing;
    }

    public static void setFishing(boolean flag) {
        fishing = flag;
    }

    public static String escapeHtml(String s) {
        if (s == null) {
            return "<i>null</i>";
        }
        return s.replace("<", "&lt;").replace(">", "&gt;");
    }

    public static String doQuote(String s) {
        return START_TEXT_ESCAPE + s + END_TEXT_ESCAPE;
    }

    public static String spaces(int i) {
        return space.substring(0, i);
    }

    public static String getShortFileName(String fileName) {
        String f = Util.getCanonicalFileName(fileName);
        if (srcdir != null && f.startsWith(srchome + "/" + srcdir)) {
            return "." + f.substring((srchome + "/" + srcdir).length());
        }
        if (f.startsWith(srchome)) {
            return "$ADE_VIEW_ROOT" + f.substring(srchome.length());
        }
        return f;
    }

    public static String getCanonicalFileName(String fileName) {
        String res = canonicalNames.get(fileName);
        if (res == null) {
            res = Util.getCanonicalFileName2(fileName);
            canonicalNames.put(fileName, res);
        }
        return res;
    }

    private static String getCanonicalFileName2(String fileName) {
        String res = Util.canonicalize(fileName);
        if (canonicalSrchome == null) {
            canonicalSrchome = Util.canonicalize(srchome);
            canonicalSrcdirs = new String[srcdirs.length];
            for (int i = 0; i < srcdirs.length; ++i) {
                Util.canonicalSrcdirs[i] = Util.canonicalize(srchome + "/" + srcdirs[i]);
            }
            if (canonicalSrcdirs.length == 1) {
                canonicalSrcdir = canonicalSrcdirs[0];
            }
        }
        if (canonicalSrcdir != null && res.startsWith(canonicalSrcdir)) {
            res = srchome + "/" + srcdir + res.substring(canonicalSrcdir.length());
        } else if (res.startsWith(canonicalSrchome)) {
            res = srchome + res.substring(canonicalSrchome.length());
        }
        return res;
    }

    public static String canonicalize(String fileName) {
        int pos;
        boolean wasMunged = false;
        if (fileName.startsWith(".")) {
            fileName = Util.javaCanonicalize(fileName);
            wasMunged = true;
        }
        if (fileName.startsWith("/ade/")) {
            return fileName;
        }
        if (fileName.startsWith("/scratch/") && (pos = fileName.indexOf("/view_storage/")) > 0) {
            return "/ade/" + fileName.substring(pos + "/view_storage/".length());
        }
        return wasMunged ? fileName : Util.javaCanonicalize(fileName);
    }

    private static String javaCanonicalize(String fileName) {
        File f;
        try {
            f = new File(fileName).getCanonicalFile();
        }
        catch (IOException ioe) {
            return fileName;
        }
        return f.toString();
    }

    public static String getFileForClass(Class c) {
        File f;
        String res = fileForClass.get(c);
        if (res != null) {
            return res.equals("") ? null : res;
        }
        String s = c.getName().replace('.', '/') + ".java";
        for (String sd : Util.getSrcdirs()) {
            f = new File(Util.getSrchome() + "/" + sd + "/" + s);
            res = f.toString();
            if (!f.exists()) continue;
            fileForClass.put(c, res);
            return res;
        }
        for (String sd : Util.getResdirs()) {
            f = new File(Util.getSrchome() + "/" + sd + "/" + s);
            res = f.toString();
            if (!f.exists()) continue;
            fileForClass.put(c, res);
            return res;
        }
        fileForClass.put(c, "");
        return null;
    }

    public static String getProductName(int code) {
        if (productMap == null) {
            productMap = new HashMap();
            try {
                Field[] fields;
                Class<?> prod = Class.forName("oracle.annotation.logging.Product");
                for (Field f : fields = prod.getFields()) {
                    int m = f.getModifiers();
                    if (!Modifier.isPublic(m) || !Modifier.isStatic(m) || !Modifier.isFinal(m) || !f.getType().equals(Integer.TYPE)) continue;
                    int value = f.getInt(null);
                    productMap.put(new Integer(value), f.getName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return productMap.get(new Integer(code));
    }

    public static boolean isLevel(String lvl) {
        return lvl.equals("SEVERE") || lvl.equals("WARNING") || lvl.equals("INFO") || lvl.equals("CONFIG") || lvl.equals("FINE") || lvl.equals("FINER") || lvl.equals("FINEST") || lvl.equals("INCIDENT_ERROR") || lvl.equals("SET_AT_RUNTIME") || lvl.equals("SET_IN_MESSAGE_BUNDLE") || lvl.equals("SKIP");
    }

    public static Severity makeSeverity(String lvl) {
        if (lvl.equals("SEVERE")) {
            return Severity.SEVERE;
        }
        if (lvl.equals("WARNING")) {
            return Severity.WARNING;
        }
        if (lvl.equals("INFO")) {
            return Severity.INFO;
        }
        if (lvl.equals("CONFIG")) {
            return Severity.CONFIG;
        }
        if (lvl.equals("FINE")) {
            return Severity.FINE;
        }
        if (lvl.equals("FINER")) {
            return Severity.FINER;
        }
        if (lvl.equals("FINEST")) {
            return Severity.FINEST;
        }
        if (lvl.equals("INCIDENT_ERROR")) {
            return Severity.INCIDENT_ERROR;
        }
        if (lvl.equals("SET_AT_RUNTIME")) {
            return Severity.SET_AT_RUNTIME;
        }
        if (lvl.equals("SET_IN_MESSAGE_BUNDLE")) {
            return Severity.SET_IN_MESSAGE_BUNDLE;
        }
        if (lvl.equals("SKIP")) {
            return Severity.SKIP;
        }
        return null;
    }

    public static String getFirstToken(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).equals("")) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        char ch = s.charAt(0);
        if (ch == '\"') {
            sb.append(ch);
            for (int i = 1; i < s.length() && (ch = s.charAt(i)) != '\"'; ++i) {
                sb.append(ch);
            }
            sb.append('\"');
        } else if (Character.isLetter(ch)) {
            sb.append(ch);
            for (int i = 1; i < s.length() && (Character.isLetterOrDigit(ch = s.charAt(i)) || ch == '_'); ++i) {
                sb.append(ch);
            }
        } else {
            return null;
        }
        return sb.toString();
    }

    public static boolean isWptgFile(String file) {
        if (file.indexOf("/wptg/") >= 0) {
            return true;
        }
        int pos = file.lastIndexOf("/") + 1;
        return file.indexOf("_", pos) >= 0;
    }

    public static Object getAnnotationValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof FieldDoc) {
            return Util.constantValue((FieldDoc)o);
        }
        if (o instanceof AnnotationValue) {
            return Util.getAnnotationValue(((AnnotationValue)o).value());
        }
        if (o instanceof AnnotationValue[]) {
            AnnotationValue[] ava = (AnnotationValue[])o;
            Object[] res = new Object[ava.length];
            for (int i = 0; i < ava.length; ++i) {
                res[i] = Util.getAnnotationValue(ava[i]);
            }
            return res;
        }
        return o;
    }

    public static Object constantValue(FieldDoc fd) {
        String s = fd.toString();
        int pos = s.lastIndexOf(".");
        try {
            return Class.forName(s.substring(0, pos)).getField(s.substring(pos + 1)).get(null);
        }
        catch (Exception e) {
            System.err.println(MessageDescriptor.class.getName() + ".constantValue(FieldDoc): " + "Unable to construct " + s + " - should not occur!");
            return null;
        }
    }

    public static String plural(int count, String word) {
        return "" + count + " " + (count == 1 ? word : word + "s");
    }

    public static String pluralIfNotZero(int count, String word, String suffix) {
        return count == 0 ? "" : (count == 1 ? count + " " + word + suffix : count + " " + word + "s" + suffix);
    }

    public static boolean checkString(String s, int maxLength, String what, String[] msg) {
        msg[0] = "checkString(\"" + s + "\"," + maxLength + ",\"" + what + "\")";
        if (s == null) {
            msg[0] = "The " + what + " text is NULL.";
            return false;
        }
        if (s.length() > maxLength) {
            msg[0] = "The " + what + " text is longer than " + maxLength + " characters.";
            return false;
        }
        return true;
    }

    public static boolean checkInteger(String n, String what, String[] msg) {
        msg[0] = "checkInteger(\"" + n + "\"," + what + "\")";
        if (n == null || n.length() == 0) {
            msg[0] = "The " + what + " number must contain at least one digit.";
            return false;
        }
        for (int i = 0; i < n.length(); ++i) {
            char ch = n.charAt(i);
            if ('0' <= ch && ch <= '9') continue;
            msg[0] = "The " + what + " number \"" + n + "\" contains a non-digit character: '" + ch + "'.";
            return false;
        }
        return true;
    }

    public static String printCategory(Category c) {
        switch (c) {
            case BACKUP_AND_RECOVERY: {
                return "Backup and Recovery";
            }
            case BROWSER: {
                return "Browser";
            }
            case CLONING: {
                return "Cloning";
            }
            case COMPLIANCE: {
                return "Compliance";
            }
            case CONFIGURATION: {
                return "Configuration";
            }
            case DATA: {
                return "Data";
            }
            case DEPLOYMENT: {
                return "Deployment";
            }
            case HIGH_AVAILABILITY: 
            case FAILOVER: {
                return "High Availability";
            }
            case FILES: {
                return "Files";
            }
            case INSTALLATION: {
                return "Installation";
            }
            case LOGGING: {
                return "Logging";
            }
            case MEMORY: {
                return "Memory";
            }
            case NETWORK: {
                return "Network";
            }
            case OPERATING_SYSTEM: {
                return "Operating System";
            }
            case PERFORMANCE: {
                return "Performance";
            }
            case PORTS: {
                return "Ports";
            }
            case PROCESS: {
                return "Process";
            }
            case PROGRAMMATIC: {
                return "Programmatic";
            }
            case REQUESTS_RESPONSES: {
                return "Requests/Responses";
            }
            case SECURITY: {
                return "Security";
            }
            case SESSION: {
                return "Session";
            }
            case THREADS: {
                return "Threads";
            }
            case TOPOLOGY: {
                return "Topology";
            }
            case TRANSACTIONING: {
                return "Transactioning";
            }
            case UPGRADE: {
                return "Upgrade";
            }
            case OTHER: {
                return "Other";
            }
            case UNASSIGNED: {
                throw new IllegalArgumentException("Unassigned Category");
            }
        }
        System.out.println("SEVERE: oracle.annotation.logging.processor.Util::printCategory:  unknown Category: " + c.toString() + ". Should not occur.");
        return c.toString();
    }

    public static String printPublish(Publish p, Level lvl, Severity sev) {
        switch (p) {
            case YES: {
                return "Yes";
            }
            case NO: {
                return "No";
            }
            case UNKNOWN: {
                return lvl == null && sev == Severity.SET_IN_MESSAGE_BUNDLE || lvl == MessageDescriptor.INCIDENT_ERROR || lvl == Level.SEVERE || lvl == Level.WARNING || lvl == Level.CONFIG ? "Yes" : "No";
            }
        }
        return "Unknown";
    }

    public static String getSuffix(String id, int width) {
        if (id.length() <= width) {
            return id;
        }
        int pos = id.lastIndexOf(".");
        if (pos >= 0) {
            id = id.substring(pos + 1);
        }
        if (id.length() <= width) {
            return id;
        }
        return id.substring(0, width);
    }
}

