/*
 * Decompiled with CFR 0.152.
 */
package oracle.annotation.logging.processor;

import com.sun.javadoc.SourcePosition;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.annotation.logging.processor.AnnotationsProcessor;

public class PreJdk5AnnotationsProcessor {
    private static final boolean DEBUG = false;
    private static LineNumberReader lnr;
    private static List<String> imports;
    private static int currentColumn;
    private static int currentLine;
    private static int peek;
    private static Token peekTok;
    private static HashMap<String, AnnotationsProcessor.Entry[]> results;
    private static String[] filter;
    private static int annotationLevel;

    public static void process(String[] files) {
        results = new HashMap();
        for (String f : files) {
            PreJdk5AnnotationsProcessor.processClassDoc(f);
        }
    }

    private static void processClassDoc(String fileName) {
        File file = new File(fileName);
        ArrayList<AnnotationsProcessor.Entry> entries = new ArrayList<AnnotationsProcessor.Entry>();
        if ((PreJdk5AnnotationsProcessor.getAnnotationLevel() & 1) != 0) {
            PreJdk5AnnotationsProcessor.addAnnotations(entries, file);
        }
        if (entries.size() > 0) {
            results.put(fileName, entries.toArray(new AnnotationsProcessor.Entry[0]));
        }
    }

    private static void addAnnotations(List<AnnotationsProcessor.Entry> entries, File file) {
        PreJdk5AnnotationsProcessor.initialize(file);
        Token tok = PreJdk5AnnotationsProcessor.nextToken();
        while (tok != null) {
            if (tok.getKind() == 1) {
                if (tok == PreJdk5AnnotationsProcessor.peekToken()) {
                    tok = PreJdk5AnnotationsProcessor.nextToken();
                }
                Annotation ann = PreJdk5AnnotationsProcessor.parseAnnotation();
                boolean match = false;
                String matchedTag = null;
                if (ann != null) {
                    if (PreJdk5AnnotationsProcessor.getFilter() == null) {
                        match = true;
                    } else {
                        for (String tag : PreJdk5AnnotationsProcessor.getFilter()) {
                            if (!tag.endsWith(ann.getName())) continue;
                            match = true;
                            matchedTag = tag;
                            break;
                        }
                    }
                }
                if (match) {
                    String name = ann.getName();
                    if (matchedTag != null) {
                        name = matchedTag;
                    }
                    entries.add(new AnnotationsProcessor.Entry(tok.getSourcePosition(), name, ann.getMap()));
                }
                tok = PreJdk5AnnotationsProcessor.peekToken();
                continue;
            }
            if (tok.getKind() == 2 && tok.getImage().equals("import")) {
                tok = PreJdk5AnnotationsProcessor.nextToken();
                if (tok.getKind() != 2) continue;
                imports.add(tok.getImage());
                continue;
            }
            tok = PreJdk5AnnotationsProcessor.nextToken();
        }
    }

    private static Annotation parseAnnotation() {
        Token annotationName = PreJdk5AnnotationsProcessor.parseIdentifier();
        if (annotationName == null) {
            return null;
        }
        if (PreJdk5AnnotationsProcessor.literalToken("(", false)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            boolean done = false;
            while (!done) {
                if (!PreJdk5AnnotationsProcessor.parseTag(map)) {
                    return null;
                }
                Token tok = PreJdk5AnnotationsProcessor.nextToken();
                if (tok.getKind() == 10) {
                    done = false;
                    continue;
                }
                if (tok.getKind() == 7) {
                    done = true;
                    continue;
                }
                PreJdk5AnnotationsProcessor.reportError(tok, "Expected ',' or ')'. Found: ");
                return null;
            }
            return new Annotation(annotationName.getImage(), map);
        }
        return new Annotation(annotationName.getImage());
    }

    private static boolean parseTag(HashMap<String, Object> map) {
        Token tag = PreJdk5AnnotationsProcessor.parseIdentifier();
        if (tag == null) {
            return false;
        }
        if (!PreJdk5AnnotationsProcessor.literalToken("=", true)) {
            return false;
        }
        Object val = PreJdk5AnnotationsProcessor.parseValue();
        if (val == null) {
            return false;
        }
        map.put(tag.getImage(), val);
        return true;
    }

    private static Object parseValue() {
        Token tok = PreJdk5AnnotationsProcessor.peekToken();
        if (tok.getKind() == 8) {
            return PreJdk5AnnotationsProcessor.parseArray();
        }
        if (tok.getKind() == 3) {
            PreJdk5AnnotationsProcessor.nextToken();
            return tok.getImage();
        }
        if (tok.getKind() == 5) {
            PreJdk5AnnotationsProcessor.nextToken();
            return new Integer(Integer.parseInt(tok.getImage()));
        }
        if (tok.getKind() == 2) {
            PreJdk5AnnotationsProcessor.nextToken();
            return PreJdk5AnnotationsProcessor.getIdentifierValue(tok);
        }
        PreJdk5AnnotationsProcessor.reportError(tok, "Expected '{', <STRING>, <NUMBER>, or <IDENTIFIER>. Found: ");
        return null;
    }

    private static Object[] parseArray() {
        ArrayList<Object> elems = new ArrayList<Object>();
        if (PreJdk5AnnotationsProcessor.literalToken("{", true)) {
            boolean done = false;
            while (!done) {
                Object val = PreJdk5AnnotationsProcessor.parseValue();
                if (val == null) {
                    return null;
                }
                elems.add(val);
                if (PreJdk5AnnotationsProcessor.literalToken("}", false)) {
                    done = true;
                    continue;
                }
                if (PreJdk5AnnotationsProcessor.literalToken(",", false)) {
                    done = false;
                    continue;
                }
                PreJdk5AnnotationsProcessor.reportError(PreJdk5AnnotationsProcessor.peekToken(), "Expected ',' or '}'. Found: ");
                return null;
            }
            Object[] ary = new Object[elems.size()];
            for (int i = 0; i < elems.size(); ++i) {
                ary[i] = elems.get(i);
            }
            return ary;
        }
        return null;
    }

    private static Token parseIdentifier() {
        Token id = PreJdk5AnnotationsProcessor.nextToken();
        if (id == null || id.getKind() != 2) {
            PreJdk5AnnotationsProcessor.reportError(id, "Expected <identifier>. Found : ");
            return null;
        }
        return id;
    }

    private static boolean literalToken(String expected, boolean emitError) {
        Token lit = PreJdk5AnnotationsProcessor.peekToken();
        if (lit != null && lit.getImage().equals(expected)) {
            PreJdk5AnnotationsProcessor.nextToken();
            return true;
        }
        if (emitError) {
            PreJdk5AnnotationsProcessor.reportError(lit, "Expected " + expected + " but found: ");
        }
        return false;
    }

    private static Object getIdentifierValue(Token tok) {
        String id = tok.getImage();
        Object o = null;
        o = PreJdk5AnnotationsProcessor.loadValue(new String[]{id});
        if (o != null) {
            return o;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < imports.size(); ++i) {
            String pref = imports.get(i);
            if (!pref.endsWith(".")) continue;
            ids.add(pref + id);
        }
        o = PreJdk5AnnotationsProcessor.loadValue(ids);
        if (o != null) {
            return o;
        }
        int pos = id.lastIndexOf(".");
        if (pos < 0) {
            ids = new ArrayList();
            for (int i = 0; i < imports.size(); ++i) {
                String pref = imports.get(i);
                if (pref.endsWith(".")) continue;
                ids.add(pref + "." + id);
            }
            o = PreJdk5AnnotationsProcessor.loadValue(ids);
            if (o != null) {
                return o;
            }
        } else {
            String prefix = id.substring(0, pos);
            id = id.substring(pos + 1);
            ids = new ArrayList();
            for (int i = 0; i < imports.size(); ++i) {
                String pref = imports.get(i);
                if (!pref.endsWith(prefix)) continue;
                ids.add(pref + "." + id);
            }
            o = PreJdk5AnnotationsProcessor.loadValue(ids);
            if (o != null) {
                return o;
            }
        }
        PreJdk5AnnotationsProcessor.reportError(tok, "Unable to determine the value of an identifier. Try a fully qualified identifier, ensure it is present in classpath, and ensure that the constant is present in the class. Found: ");
        return null;
    }

    private static Object loadValue(List<String> ids) {
        String[] ary = new String[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            ary[i] = ids.get(i);
        }
        return PreJdk5AnnotationsProcessor.loadValue(ary);
    }

    private static Object loadValue(String[] ids) {
        for (String id : ids) {
            try {
                int pos = id.lastIndexOf(".");
                String field = id.substring(pos + 1);
                String klasse = id.substring(0, pos);
                Class<?> c = Class.forName(klasse);
                Object o = c.getField(field).get(null);
                if (o == null) continue;
                return o;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private static void reportError(Token tok, String message) {
        if (Source.getFile() == null) {
            System.out.println("SEVERE: " + message);
            return;
        }
        String loc = tok == null ? Source.getFile().toString() + ":EOF" : tok.getSourcePosition().toString();
        String value = tok == null ? "<EOF>" : tok.getImage();
        System.out.println("SEVERE: " + loc + ": Parsing error: " + message + value);
    }

    private static void initialize(File f) {
        peek = 0;
        imports = new ArrayList<String>();
        try {
            lnr = new LineNumberReader(new FileReader(f));
        }
        catch (IOException ioe) {
            PreJdk5AnnotationsProcessor.reportError(null, "Exception occurred: " + ioe);
            peek = -1;
            try {
                lnr.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Source.setFile(f);
        PreJdk5AnnotationsProcessor.readChar();
        peekTok = PreJdk5AnnotationsProcessor.readToken();
    }

    private static int peekChar() {
        return peek;
    }

    private static int nextChar() {
        int next = peek;
        if (next >= 0) {
            char ch = (char)next;
            currentColumn = ch == '\n' || ch == '\r' ? 0 : ++currentColumn;
            currentLine = lnr.getLineNumber();
            PreJdk5AnnotationsProcessor.readChar();
        }
        return next;
    }

    private static int getColumn() {
        return currentColumn + 1;
    }

    private static int getLine() {
        return currentLine + 1;
    }

    private static void readChar() {
        if (peek < 0) {
            return;
        }
        try {
            peek = lnr.read();
            if (peek < 0) {
                lnr.close();
            }
        }
        catch (IOException ioe) {
            peek = -1;
            PreJdk5AnnotationsProcessor.reportError(null, "Exception occurred: " + ioe);
            try {
                lnr.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Token peekToken() {
        return peekTok;
    }

    private static Token nextToken() {
        Token nxt = peekTok;
        if (nxt != null) {
            peekTok = PreJdk5AnnotationsProcessor.readToken();
        }
        return nxt;
    }

    private static Token readToken() {
        int i;
        int column;
        int line;
        char ch;
        do {
            line = PreJdk5AnnotationsProcessor.getLine();
            column = PreJdk5AnnotationsProcessor.getColumn();
            i = PreJdk5AnnotationsProcessor.nextChar();
            if (i < 0) {
                return null;
            }
            ch = (char)i;
            if (ch == '@') {
                return new Token(1, ch, line, column);
            }
            if (ch == '(') {
                return new Token(6, ch, line, column);
            }
            if (ch == ')') {
                return new Token(7, ch, line, column);
            }
            if (ch == '{') {
                return new Token(8, ch, line, column);
            }
            if (ch == '}') {
                return new Token(9, ch, line, column);
            }
            if (ch == ',') {
                return new Token(10, ch, line, column);
            }
            if (ch == '=') {
                return new Token(11, ch, line, column);
            }
            if (ch == '\"') {
                StringBuffer sb = new StringBuffer();
                i = PreJdk5AnnotationsProcessor.nextChar();
                while (i >= 0 && (ch = (char)i) != '\"' && ch != '\n' && ch != '\r') {
                    if (ch == '\\') {
                        ch = (char)PreJdk5AnnotationsProcessor.nextChar();
                        if (ch == 't') {
                            sb.append('\t');
                        } else if (ch == 'r') {
                            sb.append('\r');
                        } else if (ch == 'n') {
                            sb.append('\n');
                        } else {
                            sb.append(ch);
                        }
                    } else {
                        sb.append(ch);
                    }
                    i = PreJdk5AnnotationsProcessor.nextChar();
                }
                return new Token(3, sb.toString(), line, column);
            }
            if (ch == '\'') {
                StringBuffer sb = new StringBuffer();
                i = PreJdk5AnnotationsProcessor.nextChar();
                while (i >= 0 && (ch = (char)i) != '\'' && ch != '\n' && ch != '\r') {
                    sb.append(ch);
                    i = PreJdk5AnnotationsProcessor.nextChar();
                }
                return new Token(4, sb.toString(), line, column);
            }
            if (!Character.isLetter(ch)) continue;
            StringBuffer sb = new StringBuffer();
            sb.append(ch);
            i = PreJdk5AnnotationsProcessor.peekChar();
            while (i >= 0 && ((ch = (char)i) == '.' || ch == '_' || ch == '$' || Character.isLetterOrDigit(ch))) {
                sb.append(ch);
                PreJdk5AnnotationsProcessor.nextChar();
                i = PreJdk5AnnotationsProcessor.peekChar();
            }
            return new Token(2, sb.toString(), line, column);
        } while ('0' > ch || ch > '9');
        StringBuffer sb = new StringBuffer();
        sb.append(ch);
        i = PreJdk5AnnotationsProcessor.peekChar();
        while (i >= 0 && (ch = (char)i) >= '0' && ch <= '9') {
            sb.append(ch);
            PreJdk5AnnotationsProcessor.nextChar();
            i = PreJdk5AnnotationsProcessor.peekChar();
        }
        return new Token(5, sb.toString(), line, column);
    }

    public static HashMap<String, AnnotationsProcessor.Entry[]> getResults() {
        return results;
    }

    public static void setFilter(String[] qualifiedName) {
        filter = qualifiedName;
    }

    public static String[] getFilter() {
        return filter;
    }

    public static int getAnnotationLevel() {
        return annotationLevel;
    }

    public static void setAnnotationLevel(int level) {
        if (level != 1) {
            System.out.println("SEVERE: " + PreJdk5AnnotationsProcessor.class.getName() + " supports class level annotations only.");
        } else {
            annotationLevel = level;
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            System.out.println("*** Processing " + args[i] + " ***");
            PreJdk5AnnotationsProcessor.process(new String[]{args[i]});
            HashMap<String, AnnotationsProcessor.Entry[]> res = PreJdk5AnnotationsProcessor.getResults();
            for (String key : res.keySet()) {
                AnnotationsProcessor.Entry[] entries;
                for (AnnotationsProcessor.Entry e : entries = res.get(key)) {
                    System.out.println(e.getSourcePosition().toString() + " @" + e.getAnnotationName() + "(");
                    HashMap<String, Object> props = e.getAnnotationProperties();
                    for (String attr : props.keySet()) {
                        Object o = props.get(attr);
                        System.out.println("   " + attr + " = " + o + ":" + o.getClass());
                    }
                    System.out.println("   )");
                }
            }
            System.out.println("*** Done " + args[i] + " ***");
        }
    }

    static {
        filter = null;
        annotationLevel = 1;
    }

    public static class Annotation {
        private String name;
        private HashMap<String, Object> map = new HashMap();

        public Annotation(String name) {
            this.name = name;
        }

        public Annotation(String name, HashMap<String, Object> map) {
            this.name = name;
            this.map = map;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue(String attribute) {
            return this.map.get(attribute);
        }

        public Iterator getAttributes() {
            return this.map.keySet().iterator();
        }

        public HashMap<String, Object> getMap() {
            return this.map;
        }
    }

    public static class Token {
        public static final int AT = 1;
        public static final int IDENTIFIER = 2;
        public static final int STRING = 3;
        public static final int CHAR = 4;
        public static final int NUMBER = 5;
        public static final int LPAREN = 6;
        public static final int RPAREN = 7;
        public static final int LBRACE = 8;
        public static final int RBRACE = 9;
        public static final int COMMA = 10;
        public static final int EQUALS = 11;
        private String image;
        private int kind;
        private SourcePosition sourcePosition;

        public Token(int kind, char ch, int line, int column) {
            this.kind = kind;
            this.image = Character.toString(ch);
            this.sourcePosition = new Source(line, column);
        }

        public Token(int kind, String image, int line, int column) {
            this.kind = kind;
            this.image = image;
            this.sourcePosition = new Source(line, column);
        }

        public int getKind() {
            return this.kind;
        }

        public String getImage() {
            return this.image;
        }

        public SourcePosition getSourcePosition() {
            return this.sourcePosition;
        }

        public static String toString(Token t) {
            if (t == null) {
                return "EOF:<EOF>";
            }
            String im = t.getImage();
            im = t.getKind() == 2 ? im + " (id)" : (t.getKind() == 4 ? "'" + im + "'" : (t.getKind() == 3 ? "\"" + im + "\"" : (t.getKind() == 5 ? im + " (num)" : "|" + im + "|")));
            return " " + t.sourcePosition.line() + "." + t.sourcePosition.column() + ": " + im + "\n";
        }
    }

    public static class Source
    implements SourcePosition {
        private int column;
        private int line;
        private File file;
        private static File theFile;

        public Source(int line, int column) {
            this.line = line;
            this.column = column;
            this.file = theFile;
        }

        public int line() {
            return this.line;
        }

        public int column() {
            return this.column;
        }

        public File file() {
            return this.file;
        }

        private static void setFile(File f) {
            theFile = f;
        }

        private static File getFile() {
            return theFile;
        }

        public String toString() {
            return this.file.toString() + ":" + this.line + "." + this.column;
        }
    }
}

