/*
 * Decompiled with CFR 0.152.
 */
package oracle.annotation.logging.processor;

import com.sun.javadoc.SourcePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import oracle.annotation.logging.Category;
import oracle.annotation.logging.Publish;
import oracle.annotation.logging.Severity;
import oracle.annotation.logging.processor.AnnotationsProcessor;
import oracle.annotation.logging.processor.BundleDescriptor;
import oracle.annotation.logging.processor.Util;

public class MessageDescriptor {
    private static final int BAD_ODL_LEVEL = -999;
    public static final Level INCIDENT_ERROR = new MyLevel("INCIDENT_ERROR", 1001);
    private BundleDescriptor bundleDescriptor;
    private String key;
    private String prefix;
    private String number;
    private SourcePosition sourcePosition;
    private String text;
    private String processedText;
    private String symbolicKey;
    private String associatedMethod;
    private Severity severity;
    private Category category = Category.OTHER;
    private Publish publish = Publish.UNKNOWN;
    private String[] causes = new String[0];
    private String[] actions = new String[0];
    private static final String TYPE_TRACE = "TRACE";
    private static final String TYPE_NOTIFICATION = "NOTIFICATION";
    private static final String TYPE_WARNING = "WARNING";
    private static final String TYPE_ERROR = "ERROR";
    private static final String TYPE_INCIDENT_ERROR = "INCIDENT_ERROR";
    private static final String TYPE_SET_AT_RUNTIME = "SET_AT_RUNTIME";
    private static final String[] ODL_TYPE_STRINGS = new String[]{"TRACE", "NOTIFICATION", "WARNING", "ERROR", "INCIDENT_ERROR"};
    private static final int[] ODL_TYPE_INDEXES = new int[]{290, 501, 801, 901, 1001};
    private static final int[][] ODL_LEVELS = new int[][]{{290, 301, 311, 317, 323, 329, 335, 341, 347, 353, 359, 365, 371, 377, 383, 389, 395, 401, 417, 423, 429, 435, 441, 447, 453, 459, 465, 471, 477, 483, 489, 495}, {501, 525, 536, 547, 558, 569, 580, 591, 602, 613, 624, 635, 646, 657, 668, 679, 690, 701, 717, 723, 729, 735, 741, 747, 753, 759, 765, 771, 777, 783, 789, 795}, {801, 808, 811, 814, 817, 820, 823, 826, 829, 832, 835, 838, 841, 844, 847, 850, 853, 856, 859, 862, 865, 868, 871, 874, 877, 880, 883, 886, 889, 892, 895, 898}, {901, 908, 911, 914, 917, 920, 923, 926, 929, 932, 935, 938, 941, 944, 947, 950, 953, 956, 959, 962, 965, 968, 971, 974, 977, 980, 983, 986, 989, 992, 995, 998}, {1001, 1008, 1011, 1014, 1017, 1020, 1023, 1026, 1029, 1032, 1035, 1038, 1041, 1044, 1047, 1050, 1053, 1056, 1059, 1062, 1065, 1068, 1071, 1074, 1077, 1080, 1083, 1086, 1089, 1092, 1095, 1098}};
    private List<String> errors = new ArrayList<String>();
    private static final int MAX_NUMBER_WIDTH = 5;
    private static final int MAX_NAME_WIDTH = 40;
    private static final int MAX_TEXT_WIDTH = 1000;
    private static final int MAX_CAUSE_ACTION_WIDTH = 4000;
    private boolean wasValidated = false;
    public static final String SEVERITY_SUFFIX = "_SEVERITY";
    public static final String SEVERITY_SUFFIX_ALT = "-SEVERITY";
    public static final String CAUSE_SUFFIX = "_CAUSE";
    public static final String CAUSE_SUFFIX_ALT = "-CAUSE";
    public static final String ACTION_SUFFIX = "_ACTION";
    public static final String ACTION_SUFFIX_ALT = "-ACTION";

    public MessageDescriptor(BundleDescriptor bd, AnnotationsProcessor.Entry entry) {
        Object o;
        this.bundleDescriptor = bd;
        this.sourcePosition = entry.getSourcePosition();
        HashMap<String, Object> h = entry.getAnnotationProperties();
        this.key = (String)h.get("id");
        if (this.key == null) {
            this.key = (String)h.get("*String-constant*");
            if (this.key == null) {
                this.key = "*unknown*";
                this.addError("Unable to determine message key.");
                System.out.println("SEVERE: " + this.getShortSourcePosition() + " @MessageInfo() is missing an id=\"...\" tag.");
            }
        }
        if ((o = Util.getAnnotationValue(h.get("severity"))) == null) {
            this.addError("Unable to determine severity for " + this.key + ", got: " + o + ". Should not occur.");
        } else if (o instanceof Severity) {
            this.severity = (Severity)((Object)o);
        } else {
            this.addError("Unable to determine severity for " + this.key + ", got: " + o + ". Should not occur.");
        }
        int pos = this.key.lastIndexOf("-");
        if (pos >= 0) {
            this.prefix = this.key.substring(0, pos);
            this.number = this.key.substring(pos + 1);
        } else {
            this.prefix = "";
            this.number = this.key;
            if (this.getSeverity() != Severity.SKIP) {
                this.addError("Unable to determine message prefix and number.");
            }
        }
        o = Util.getAnnotationValue(h.get("category"));
        if (o == null) {
            this.category = Category.UNASSIGNED;
        } else if (o instanceof Category) {
            this.category = (Category)((Object)o);
        } else {
            this.addError("Unable to determine category for " + this.key + ", got: " + o + ". Should not occur.");
        }
        o = Util.getAnnotationValue(h.get("publish"));
        if (o == null) {
            this.publish = Publish.UNKNOWN;
        } else if (o instanceof Publish) {
            this.publish = (Publish)((Object)o);
        } else {
            this.addError("Unable to determine publish setting for " + this.key + ", got: " + o + ". Should not occur.");
        }
        String[] types = new String[]{"cause", "action"};
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            o = Util.getAnnotationValue(h.get(type));
            if (o == null) continue;
            if (o instanceof Object[]) {
                Object[] arry;
                for (Object el : arry = (Object[])o) {
                    if (el instanceof String) {
                        if (type.equals("cause")) {
                            this.addCause((String)el);
                            continue;
                        }
                        this.addAction((String)el);
                        continue;
                    }
                    this.addError("Unable to determine " + type + " for " + this.key + ", got: " + el + ", class: " + el.getClass() + ". Should not occur.");
                }
                continue;
            }
            this.addError("Unable to determine " + type + " for " + this.key + ", got: " + o + " class: " + o.getClass() + ". Should not occur.");
        }
        this.associatedMethod = (String)h.get("*method*");
        try {
            this.text = bd.getBundle().getString(this.key);
            this.processedText = this.processText(this.text);
        }
        catch (Exception e) {
            this.addError("Key '" + this.key + "' not found in bundle " + bd.getQualifiedName());
        }
        this.symbolicKey = bd.getKeyConstant(this.key);
        if (this.getSeverity() == Severity.SET_IN_MESSAGE_BUNDLE) {
            try {
                Object sev = null;
                try {
                    sev = bd.getBundle().getObject(this.key + SEVERITY_SUFFIX);
                }
                catch (Exception exn) {
                    // empty catch block
                }
                if (sev == null) {
                    try {
                        sev = bd.getBundle().getObject(this.key + SEVERITY_SUFFIX_ALT);
                    }
                    catch (Exception exn) {
                        // empty catch block
                    }
                }
                if (sev == null) {
                    this.addError("Unable to obtain severity at " + this.key + SEVERITY_SUFFIX + " from the message bundle - no entry found.");
                    this.severity = null;
                } else if (sev instanceof Severity) {
                    if (sev != Severity.SET_IN_MESSAGE_BUNDLE) {
                        this.severity = (Severity)((Object)sev);
                    } else {
                        this.addError("The bundle entry at " + this.key + SEVERITY_SUFFIX + " is " + sev + ", which does not represent a permitted severity.");
                        this.severity = null;
                    }
                } else if (sev instanceof Level) {
                    Severity s = this.levelToSeverity((Level)sev);
                    if (s == null) {
                        this.addError("The bundle entry at " + this.key + SEVERITY_SUFFIX + " is a Java level: " + sev + ". It was not recognized as one of the" + " Java Level constants.");
                        this.severity = null;
                    } else {
                        this.severity = s;
                    }
                } else if (sev instanceof String) {
                    if (Util.isLevel((String)sev)) {
                        this.severity = Util.makeSeverity((String)sev);
                        if (this.getSeverity() == Severity.SET_IN_MESSAGE_BUNDLE) {
                            this.addError("The bundle entry at " + this.key + SEVERITY_SUFFIX + " is " + sev + ", which is not a permitted severity.");
                            this.severity = null;
                        }
                    } else {
                        this.addError("The bundle entry at " + this.key + SEVERITY_SUFFIX + " is \"" + sev + "\", which does not represent a severity.");
                        this.severity = null;
                    }
                } else {
                    this.addError("Unable to obtain severity at " + this.key + SEVERITY_SUFFIX + " from the message bundle. Found: " + sev + ":" + sev.getClass() + " but expected a String, a Severity, or a Level.");
                    this.severity = null;
                }
            }
            catch (Exception e) {
                this.addError("Unable to obtain severity at " + this.key + SEVERITY_SUFFIX + " from the message bundle - error: " + e);
                this.severity = null;
            }
        }
        try {
            String causeText = null;
            try {
                causeText = bd.getBundle().getString(this.key + CAUSE_SUFFIX);
            }
            catch (Exception exn) {
                // empty catch block
            }
            if (causeText == null) {
                try {
                    causeText = bd.getBundle().getString(this.key + CAUSE_SUFFIX_ALT);
                }
                catch (Exception exn) {
                    // empty catch block
                }
            }
            if (causeText != null) {
                if (this.getCauses() != null && this.getCauses().length > 0) {
                    this.addError("Use of cause=\"...\" annotation, and of explicit cause " + this.key + CAUSE_SUFFIX + " at the same time. This is confusing - please avoid.");
                }
                this.addCause(causeText);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String actionText = null;
            try {
                actionText = bd.getBundle().getString(this.key + ACTION_SUFFIX);
            }
            catch (Exception exn) {
                // empty catch block
            }
            if (actionText == null) {
                try {
                    actionText = bd.getBundle().getString(this.key + ACTION_SUFFIX_ALT);
                }
                catch (Exception exn) {
                    // empty catch block
                }
            }
            if (actionText != null) {
                if (this.getActions() != null && this.getActions().length > 0) {
                    this.addError("Use of action=\"...\" annotation, and of explicit action " + this.key + ACTION_SUFFIX + " at the same time. This is confusing - please avoid.");
                }
                this.addAction(actionText);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        bd.registerMessage(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.getBundleDescriptor().getQualifiedName() + "." + (this.getSymbolicKey() == null ? this.getKey() : this.getSymbolicKey());
    }

    public SourcePosition getSourcePosition() {
        return this.sourcePosition;
    }

    public String getShortSourcePosition() {
        String file = Util.getShortFileName(this.sourcePosition.file().toString());
        return file + ":" + this.sourcePosition.line();
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public BundleDescriptor getBundleDescriptor() {
        return this.bundleDescriptor;
    }

    public String getText() {
        return this.text;
    }

    public String getProcessedText() {
        return this.processedText;
    }

    public String getSymbolicKey() {
        return this.symbolicKey;
    }

    public String getAssociatedMethod() {
        return this.associatedMethod;
    }

    public Level getLevel() {
        if (this.getSeverity() == null) {
            return null;
        }
        switch (this.getSeverity()) {
            case INCIDENT_ERROR: {
                return INCIDENT_ERROR;
            }
            case SEVERE: {
                return Level.SEVERE;
            }
            case WARNING: {
                return Level.WARNING;
            }
            case CONFIG: {
                return Level.CONFIG;
            }
            case INFO: {
                return Level.INFO;
            }
            case FINE: {
                return Level.FINE;
            }
            case FINER: {
                return Level.FINER;
            }
            case FINEST: {
                return Level.FINEST;
            }
            case SET_AT_RUNTIME: {
                return Level.SEVERE;
            }
            case SET_IN_MESSAGE_BUNDLE: 
            case SKIP: {
                return null;
            }
        }
        throw new IllegalArgumentException("getLevel(): undefined Severity " + (Object)((Object)this.getSeverity()) + " - should not occur.");
    }

    public Severity levelToSeverity(Level lvl) {
        if (lvl == Level.OFF) {
            return Severity.SKIP;
        }
        if (lvl == Level.SEVERE) {
            return Severity.SEVERE;
        }
        if (lvl == Level.WARNING) {
            return Severity.WARNING;
        }
        if (lvl == Level.INFO) {
            return Severity.INFO;
        }
        if (lvl == Level.CONFIG) {
            return Severity.CONFIG;
        }
        if (lvl == Level.FINE) {
            return Severity.FINE;
        }
        if (lvl == Level.FINER) {
            return Severity.FINER;
        }
        if (lvl == Level.FINEST) {
            return Severity.FINEST;
        }
        return null;
    }

    public String getODLType() {
        if (this.getLevel() == null) {
            return "N/A";
        }
        return MessageDescriptor.typeFromJavaLevel(this.getLevel());
    }

    public int getODLLevel() {
        if (this.getLevel() == null) {
            return -999;
        }
        return MessageDescriptor.levelFromJavaLevel(this.getLevel());
    }

    public Category getCategory() {
        return this.category == Category.UNASSIGNED ? this.getBundleDescriptor().getDefaultCategory() : this.category;
    }

    public String getCategoryAsString() {
        return this.getCategory().toString();
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public Publish getPublish() {
        return this.publish;
    }

    public String getPublishAsString() {
        return this.getPublish().toString();
    }

    public void setPublish(Publish publish) {
        this.publish = publish;
    }

    public String[] getCauses() {
        return this.causes;
    }

    public void addCause(String cause) {
        if (cause == null) {
            return;
        }
        String[] tmp = new String[this.causes.length + 1];
        for (int i = 0; i < this.causes.length; ++i) {
            tmp[i] = this.causes[i];
        }
        tmp[this.causes.length] = cause;
        this.causes = tmp;
    }

    public String[] getActions() {
        return this.actions;
    }

    public void addAction(String action) {
        if (action == null) {
            return;
        }
        String[] tmp = new String[this.actions.length + 1];
        for (int i = 0; i < this.actions.length; ++i) {
            tmp[i] = this.actions[i];
        }
        tmp[this.actions.length] = action;
        this.actions = tmp;
    }

    public boolean needsCauseAction() {
        return (this.getSeverity() == Severity.SEVERE || this.getSeverity() == Severity.INCIDENT_ERROR) && this.isFiller(this.getCauses()) && this.isFiller(this.getActions());
    }

    private boolean isFiller(String[] s) {
        return s == null || s.length == 0 || s.length == 1 && (s[0] == null || s[0].trim().equals("") || s[0].equals("edit_cause") || s[0].equals("edit_action"));
    }

    private String processText(String messageText) {
        StringBuffer res = new StringBuffer();
        int start = 0;
        int pos1 = -1;
        int pos2 = -1;
        while (start < messageText.length()) {
            pos1 = messageText.indexOf("'", start);
            int n = pos2 = pos1 < 0 ? -1 : messageText.indexOf("'", pos1 + 1);
            if (pos1 < 0) {
                res.append(Util.escapeHtml(messageText.substring(start)));
                return res.toString();
            }
            if (pos2 < 0) {
                res.append(Util.escapeHtml(messageText.substring(start, pos1)));
                res.append("<b>==&gt;<large>'</large>&lt;== single, unclosed apostrophe!</b>");
                res.append(Util.escapeHtml(messageText.substring(pos1 + 1)));
                this.addError("Error: Opening but no corresponding closing apostrophe at column " + (pos1 + 1));
                return res.toString();
            }
            if (pos2 == pos1 + 1) {
                res.append(Util.escapeHtml(messageText.substring(start, pos1)));
                res.append("'");
                start = pos2 + 1;
                continue;
            }
            res.append(Util.escapeHtml(messageText.substring(start, pos1)));
            String quoted = messageText.substring(pos1 + 1, pos2);
            res.append("<code>" + Util.escapeHtml(quoted) + "</code>");
            start = pos2 + 1;
            if (quoted.indexOf(" ") < 0) continue;
            res.append("<b>&lt;&lt;== verbatim text was enclosed between apostrophes, which were stripped. Did you mean to use a '' (quoted double apostrophe)?</b>");
            this.addError("Warning: single apostrophes on columns " + (pos1 + 1) + " and " + (pos2 + 1) + " were stripped and the enclosed content became verbatim. " + " Did you mean to be using '' (quoted double apostrophe) instead?");
        }
        return res.toString();
    }

    private static int typeIndexFromLevel(int level) {
        int i;
        for (i = ODL_TYPE_INDEXES.length - 1; 0 <= i && level < ODL_TYPE_INDEXES[i]; --i) {
        }
        if (i >= 0) {
            return i;
        }
        return 0;
    }

    private static int levelIndexFromLevel(int level) {
        int i;
        int[] levels = ODL_LEVELS[MessageDescriptor.typeIndexFromLevel(level)];
        for (i = levels.length - 1; 0 <= i && level < levels[i]; --i) {
        }
        if (i >= 0) {
            return levels.length - i;
        }
        if (MessageDescriptor.typeIndexFromLevel(level) == 0) {
            return levels.length;
        }
        throw new IllegalArgumentException("Internal error mapping level " + level);
    }

    public static String typeFromJavaLevel(Level l) {
        return ODL_TYPE_STRINGS[MessageDescriptor.typeIndexFromLevel(l.intValue())];
    }

    public static int levelFromJavaLevel(Level l) {
        return MessageDescriptor.levelIndexFromLevel(l.intValue());
    }

    public void addError(String s) {
        this.errors.add(s);
    }

    boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public String[] getErrors() {
        String[] tmp = new String[this.errors.size()];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.errors.get(i);
        }
        return tmp;
    }

    public String[] printErrors() {
        String[] tmp = new String[this.errors.size()];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.getShortSourcePosition() + ": " + this.errors.get(i);
        }
        return tmp;
    }

    public String toString() {
        int i;
        this.validate();
        StringBuffer sb = new StringBuffer();
        sb.append("Message " + this.getKey() + " level=" + this.getLevel());
        sb.append(" odlLevel=" + this.getODLLevel() + " odlType=" + this.getODLType());
        if (this.getCategory() != null) {
            sb.append(" category=" + (Object)((Object)this.getCategory()));
        }
        if (this.getPublish() != null) {
            sb.append(" publish=" + (Object)((Object)this.getPublish()));
        }
        if (this.getSymbolicKey() != null) {
            sb.append(" symbolicKey=" + this.getSymbolicKey());
        }
        sb.append("\n");
        sb.append("   text=\"" + this.getText() + "\"" + "\n");
        if (this.getCauses().length > 0) {
            sb.append("   cause={");
            for (i = 0; i < this.getCauses().length; ++i) {
                sb.append(this.getCauses()[i]);
                if (i >= this.getCauses().length - 1) continue;
                sb.append(", ");
            }
            sb.append("}\n");
        }
        if (this.getActions().length > 0) {
            sb.append("   action={");
            for (i = 0; i < this.getActions().length; ++i) {
                sb.append(this.getActions()[i]);
                if (i >= this.getActions().length - 1) continue;
                sb.append(", ");
            }
            sb.append("}\n");
        }
        Iterator<String> it = this.errors.iterator();
        while (it.hasNext()) {
            sb.append("Error : " + it.next() + "\n");
        }
        return sb.toString();
    }

    private void validate() {
        if (this.wasValidated) {
            return;
        }
        this.wasValidated = true;
        if (this.getPrefix() == null || this.getPrefix().equals("")) {
            this.addError("Message " + this.getNumber() + " does not have a message prefix.");
        } else if (!this.getPrefix().equals(this.getPrefix().trim())) {
            this.addError("Message prefix \"" + this.getPrefix() + "\" contains leading or trailing space for message number " + this.getNumber() + ".");
        }
        String[] msg = new String[1];
        if (Util.checkInteger(this.getNumber(), "message", msg)) {
            if (this.getNumber().length() != 5) {
                this.addError("The message number '" + this.getNumber() + "' contains " + this.getNumber().length() + " digits. - It must consist of exactly " + 5 + " digits.");
                this.number = "0000000000" + this.getNumber();
                this.number = this.number.substring(this.number.length() - 5);
            }
        } else {
            this.addError(msg[0]);
        }
        if (!Util.checkString(this.getText(), 1000, "message", msg)) {
            this.addError(msg[0]);
        }
        String[] cs = this.getCauses();
        String[] as = this.getActions();
        int l = as.length < cs.length ? cs.length : as.length;
        for (int i = 0; i < l; ++i) {
            String action;
            String cause = i < cs.length ? cs[i] : null;
            String string = action = i < as.length ? as[i] : null;
            if (cause != null) {
                if (cause.trim().equals("")) {
                    this.addError("The cause text must not be empty.");
                } else if (!Util.checkString(cause, 4000, "cause", msg)) {
                    this.addError(msg[0]);
                }
            }
            if (action == null) continue;
            if (action.trim().equals("")) {
                this.addError("The action text must not be empty.");
                continue;
            }
            if (Util.checkString(action, 4000, "action", msg)) continue;
            this.addError(msg[0]);
        }
        if (this.getSeverity() == Severity.SEVERE || this.getSeverity() == Severity.INCIDENT_ERROR) {
            if (cs.length == 0) {
                this.addError("Message must provide cause (and action) if severity is SEVERE or higher.");
            } else if (as.length == 0) {
                this.addError("Message must provide action if severity is SEVERE or higher.");
            }
        }
    }

    public String toXML(int indent) {
        this.validate();
        if (this.hasErrors()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(Util.spaces(indent));
        sb.append("<message>");
        sb.append("\n");
        this.append(sb, indent + 4, "prefix", this.getPrefix(), false);
        this.append(sb, indent + 4, "number", this.getNumber(), false);
        this.append(sb, indent + 4, "text", this.getText(), true);
        this.append(sb, indent + 4, "category", Util.printCategory(this.getCategory()), false);
        this.append(sb, indent + 4, "type", this.getODLType(), false);
        this.append(sb, indent + 4, "level", "" + this.getODLLevel(), false);
        this.append(sb, indent + 4, "name", Util.getSuffix(this.getName(), 40), false);
        this.append(sb, indent + 4, "documented", Util.printPublish(this.getPublish(), this.getLevel(), this.getSeverity()), false);
        sb.append(Util.spaces(indent + 4));
        sb.append("<causes>");
        sb.append("\n");
        String[] cs = this.getCauses();
        String[] as = this.getActions();
        int l = as.length < cs.length ? cs.length : as.length;
        for (int i = 0; i < l; ++i) {
            String action;
            String cause = i < cs.length ? cs[i] : "";
            String string = action = i < as.length ? as[i] : "";
            if (cause.trim().equals("")) {
                this.append(sb, indent + 8, "cause", "See error message.", true);
            } else {
                this.append(sb, indent + 8, "cause", cause, true);
            }
            if (action.trim().equals("")) {
                this.append(sb, indent + 8, "action", "See error message.", true);
                continue;
            }
            this.append(sb, indent + 8, "action", action, true);
        }
        sb.append(Util.spaces(indent + 4));
        sb.append("</causes>");
        sb.append("\n");
        sb.append(Util.spaces(indent));
        sb.append("</message>");
        sb.append("\n");
        return sb.toString();
    }

    private void append(StringBuffer sb, int indent, String tag, String s, boolean quote) {
        sb.append(Util.spaces(indent));
        sb.append("<");
        sb.append(tag);
        sb.append(">");
        String content = quote ? Util.doQuote(s) : s;
        sb.append(content);
        sb.append("</");
        sb.append(tag);
        sb.append(">");
        sb.append("\n");
    }

    public String toHTML() {
        this.validate();
        StringBuffer sb = new StringBuffer();
        sb.append("<tr>\n");
        if (this.getBundleDescriptor().isMarked()) {
            sb.append("<td><b>" + this.getPrefix() + "-" + this.getNumber() + "</b></td>" + "\n");
        } else {
            sb.append("<td><i>(" + this.getPrefix() + this.getNumber() + ")</i></td>" + "\n");
        }
        if (this.getSeverity() == null) {
            sb.append("<td><b>Severity undefined</b></td>\n");
        } else {
            sb.append("<td>" + this.getODLType() + ":" + this.getODLLevel() + "</td>" + "\n");
        }
        sb.append("<td>" + (Object)((Object)this.getCategory()) + "</td>" + "\n");
        sb.append("<td>" + (Object)((Object)this.getPublish()) + "</td>" + "\n");
        sb.append("<td><i>" + this.getProcessedText() + "</i></td>" + "\n");
        sb.append("<td>");
        int cs = this.getCauses().length;
        int as = this.getActions().length;
        int m = cs > as ? cs : as;
        for (int i = 0; i < m; ++i) {
            if (i < cs) {
                sb.append(this.getCauses()[i]);
                sb.append("\n");
            }
            if (i < as) {
                sb.append(" <b>Action:</b> " + this.getActions()[i]);
                sb.append("\n");
            }
            if (i >= m - 1) continue;
            sb.append("<br>\n");
        }
        sb.append("</td>\n");
        sb.append("</tr>\n");
        return sb.toString();
    }

    private static class MyLevel
    extends Level {
        protected MyLevel(String s, int i) {
            super(s, i);
        }
    }
}

