/*
 * Decompiled with CFR 0.152.
 */
package oracle.annotation.logging.processor;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.annotation.logging.Severity;
import oracle.annotation.logging.processor.BundleDescriptor;
import oracle.annotation.logging.processor.Util;

public class GoFishing {
    private static final int TICK_MARK_COUNT = 100;
    private static List<Hit> hits;
    private static String file;
    private static String lines;
    private static List<Integer> columns;

    public static void goFishing(String[] rootDirectories, HashMap<String, BundleDescriptor> targets) {
        int i;
        ArrayList<String> files = new ArrayList<String>();
        for (String root : rootDirectories) {
            GoFishing.addJavaFilesFrom(root, files);
        }
        String[] targetTokens = targets.keySet().toArray(new String[0]);
        BundleDescriptor bb = targets.get(null);
        if (bb != null) {
            System.out.println("WARN!!! Null token from bundle " + bb);
        }
        System.out.print("[Going fishing for " + targetTokens.length + " tokens in " + files.size() + " files");
        GoFishing.setHits(new ArrayList<Hit>());
        for (i = 0; i < files.size(); ++i) {
            if (i % 100 == 0) {
                System.out.print(".");
            }
            GoFishing.setFile((String)files.get(i));
            try {
                GoFishing.readFile();
                GoFishing.findTargets(targetTokens);
                continue;
            }
            catch (IOException ioe) {
                System.out.println();
                System.out.println("ERROR: while reading " + GoFishing.getFile() + ": " + ioe.toString());
            }
        }
        System.out.println(", got " + GoFishing.getHits().size() + " potential locations]");
        for (i = 0; i < GoFishing.getHits().size(); ++i) {
            Hit h = GoFishing.getHits().get(i);
            BundleDescriptor bd = targets.get(h.getToken());
            if (bd == null) continue;
            bd.addUsageCandidate(h);
        }
    }

    private static void setHits(List<Hit> h) {
        hits = h;
    }

    private static List<Hit> getHits() {
        return hits;
    }

    private static String getFile() {
        return file;
    }

    private static void setFile(String f) {
        file = f;
    }

    private static void readFile() throws IOException {
        String line;
        File f = new File(GoFishing.getFile());
        LineNumberReader lnr = new LineNumberReader(new FileReader(f));
        StringBuffer sb = new StringBuffer();
        int colCount = -1;
        columns = new ArrayList<Integer>();
        columns.add(new Integer(colCount));
        while ((line = lnr.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
            columns.add(new Integer(colCount += line.length() + 1));
        }
        lnr.close();
        lines = sb.toString();
    }

    private static void findTargets(String[] targets) {
        for (String token : targets) {
            if (token == null) continue;
            GoFishing.findToken(token);
        }
    }

    private static void findToken(String token) {
        int pos = 0;
        while ((pos = lines.indexOf(token, pos)) >= 0) {
            int pastTokenPos = pos + token.length();
            if (!(pos > 0 && Character.isJavaIdentifierPart(lines.charAt(pos - 1)) || pastTokenPos < lines.length() && Character.isJavaIdentifierPart(lines.charAt(pastTokenPos)))) {
                int line = GoFishing.getIndex(pos);
                int column = pos - columns.get(line - 1);
                Hit h = new Hit(GoFishing.getFile(), line, column, token);
                Severity level = GoFishing.getLevel(GoFishing.getLine(line));
                if (level == null) {
                    level = GoFishing.getLevel(GoFishing.getLine(line + 1));
                }
                if (level == null) {
                    level = GoFishing.getLevel(GoFishing.getLine(line - 1));
                }
                if (level != null) {
                    h.setSeverity(level);
                }
                GoFishing.getHits().add(h);
            }
            pos = pastTokenPos;
        }
    }

    private static int getIndex(int pos) {
        return GoFishing.getIndex(pos, 1, columns.size() - 1);
    }

    private static int getIndex(int pos, int lower, int upper) {
        int idx = (lower + upper) / 2;
        int prevCount = columns.get(idx - 1);
        int count = columns.get(idx);
        if (pos <= prevCount) {
            return GoFishing.getIndex(pos, lower, idx - 1);
        }
        if (count < pos) {
            return GoFishing.getIndex(pos, idx + 1, upper);
        }
        return idx;
    }

    private static String getLine(int line) {
        int start = columns.get(line - 1) + 1;
        int end = columns.get(line) + 1;
        return lines.substring(start, end);
    }

    private static Severity getLevel(String line) {
        int pos = line.indexOf("Level.");
        while (pos > 0) {
            String token = Util.getFirstToken(line = line.substring(pos + "Level.".length()));
            if (Util.isLevel(token)) {
                return Util.makeSeverity(token);
            }
            pos = line.indexOf("Level.");
        }
        return null;
    }

    private static void addJavaFilesFrom(String root, List<String> currentList) {
        try {
            File directory = new File(root);
            GoFishing.getFilesFrom(directory, currentList);
        }
        catch (IOException ioe) {
            System.out.println("ERROR: while determining Java file under " + root);
        }
    }

    private static void getFilesFrom(File dir, List<String> res) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (!f.isFile() || !f.getName().endsWith(".java") || Util.isWptgFile(f.getName())) continue;
            res.add(f.toString());
        }
        for (File f : files) {
            if (!f.isDirectory() || f.getName().startsWith(".")) continue;
            GoFishing.getFilesFrom(f, res);
        }
    }

    public static void main(String[] args) {
        String[] roots = new String[]{args[0]};
        HashMap<String, BundleDescriptor> h = new HashMap<String, BundleDescriptor>();
        for (int i = 1; i < args.length; ++i) {
            h.put(args[i], null);
        }
        GoFishing.goFishing(roots, h);
        List<Hit> res = GoFishing.getHits();
        String lastFile = "";
        int fileCount = 0;
        for (int i = 0; i < res.size(); ++i) {
            Hit hit = res.get(i);
            System.out.println(hit);
            if (lastFile.equals(hit.getFileName())) continue;
            ++fileCount;
            lastFile = hit.getFileName();
        }
        System.out.println("Found " + res.size() + " occurrences in " + fileCount + " different files.");
    }

    public static class Hit {
        private int line;
        private int column;
        private String file;
        private Severity severity;
        private String token;

        private Hit(String f, int l, int c, String t) {
            this.file = f;
            this.line = l;
            this.column = c;
            this.token = t;
        }

        public String getFileName() {
            return this.file;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public String getToken() {
            return this.token;
        }

        public void setSeverity(Severity s) {
            this.severity = s;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public String toString() {
            return this.getFileName() + ":" + this.getLine() + "." + this.getColumn() + ": " + this.getToken();
        }
    }
}

