/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.StackWindowSettings;

public final class StackWindowSettingsPanel
extends DefaultTraversablePanel
implements ActionListener {
    private static final long serialVersionUID = 2661691893248046107L;
    private JComboBox vmChooser;
    private JLabel vmChooserLabel;
    private JCheckBox[] showColumnCheckBoxes;
    private JCheckBox showFullyQualifiedNamesCheckBox;
    private JPanel chooseColumnsPanel;
    private JPanel showQualifiedNamesPanel;
    private JPanel optionPanel;
    private JPanel spacer;
    private Map<String, boolean[]> showColumnsMap = new HashMap<String, boolean[]>();
    private Map<String, Boolean> fullyQualifiedNamesMap = new HashMap<String, Boolean>();
    private transient StackWindowSettings settings;
    private MultiLineLabel disclaimerLabel;

    public StackWindowSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_stackwindowsetpanel_html");
        this.setLayout(new GridBagLayout());
        this.showColumnCheckBoxes = new JCheckBox[5];
        for (int i = 0; i < 5; ++i) {
            this.showColumnCheckBoxes[i] = new JCheckBox();
            this.showColumnCheckBoxes[i].addActionListener(this);
        }
        this.showFullyQualifiedNamesCheckBox = new JCheckBox();
        this.showFullyQualifiedNamesCheckBox.addActionListener(this);
        this.optionPanel = new JPanel(new GridBagLayout());
        this.chooseColumnsPanel = new JPanel(new GridLayout(0, 2, 0, 0));
        this.showQualifiedNamesPanel = new JPanel(new GridLayout(0, 1, 0, 0));
        this.spacer = new JPanel();
        ResourceUtils.resButton((AbstractButton)this.showFullyQualifiedNamesCheckBox, (String)DbgArb.getString(857));
        this.vmChooser = new JComboBox();
        this.vmChooserLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.vmChooserLabel, (Component)this.vmChooser, (String)DbgArb.getString(860));
        this.disclaimerLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), DbgArb.getString(858));
    }

    private JPanel makeChooseColumnsPanel(String vmName) {
        boolean[] columnsVisible = this.showColumnsMap.get(vmName);
        this.chooseColumnsPanel.removeAll();
        List<String> columnNames = this.settings.getColumnNames(vmName);
        for (int i = 0; i < columnNames.size(); ++i) {
            ResourceUtils.resButton((AbstractButton)this.showColumnCheckBoxes[i], (String)columnNames.get(i));
            this.showColumnCheckBoxes[i].setSelected(columnsVisible[i]);
            this.chooseColumnsPanel.add(this.showColumnCheckBoxes[i]);
        }
        this.showColumnCheckBoxes[0].setEnabled(false);
        return this.chooseColumnsPanel;
    }

    private JPanel makeFullyQualifiedNamesPanel(String vmName) {
        this.showQualifiedNamesPanel.removeAll();
        this.showQualifiedNamesPanel.add(this.showFullyQualifiedNamesCheckBox);
        this.showFullyQualifiedNamesCheckBox.setSelected(this.fullyQualifiedNamesMap.get(vmName));
        return this.showQualifiedNamesPanel;
    }

    private StackWindowSettings getData(TraversableContext tc) {
        return StackWindowSettings.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        this.settings = this.getData(tc);
        this.removeAll();
        this.showColumnsMap.clear();
        this.fullyQualifiedNamesMap.clear();
        this.add((Component)this.disclaimerLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(6, 0, 16, 0), 0, 0));
        this.vmChooser.removeAllItems();
        int y = 1;
        List<String> vmNames = this.settings.getVMNames();
        if (vmNames.size() > 0) {
            for (String vmName : vmNames) {
                this.vmChooser.addItem(vmName);
                boolean[] visibilities = new boolean[5];
                for (int j = 0; j < 5; ++j) {
                    visibilities[j] = this.settings.getColumnVisible(vmName, j);
                }
                this.showColumnsMap.put(vmName, visibilities);
                this.fullyQualifiedNamesMap.put(vmName, this.settings.isShowFullyQualifiedNames(vmName));
            }
            this.vmChooser.setEditable(false);
            if (vmNames.size() > 1) {
                this.add(this.vmChooserLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 8, 8), 0, 0));
                this.add(this.vmChooser, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 8, 0), 0, 0));
            }
            this.add(this.optionPanel, new GridBagConstraints(0, y++, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.vmChooser.addActionListener(this);
            this.vmChooser.setSelectedIndex(0);
            for (int i = 0; i < 5; ++i) {
                this.showColumnCheckBoxes[i].addActionListener(this);
            }
            this.showFullyQualifiedNamesCheckBox.addActionListener(this);
        } else {
            this.add(this.spacer, new GridBagConstraints(0, y, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        StackWindowSettings settings = this.getData(tc);
        for (String vmName : this.showColumnsMap.keySet()) {
            boolean[] columnVisibilities = this.showColumnsMap.get(vmName);
            for (int i = 0; i < columnVisibilities.length; ++i) {
                settings.setColumnVisible(vmName, i, columnVisibilities[i]);
            }
            settings.setShowFullyQualifiedNames(vmName, this.fullyQualifiedNamesMap.get(vmName));
        }
        this.vmChooser.removeActionListener(this);
        for (int i = 0; i < 5; ++i) {
            this.showColumnCheckBoxes[i].removeActionListener(this);
        }
        this.showFullyQualifiedNamesCheckBox.removeActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.vmChooser) {
            String newVM = this.vmChooser.getSelectedItem().toString();
            this.optionPanel.removeAll();
            String title = DbgArb.format(859, newVM);
            TitledBorder border = BorderFactory.createTitledBorder(title);
            this.optionPanel.setBorder(border);
            this.optionPanel.add((Component)this.makeFullyQualifiedNamesPanel(newVM), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, 8, 0, 0), 0, 0));
            this.optionPanel.add((Component)this.makeChooseColumnsPanel(newVM), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(8, 8, 0, 0), 0, 0));
            this.optionPanel.add((Component)this.spacer, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.optionPanel.revalidate();
        } else if (e.getSource() == this.showFullyQualifiedNamesCheckBox) {
            String currentVM = this.vmChooser.getSelectedItem().toString();
            this.fullyQualifiedNamesMap.put(currentVM, this.showFullyQualifiedNamesCheckBox.isSelected());
        } else {
            for (int i = 0; i < this.showColumnCheckBoxes.length; ++i) {
                if (e.getSource() != this.showColumnCheckBoxes[i]) continue;
                String currentVM = this.vmChooser.getSelectedItem().toString();
                boolean[] visibilities = this.showColumnsMap.get(currentVM);
                visibilities[i] = this.showColumnCheckBoxes[i].isSelected();
                break;
            }
        }
    }
}

