/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.model.Element;
import oracle.ide.peek.Peek;
import oracle.ide.peek.PeekableTable;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.debugger.support.DebuggerWindowColumnOptions;
import oracle.jdeveloper.debugger.support.DebuggerWindowOptions;
import oracle.jdevimpl.debugger.BaseElement;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.DebuggerJavaStackWindowOptions;
import oracle.jdevimpl.debugger.support.DebuggerXsltStackWindowOptions;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DataController;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggerWindow;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.InspectorWindow;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.LocalsWindow;
import oracle.jdevimpl.runner.debug.StackWindowSettings;
import oracle.jdevimpl.runner.debug.ThreadsPanel;
import oracle.jdevimpl.runner.debug.UpdateableDataWindow;
import oracle.jdevimpl.runner.debug.Utils;
import oracle.jdevimpl.runner.debug.WatchWindow;
import oracle.jdevimpl.runner.debug.WindowSettingsColumnManager;

final class StackWindow
extends DebuggerWindow
implements ListSelectionListener,
Controller,
ContextMenuListener,
ColumnMenuListener {
    private List tableData;
    private JTable table;
    private StackTableCellRenderer stackTableCellRenderer;
    private StackTableModel model;
    private DebuggerWindowOptions windowOptions;
    private DebugStackFrameInfo highlightStackFrame;
    private boolean skippedUpdate = true;
    private DebuggingProcess debuggingProcess;
    private DebugVirtualMachine vm;
    private DebugThreadInfo thread;
    private int languages;
    private JScrollPane scrollPane;
    private StackWindowSettings stackWindowSettings;
    private int preferredVisibleRowCount = 6;
    private static IdeAction actionPopToHere;
    private static IdeAction actionRestartMethod;
    private static IdeAction actionGoTo;
    private static IdeAction actionViewAnnotations;
    private static IdeAction actionBytecode;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemPopToHere;
    private static JMenuItem menuItemRestartMethod;
    private static JMenuItem menuitemGoTo;
    private static JMenuItem menuitemViewAnnotations;
    private static JMenuItem menuitemBytecode;
    private static JMenuItem menuitemSave;
    private static JMenuItem menuitemSettings;
    private static int POPTOHERE_CMD_ID;
    private static int RESTARTMETHOD_CMD_ID;
    private static int GOTO_CMD_ID;
    private static int VIEW_ANNOTATIONS_CMD_ID;
    private static int BYTECODE_CMD_ID;
    private static int SAVE_CMD_ID;
    private static int SETTINGS_CMD_ID;
    static final int NUMBER_OF_COLUMNS = 5;
    private TableColumn[] column = new TableColumn[5];
    private int[] columnDefaultWidth = new int[5];
    private boolean[] columnShowing = new boolean[5];
    private boolean[] columnNumeric = new boolean[5];
    static final String STACK_WINDOW_ID = "Debugger.StackWindow";
    private static final String NOT_AVAILABLE = "";
    private boolean allowUpdateDataWindows = true;
    private JPanel stackPanel;
    private JComboBox<ThreadItem> threadBox;
    private boolean ignoreThreadBox;
    private Toolbar toolbar;
    private boolean showFullyQualifiedNames;
    private boolean adjustColumnsAlreadyDone = false;

    StackWindow() {
        super(STACK_WINDOW_ID);
    }

    void updateLocalsWindow(boolean forceCreate) {
        LocalsWindow localsWindow = JDebugger.getInstance().getLocalsWindow(forceCreate);
        if (localsWindow != null) {
            this.updateData(localsWindow);
        }
    }

    void updateWatchWindow(boolean forceCreate) {
        WatchWindow watchWindow = JDebugger.getInstance().getWatchWindow(forceCreate);
        if (watchWindow != null) {
            this.updateData(watchWindow);
        }
    }

    void newInspectorWindow(InspectorWindow inspectorWindow) {
        this.updateData(inspectorWindow);
    }

    @Override
    @Deprecated
    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.WEST;
    }

    @Override
    public void refresh() {
        this.everythingChanged();
    }

    @Deprecated
    public boolean installByDefault() {
        return true;
    }

    public void shutDown() {
        this.saveSettings();
    }

    void stackWindowSettingsChanged(boolean changed) {
        if (this.vm != null) {
            String vmID = this.vm.getID();
            this.showFullyQualifiedNames = this.stackWindowSettings.isShowFullyQualifiedNames(vmID);
            if (this.table == null) {
                return;
            }
            for (int i = 0; i < 5; ++i) {
                boolean show = this.stackWindowSettings.getColumnVisible(vmID, i);
                if (this.columnShowing[i] == show) continue;
                this.columnShowing[i] = show;
                if (show) {
                    this.table.addColumn(this.column[i]);
                    continue;
                }
                this.table.removeColumn(this.column[i]);
            }
            if (changed && this.table.isEnabled()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < 5; ++i) {
                            StackWindow.this.updateColumn(i);
                        }
                    }
                });
            }
            Dimension d = this.table.getPreferredSize();
            d.height = this.table.getTableHeader().getPreferredSize().height + this.preferredVisibleRowCount * this.table.getRowHeight() + this.scrollPane.getHorizontalScrollBar().getPreferredSize().height;
            this.scrollPane.setPreferredSize(d);
        }
    }

    private void saveSettings() {
        if (this.table == null || this.vm == null) {
            return;
        }
        String vmID = this.vm.getID();
        for (int i = 0; i < 5; ++i) {
            this.stackWindowSettings.setColumnWidth(vmID, i, this.column[i].getWidth());
            this.stackWindowSettings.setColumnVisible(vmID, i, this.columnShowing[i]);
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        String order = NOT_AVAILABLE;
        Enumeration<TableColumn> e = tableColumnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            order = order + column.getIdentifier() + ",";
        }
        this.stackWindowSettings.setColumnOrder(vmID, order);
    }

    private static void makeActions() {
        if (actionGoTo == null) {
            actionGoTo = IdeAction.findOrCreate((int)GOTO_CMD_ID, null, (String)DbgArb.getString(237), null, (Integer)DbgArb.getInteger(238), null, null, (boolean)false);
            actionGoTo.setEnabled(false);
            actionViewAnnotations = IdeAction.findOrCreate((int)VIEW_ANNOTATIONS_CMD_ID, null, (String)DbgArb.getString(239), null, (Integer)DbgArb.getInteger(240), null, null, (boolean)false);
            actionViewAnnotations.setEnabled(false);
            actionBytecode = IdeAction.findOrCreate((int)BYTECODE_CMD_ID, null, (String)DbgArb.getString(241), null, (Integer)DbgArb.getInteger(242), null, null, (boolean)false);
            actionBytecode.setEnabled(false);
            actionPopToHere = IdeAction.findOrCreate((int)POPTOHERE_CMD_ID, null, (String)DbgArb.getString(243), null, (Integer)DbgArb.getInteger(244), null, null, (boolean)false);
            actionPopToHere.setEnabled(false);
            actionRestartMethod = IdeAction.findOrCreate((int)RESTARTMETHOD_CMD_ID, null, (String)DbgArb.getString(245), null, (Integer)DbgArb.getInteger(246), null, null, (boolean)false);
            actionRestartMethod.setEnabled(false);
            actionRestartMethod.setName(DbgArb.getString(245));
            actionSettings = IdeAction.findOrCreate((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(98), null, (Integer)RunMgrArb.getInteger(99), null, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionSave = IdeAction.findOrCreate((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(96), null, (Integer)RunMgrArb.getInteger(97), null, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionGoTo, actionViewAnnotations, actionBytecode, actionPopToHere, actionRestartMethod, actionSettings, actionSave};
        JDebugger.setControllerForActions(actions, this);
    }

    public Component getGUI() {
        if (this.stackPanel == null) {
            POPTOHERE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackPopToHere");
            RESTARTMETHOD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugRestartMethodCommand");
            GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackGoTo");
            VIEW_ANNOTATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackViewAnnotations");
            BYTECODE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackBytecode");
            SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackSave");
            SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackSettings");
            StackWindow.makeActions();
            this.setControllerForActions();
            this.stackWindowSettings = StackWindowSettings.getInstance();
            this.createGUI();
            this.setNewVM(this.vm);
            DebugDockableFactory.updateSiteGeometry((Dockable)this);
            this.stackWindowSettings.addStructureChangeListener(new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent e) {
                    if (Utils.structureReallyChanged(e)) {
                        StackWindow.this.stackWindowSettingsChanged(true);
                    }
                }
            });
            JDebugger.getInstance().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        }
        return this.stackPanel;
    }

    public Toolbar getToolbar() {
        if (this.toolbar == null) {
            this.createThreadBox();
            this.toolbar = new Toolbar();
            this.toolbar.add(this.threadBox);
            this.toolbar.setMaximumSize(this.toolbar.getSize());
        }
        return this.toolbar;
    }

    public ContextMenu getContextMenu() {
        return JDebugger.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_deb_stackwindow_html");
    }

    public Controller getController() {
        return this;
    }

    public Context getContext(EventObject event) {
        DebugStackFrameInfo info;
        StackItem stackItem = this.getSelectedStackItem();
        JDIInformationProvider jdiInformationProvider = null;
        if (stackItem != null && (info = stackItem.getStackFrameInfo()) instanceof JDIInformationProvider) {
            jdiInformationProvider = (JDIInformationProvider)((Object)info);
        }
        return ContextBuilder.buildContext((Element)stackItem, (View)this, event, this.debuggingProcess, jdiInformationProvider);
    }

    public int getDefaultVisibility(Layout layout) {
        if (this.windowOptions != null && !this.windowOptions.isInitiallyVisible()) {
            return 0;
        }
        boolean visible = JDebugger.getInstance().canShowDebuggingWindows(layout);
        return visible ? 5 : 0;
    }

    public String getTabName() {
        if (this.windowOptions != null) {
            return this.windowOptions.getTitleName();
        }
        return DbgArb.getString(228);
    }

    public Icon getTabIcon() {
        if (this.windowOptions != null) {
            return this.windowOptions.getTabIcon();
        }
        return OracleIcons.getIcon((String)"debugger/stack.png");
    }

    public String getTitleName() {
        if (this.windowOptions != null) {
            return this.windowOptions.getTitleName();
        }
        return DbgArb.getString(228);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.table.isShowing()) {
            this.highlightStackFrame = this.getSelectedStackFrameInfo();
            this.updateData();
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == GOTO_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            stackItem.showInSource();
            return true;
        }
        if (cmdId == VIEW_ANNOTATIONS_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                stackItem.viewAnnotations();
            }
            return true;
        }
        if (cmdId == BYTECODE_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                stackItem.showBytecode();
            }
            return true;
        }
        if (cmdId == POPTOHERE_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                stackItem.popToHere();
            }
            return true;
        }
        if (cmdId == RESTARTMETHOD_CMD_ID) {
            DebugStackFrameInfo info;
            if (this.debuggingProcess != null && (info = this.getSelectedStackFrameInfo()) != null) {
                this.debuggingProcess.restartMethod(info.getFrameNumber(), context);
            }
            return true;
        }
        if (cmdId == SETTINGS_CMD_ID) {
            String[] path = new String[]{DbgArb.getString(620), DbgArb.getString(665)};
            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
            return true;
        }
        if (cmdId == SAVE_CMD_ID) {
            this.saveToFile();
            return true;
        }
        if (cmdId == 18) {
            Object o;
            int column;
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null && (column = this.table.getSelectedColumn()) != -1 && (o = stackItem.getValueOfColumn(column)) != null) {
                IdeUtil.copyToClipboard((String)o.toString());
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (action.getValue("Debugger.actionOwner") == this) {
            if (this.table == null || !this.isVisible()) {
                action.setEnabled(false);
                return true;
            }
            if (!(this.table.isEnabled() && this.debuggingProcess != null && this.vm != null || cmdId == SETTINGS_CMD_ID)) {
                action.setEnabled(false);
                return true;
            }
        }
        if (cmdId == GOTO_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                action.setEnabled(stackItem.canShowInSource());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == VIEW_ANNOTATIONS_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                action.setEnabled(stackItem.canViewAnnotations());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == BYTECODE_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                action.setEnabled(stackItem.canShowBytecode());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == POPTOHERE_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                action.setEnabled(stackItem.canPopToHere());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == RESTARTMETHOD_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                action.setEnabled(stackItem.canRestartMethod());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == SETTINGS_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == SAVE_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == 18) {
            StackItem stackItem = this.getSelectedStackItem();
            int column = this.table.getSelectedColumn();
            action.setEnabled(stackItem != null && column != -1);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        if (this.table != null && (Helpers.contextMatchesSource(context, this.table) || Helpers.contextMatchesSource(context, this.scrollPane))) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                this.addPopupMenuItemsForStackItem(popup, context);
            }
            this.addPopupMenuItemsForCommon(popup, context);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    @Override
    public void showColumn(int index) {
        this.columnShowing[index] = true;
        if (this.stackWindowSettings != null && this.vm != null) {
            this.stackWindowSettings.setColumnVisible(this.vm.getID(), index, true);
        }
        this.table.addColumn(this.column[index]);
    }

    @Override
    public void hideColumn(int index) {
        this.columnShowing[index] = false;
        if (this.stackWindowSettings != null && this.vm != null) {
            this.stackWindowSettings.setColumnVisible(this.vm.getID(), index, false);
        }
        this.table.removeColumn(this.column[index]);
    }

    private void createGUI() {
        this.tableData = new ArrayList();
        this.model = new StackTableModel();
        this.table = new PeekableStackTable(this.model);
        this.table.getAccessibleContext().setAccessibleName(this.getTitleName());
        this.table.setAutoResizeMode(DebugWindowSettings.getInstance().getTableResizeMode());
        Set emptySet = Collections.emptySet();
        this.table.setFocusTraversalKeys(0, emptySet);
        this.table.setFocusTraversalKeys(1, emptySet);
        Dimension spacing = new Dimension(0, 0);
        this.table.setIntercellSpacing(spacing);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < 5; ++i) {
            this.column[i] = tableColumnModel.getColumn(i);
            this.columnDefaultWidth[i] = this.column[i].getPreferredWidth();
            this.columnShowing[i] = true;
        }
        boolean[] showColumnInMenu = new boolean[5];
        Arrays.fill(showColumnInMenu, true);
        JDebugger.addColumnsMenu(this.table, this, showColumnInMenu);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(this);
        this.stackTableCellRenderer = new StackTableCellRenderer();
        this.table.setDefaultRenderer(String.class, this.stackTableCellRenderer);
        JTableHeader tableHeader = this.table.getTableHeader();
        final TableCellRenderer headerRenderer = tableHeader.getDefaultRenderer();
        tableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (headerRenderer instanceof DefaultTableCellRenderer) {
                    DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)headerRenderer;
                    int modelColumn = table.convertColumnIndexToModel(column);
                    int horizontalAlignment = StackWindow.this.columnNumeric[modelColumn] ? 4 : 2;
                    defaultTableCellRenderer.setHorizontalAlignment(horizontalAlignment);
                }
                return headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    StackWindow.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    StackWindow.this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (StackWindow.this.debuggingProcess == null || !StackWindow.this.debuggingProcess.isStopped()) {
                    Toolkit.getDefaultToolkit().beep();
                    DebuggingProcess.showStatus(DbgArb.format(310, StackWindow.this.getTitleName()));
                }
                if ((e.getModifiers() & 0x10) != 0 && e.getClickCount() == 2) {
                    Context context = StackWindow.this.getContext(e);
                    StackWindow.this.update(actionGoTo, context);
                    if (actionGoTo.isEnabled()) {
                        StackWindow.this.handleEvent(actionGoTo, context);
                    }
                }
            }
        });
        tableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (StackWindow.this.debuggingProcess == null || !StackWindow.this.debuggingProcess.isStopped()) {
                    Toolkit.getDefaultToolkit().beep();
                    DebuggingProcess.showStatus(DbgArb.format(310, StackWindow.this.getTitleName()));
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                switch (key) {
                    case 10: {
                        Context context = StackWindow.this.getContext(e);
                        StackWindow.this.update(actionGoTo, context);
                        if (!actionGoTo.isEnabled()) break;
                        StackWindow.this.handleEvent(actionGoTo, context);
                        e.consume();
                    }
                }
            }
        });
        this.scrollPane = new JScrollPane(this.table);
        Color background = this.table.getBackground();
        this.scrollPane.setBackground(background);
        this.scrollPane.getViewport().setBackground(background);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    StackWindow.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    StackWindow.this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (StackWindow.this.debuggingProcess == null || !StackWindow.this.debuggingProcess.isStopped()) {
                    Toolkit.getDefaultToolkit().beep();
                    DebuggingProcess.showStatus(DbgArb.format(310, StackWindow.this.getTitleName()));
                }
            }
        });
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                StackWindow.this.adjustColumnsAfterResize();
            }
        });
        this.table.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && StackWindow.this.table.isShowing()) {
                    StackWindow.this.nowShown();
                }
            }
        });
        this.stackPanel = new JPanel(new BorderLayout());
        this.stackPanel.add((Component)this.scrollPane, "Center");
        Toolbar toolbar = this.getToolbar();
        this.stackPanel.add((Component)toolbar, "North");
        toolbar.setVisible(false);
    }

    private void createThreadBox() {
        this.threadBox = new CustomCombo();
        JTextField threadBoxEditor = (JTextField)this.threadBox.getEditor().getEditorComponent();
        threadBoxEditor.getAccessibleContext().setAccessibleName(DbgArb.getString(841));
        this.threadBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof ThreadItem) {
                    this.setText(((ThreadItem)value).name);
                    this.setIcon(((ThreadItem)value).icon);
                }
                return c;
            }
        });
        this.threadBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object selectedItem;
                if (!StackWindow.this.isIgnoreThreadBox() && e.getStateChange() == 1 && (selectedItem = e.getItem()) instanceof ThreadItem) {
                    StackWindow.this.thread = ((ThreadItem)selectedItem).info;
                    StackWindow.this.highlightStackFrame = null;
                    StackWindow.this.updateModel();
                }
            }
        });
    }

    private boolean isIgnoreThreadBox() {
        return this.ignoreThreadBox;
    }

    private void adjustColumnsAfterResize() {
        if (this.adjustColumnsAlreadyDone) {
            return;
        }
        this.adjustColumnsAlreadyDone = true;
        JDebugger.adjustColumnsAfterResize(this.scrollPane, this.table);
    }

    void showPopup(MouseEvent e) {
        JDebugger.getInstance().showContextMenu(e, (DockableWindow)this, this.table);
    }

    private void addPopupMenuItemsForStackItem(ContextMenu popup, Context context) {
        this.update(actionRestartMethod, context);
        if (actionRestartMethod.isEnabled()) {
            if (menuItemRestartMethod == null) {
                menuItemRestartMethod = popup.createMenuItem((ToggleAction)actionRestartMethod);
            }
            popup.add((Component)menuItemRestartMethod, JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        }
        this.update(actionPopToHere, context);
        if (actionPopToHere.isEnabled()) {
            if (menuitemPopToHere == null) {
                menuitemPopToHere = popup.createMenuItem((ToggleAction)actionPopToHere);
            }
            popup.add((Component)menuitemPopToHere, JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        }
        this.update(actionGoTo, context);
        if (actionGoTo.isEnabled()) {
            if (menuitemGoTo == null) {
                menuitemGoTo = popup.createMenuItem((ToggleAction)actionGoTo);
            }
            popup.add((Component)menuitemGoTo, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
        this.update(actionViewAnnotations, context);
        if (actionViewAnnotations.isEnabled()) {
            if (menuitemViewAnnotations == null) {
                menuitemViewAnnotations = popup.createMenuItem((ToggleAction)actionViewAnnotations);
            }
            popup.add((Component)menuitemViewAnnotations, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionBytecode, context);
        if (actionBytecode.isEnabled()) {
            if (menuitemBytecode == null) {
                menuitemBytecode = popup.createMenuItem((ToggleAction)actionBytecode);
            }
            popup.add((Component)menuitemBytecode, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
        this.update(actionSave, context);
        if (actionSave.isEnabled()) {
            if (menuitemSave == null) {
                menuitemSave = popup.createMenuItem((ToggleAction)actionSave);
            }
            popup.add((Component)menuitemSave, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
        this.update(actionSettings, context);
        if (actionSettings.isEnabled()) {
            if (menuitemSettings == null) {
                menuitemSettings = popup.createMenuItem((ToggleAction)actionSettings);
            }
            popup.add((Component)menuitemSettings, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
    }

    private void selectRow(int row) {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.clearSelection();
        listSelectionModel.addSelectionInterval(row, row);
    }

    private void saveToFile() {
        ThreadsPanel.threadDump(new DebugThreadInfo[]{this.thread}, this.debuggingProcess, this.getContext(), RunMgrArb.format(100, this.getTitleName()), this.getTitleName());
    }

    private void nowShown() {
        if (this.skippedUpdate && this.table != null && this.table.isEnabled()) {
            this.updateModel();
        }
    }

    void everythingChanged() {
        this.highlightStackFrame = null;
        this.updateModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStack(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread) {
        block15: {
            if (vm != this.vm) {
                this.setNewVM(vm);
            }
            this.debuggingProcess = debuggingProcess;
            this.thread = thread;
            if (this.toolbar != null && this.toolbar.isVisible()) {
                this.ignoreThreadBox = true;
                try {
                    if (vm != null) {
                        DebugThreadInfo[] currentThreads = vm.listThreads();
                        Arrays.sort(currentThreads, new Comparator<DebugThreadInfo>(){

                            @Override
                            public int compare(DebugThreadInfo o1, DebugThreadInfo o2) {
                                return o1.getName().compareToIgnoreCase(o2.getName());
                            }
                        });
                        JComboBox<ThreadItem> jComboBox = this.threadBox;
                        synchronized (jComboBox) {
                            int threadCount = this.threadBox.getItemCount();
                            ThreadItem selectedItem = null;
                            for (DebugThreadInfo currentThread : currentThreads) {
                                ThreadItem threadItem = new ThreadItem(currentThread, debuggingProcess);
                                this.threadBox.addItem(threadItem);
                                if (thread == null || !thread.getName().equalsIgnoreCase(currentThread.getName())) continue;
                                selectedItem = threadItem;
                            }
                            for (int x = threadCount - 1; x >= 0; --x) {
                                this.threadBox.removeItemAt(x);
                            }
                            if (selectedItem != null) {
                                this.threadBox.setSelectedItem(selectedItem);
                            }
                            break block15;
                        }
                    }
                    if (this.threadBox == null) break block15;
                    JComboBox<ThreadItem> jComboBox = this.threadBox;
                    synchronized (jComboBox) {
                        this.threadBox.removeAllItems();
                    }
                }
                finally {
                    this.ignoreThreadBox = false;
                }
            }
        }
        this.highlightStackFrame = null;
        this.updateModel();
    }

    private void setNewVM(DebugVirtualMachine newVM) {
        String vmID;
        if (this.vm != null && this.table != null) {
            this.storeVmSettings(this.vm);
        }
        if (this.vm == null && newVM != null) {
            boolean visible;
            DockableWindow dockable;
            DockStation dockStation = DockStation.getDockStation();
            int status = dockStation.getDockableStatus((Dockable)(dockable = this.getCoreDebuggerWindow()));
            boolean minimized = (status & 4) > 0;
            boolean bl = visible = (status & 0x20) > 0;
            if (visible && !minimized) {
                DockStation.getDockStation().setDockableVisibleNoFocus((Dockable)dockable);
            }
        }
        this.vm = newVM;
        this.windowOptions = null;
        if (newVM != null) {
            this.windowOptions = newVM.getDebuggerWindowOptions(DebuggerWindowOptions.WindowId.StackWindow);
            if (this.windowOptions == DebuggerWindowOptions.DEFAULT) {
                this.windowOptions = this.languages == 4 ? new DebuggerXsltStackWindowOptions() : new DebuggerJavaStackWindowOptions();
            }
        }
        if (newVM != null && !this.stackWindowSettings.getVMNames().contains(newVM.getID())) {
            vmID = newVM.getID();
            this.stackWindowSettings.addVMName(vmID);
            for (int i = 0; i < this.windowOptions.getNumberOfColumns(); ++i) {
                this.stackWindowSettings.setColumnVisible(vmID, i, this.windowOptions.getColumnInfo(i).isVisibleByDefault());
            }
        }
        if (newVM != null && this.table != null) {
            int i;
            vmID = newVM.getID();
            this.showFullyQualifiedNames = this.stackWindowSettings.isShowFullyQualifiedNames(vmID);
            ArrayList<String> columnNames = new ArrayList<String>(this.windowOptions.getNumberOfColumns());
            for (i = 0; i < this.windowOptions.getNumberOfColumns(); ++i) {
                DebuggerWindowColumnOptions column = this.windowOptions.getColumnInfo(i);
                String columnName = column.getColumnName();
                if (columnName != null) {
                    columnNames.add(columnName);
                    this.columnNumeric[i] = column.isNumeric();
                    continue;
                }
                this.columnNumeric[i] = false;
            }
            this.stackWindowSettings.setColumnNames(this.vm.getID(), columnNames);
            for (i = 0; i < columnNames.size(); ++i) {
                String columnName = (String)columnNames.get(i);
                columnNames.set(i, StringUtils.stripMnemonic((String)columnName));
            }
            this.model.setColumnNames(columnNames.toArray(new String[columnNames.size()]));
            for (i = 0; i < 5; ++i) {
                this.column[i].setHeaderValue(this.model.getColumnName(i));
            }
            this.table.getTableHeader().repaint();
            this.stackWindowSettingsChanged(false);
            for (i = 0; i < 5; ++i) {
                int width = this.stackWindowSettings.getColumnWidth(vmID, i);
                if (width > 0) {
                    this.adjustColumnsAlreadyDone = true;
                    this.column[i].setPreferredWidth(width);
                    continue;
                }
                this.column[i].setPreferredWidth(this.columnNumeric[i] ? 37 : 75);
            }
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            String order = this.stackWindowSettings.getColumnOrder(vmID);
            if (order != null) {
                for (int i2 = 0; i2 < 5; ++i2) {
                    String identifier;
                    int comma = order.indexOf(44);
                    if (comma != -1) {
                        identifier = order.substring(0, comma);
                        order = order.substring(comma + 1);
                    } else {
                        identifier = order;
                    }
                    if (identifier.length() == 0) break;
                    try {
                        int from = tableColumnModel.getColumnIndex(identifier);
                        if (from == i2) continue;
                        this.table.moveColumn(from, i2);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.windowOptions != null) {
                this.getToolbar().setVisible(this.windowOptions.isElementVisible("ThreadComboBox"));
            }
        }
    }

    private void storeVmSettings(DebugVirtualMachine vm) {
        int i;
        HashStructure hash = this.stackWindowSettings.getHash();
        for (i = 0; i < 5; ++i) {
            WindowSettingsColumnManager.setColumnWidth(hash, vm.getID(), i, this.column[i].getWidth());
        }
        for (i = 0; i < 5; ++i) {
            WindowSettingsColumnManager.setColumnVisible(hash, vm.getID(), i, this.columnShowing[i]);
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        StringBuilder buf = new StringBuilder();
        Enumeration<TableColumn> e = tableColumnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            buf.append(column.getIdentifier());
            buf.append(',');
        }
        WindowSettingsColumnManager.setColumnOrder(hash, vm.getID(), buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateModel() {
        if (this.table == null) {
            return;
        }
        this.allowUpdateDataWindows = false;
        try {
            this.stackTableCellRenderer.clear();
            DebugStackFrameInfo saveHighlightFrame = this.highlightStackFrame;
            this.table.getSelectionModel().clearSelection();
            this.highlightStackFrame = saveHighlightFrame;
            if (this.highlightStackFrame == null && this.thread != null) {
                this.highlightStackFrame = this.thread.getStackFrame(0);
            }
            this.table.setEnabled(true);
            if (this.table.isShowing()) {
                this.skippedUpdate = false;
                if (this.debuggingProcess != null && this.vm != null && this.thread != null) {
                    DebugStackFrameInfo[] frames = this.thread != null ? this.thread.listStack() : new DebugStackFrameInfo[]{};
                    int framesLength = frames.length;
                    ArrayList<StackItem> stackItems = new ArrayList<StackItem>();
                    for (int i = 0; i < framesLength; ++i) {
                        stackItems.add(new StackItem(frames[i]));
                    }
                    saveHighlightFrame = this.highlightStackFrame;
                    this.updateTable(stackItems);
                    this.highlightStackFrame = saveHighlightFrame;
                    if (this.highlightStackFrame != null) {
                        int row = this.highlightStackFrame.getFrameNumber();
                        this.selectRow(row);
                    }
                } else {
                    this.updateTable(new ArrayList());
                }
            } else {
                this.skippedUpdate = true;
            }
        }
        finally {
            this.allowUpdateDataWindows = true;
        }
        this.updateData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearStack() {
        if (this.table == null) {
            return;
        }
        this.table.setEnabled(false);
        int size = this.tableData.size();
        for (int row = 0; row < size; ++row) {
            StackItem stackItem = (StackItem)((Object)this.tableData.get(row));
            stackItem.clearStack();
        }
        this.tableData.clear();
        if (this.toolbar != null && this.toolbar.isVisible()) {
            this.ignoreThreadBox = true;
            try {
                JComboBox<ThreadItem> jComboBox = this.threadBox;
                synchronized (jComboBox) {
                    this.threadBox.removeAllItems();
                }
            }
            finally {
                this.ignoreThreadBox = false;
            }
        }
        this.setNewVM(null);
        this.thread = null;
        this.updateData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processFinished(DebuggingProcess debuggingProcess) {
        WatchWindow watchWindow;
        JDebugger jdebugger;
        LocalsWindow localsWindow;
        if (this.debuggingProcess == debuggingProcess) {
            this.debuggingProcess = null;
            if (this.toolbar != null && this.toolbar.isVisible()) {
                this.ignoreThreadBox = true;
                try {
                    JComboBox<ThreadItem> jComboBox = this.threadBox;
                    synchronized (jComboBox) {
                        this.threadBox.removeAllItems();
                    }
                }
                finally {
                    this.ignoreThreadBox = false;
                }
            }
            this.highlightStackFrame = null;
            if (this.table != null) {
                this.table.setEnabled(true);
            }
            this.updateTable(new ArrayList());
        }
        if ((localsWindow = (jdebugger = JDebugger.getInstance()).getLocalsWindow(false)) != null) {
            localsWindow.processFinished(debuggingProcess);
        }
        if ((watchWindow = jdebugger.getWatchWindow(false)) != null) {
            watchWindow.processFinished(debuggingProcess);
        }
        Iterator i = jdebugger.getInspectorWindows();
        while (i.hasNext()) {
            InspectorWindow inspectorWindow = (InspectorWindow)i.next();
            inspectorWindow.processFinished(debuggingProcess);
        }
    }

    private void updateData() {
        if (this.vm != null) {
            this.vm.setCurrentStackFrame(this.highlightStackFrame);
        }
        if (this.allowUpdateDataWindows) {
            this.updateDebuggerExtenders();
            long milliTime = System.currentTimeMillis();
            this.updateLocalsWindow(false);
            this.updateWatchWindow(false);
            Iterator i = JDebugger.getInstance().getInspectorWindows();
            while (i.hasNext()) {
                InspectorWindow inspectorWindow = (InspectorWindow)i.next();
                this.updateData(inspectorWindow);
            }
            this.updateCustomWindows();
        }
    }

    void updateEvaluator(Evaluator evaluator) {
        if (this.table != null && this.table.isEnabled() && this.debuggingProcess != null && this.vm != null && this.thread != null) {
            evaluator.setDebugContext(this.vm, this.thread, this.highlightStackFrame);
        } else {
            evaluator.setDebugContext(null, null, null);
        }
    }

    private void updateData(UpdateableDataWindow updateableDataWindow) {
        if (updateableDataWindow != null) {
            if (this.table != null && this.table.isEnabled()) {
                if (this.debuggingProcess != null && this.vm != null && this.thread != null) {
                    updateableDataWindow.updateData(this.debuggingProcess, this.vm, this.thread, this.highlightStackFrame);
                } else {
                    updateableDataWindow.updateData(null, null, null, null);
                }
            } else {
                updateableDataWindow.clearData();
            }
        }
    }

    private void updateDebuggerExtenders() {
        if (this.debuggingProcess != null && this.vm != null && this.thread != null) {
            Evaluator evaluator = new Evaluator(true);
            evaluator.setDebugContext(this.vm, this.thread, this.highlightStackFrame);
            JDebugger.getInstance().setDebuggerExtendersEvaluator(this.debuggingProcess, evaluator);
        }
    }

    private void updateCustomWindows() {
        if (this.debuggingProcess != null && this.vm != null && this.thread != null) {
            Evaluator evaluator = new Evaluator(true);
            evaluator.setDebugContext(this.vm, this.thread, this.highlightStackFrame);
            JDebugger.getInstance().refreshCustomWindows(evaluator, this.debuggingProcess);
        }
    }

    private void updateTable(List stackItems) {
        this.tableData = stackItems;
        if (this.model != null) {
            this.model.fireTableChanged(new TableModelEvent(this.model));
        }
    }

    private void updateColumn(int column) {
        this.clearCacheForColumn(column);
        if (this.model != null && this.tableData != null) {
            this.model.fireTableChanged(new TableModelEvent(this.model, 0, this.tableData.size() - 1, column));
        }
    }

    void clearCacheForColumn(int column) {
        int size = this.tableData.size();
        for (int row = 0; row < size; ++row) {
            StackItem stackItem = (StackItem)((Object)this.tableData.get(row));
            stackItem.clearCacheForColumn(column);
        }
    }

    private StackItem getSelectedStackItem() {
        int row;
        if (this.table != null && 0 <= (row = this.table.getSelectedRow()) && row < this.tableData.size()) {
            return (StackItem)((Object)this.tableData.get(row));
        }
        return null;
    }

    private DebugStackFrameInfo getSelectedStackFrameInfo() {
        StackItem stackItem = this.getSelectedStackItem();
        if (stackItem != null) {
            return stackItem.getStackFrameInfo();
        }
        return null;
    }

    private static class CustomCombo
    extends JComboBox {
        private boolean layingOut = false;
        private final int MAX_WIDTH = 120;
        private int requestedWidth;

        @Override
        public void doLayout() {
            try {
                this.layingOut = true;
                super.doLayout();
            }
            finally {
                this.layingOut = false;
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = Math.min(120, d.width);
            return d;
        }

        @Override
        public Dimension getSize() {
            Dimension dim = super.getSize();
            if (!this.layingOut) {
                dim.width = Math.max(dim.width, super.getPreferredSize().width);
            }
            return dim;
        }
    }

    private class ThreadItem {
        DebugThreadInfo info;
        String name;
        Icon icon;

        ThreadItem(DebugThreadInfo info, DebuggingProcess debuggingProcess) {
            this.info = info;
            StringBuilder buf = new StringBuilder();
            buf.append(info.getName());
            buf.append(" (");
            buf.append(ThreadsPanel.getThreadStatus(debuggingProcess, info));
            buf.append(')');
            this.name = buf.toString();
            this.icon = ThreadsPanel.getThreadStatusIcon(debuggingProcess, info);
        }
    }

    private class PeekableStackTable
    extends PeekableTable {
        PeekableStackTable(TableModel model) {
            super(model);
        }

        public Peek createPeek(int row, int col) {
            StackItem item = (StackItem)((Object)StackWindow.this.tableData.get(row));
            Rectangle rect = this.getCellRect(row, 0, true);
            rect.add(this.getCellRect(row, this.getColumnCount() - 1, true));
            return item.getStackFrameInfo().getCodePeek((JComponent)((Object)this), rect, StackWindow.this.debuggingProcess.getProject());
        }
    }

    private final class StackItem
    extends BaseElement {
        private DebugStackFrameInfo stackFrame;
        private DebugLocation location;
        private DebugClassInfo clazz;
        private DebugMethodInfo method;
        private String filename;
        private int line;
        private int bc;
        private String[] cachedValues;

        StackItem(DebugStackFrameInfo stackFrame) {
            Icon icon;
            this.stackFrame = stackFrame;
            this.location = stackFrame.getLocation();
            if (this.location != null) {
                this.clazz = this.location.getClassInfo();
                this.method = this.location.getMethod();
                this.filename = this.location.getFilename();
                this.line = this.location.getLine();
                this.bc = this.location.getBytecodeOffset();
            }
            if ((icon = stackFrame.getIcon()) != null) {
                this.setIcon(icon);
            } else {
                this.setIcon(OracleIcons.getIcon((String)"method.png"));
            }
            this.cachedValues = new String[5];
        }

        void clearStack() {
            this.stackFrame = null;
            this.location = null;
            this.clazz = null;
            this.method = null;
        }

        void clearCacheForColumn(int column) {
            this.cachedValues[column] = null;
        }

        Object getValueOfColumn(int column) {
            if (this.cachedValues[column] == null) {
                DebugStackFrameInfo currentStackFrame = this.stackFrame;
                this.cachedValues[column] = currentStackFrame == null ? null : currentStackFrame.getStackWindowColumnValue(column, StackWindow.this.showFullyQualifiedNames);
            }
            return this.cachedValues[column] == null ? StackWindow.NOT_AVAILABLE : this.cachedValues[column];
        }

        String getToolTip(int column) {
            DebugStackFrameInfo currentStackFrame = this.stackFrame;
            return currentStackFrame == null ? StackWindow.NOT_AVAILABLE : currentStackFrame.getStackWindowColumnTooltip(column);
        }

        public String getShortLabel() {
            DebugStackFrameInfo currentStackFrame = this.stackFrame;
            return currentStackFrame == null ? StackWindow.NOT_AVAILABLE : currentStackFrame.getLabel();
        }

        public Object getData() {
            return this;
        }

        DebugStackFrameInfo getStackFrameInfo() {
            return this.stackFrame;
        }

        boolean canShowInSource() {
            DebuggingProcess currentDebuggingProcess;
            DebugStackFrameInfo currentStackFrame = this.stackFrame;
            if (currentStackFrame != null && currentStackFrame.getFrameNumber() == 0 && (currentDebuggingProcess = StackWindow.this.debuggingProcess) != null && currentDebuggingProcess.canDebuggerExtenderShowIPLocation()) {
                return true;
            }
            return this.location != null || this.clazz != null;
        }

        void showInSource() {
            DebugStackFrameInfo currentStackFrame = this.stackFrame;
            DebuggingProcess currentDebuggingProcess = StackWindow.this.debuggingProcess;
            if (currentStackFrame != null && currentStackFrame.getFrameNumber() == 0 && currentDebuggingProcess != null && currentDebuggingProcess.debuggerExtenderShowIPLocation()) {
                return;
            }
            if (currentDebuggingProcess != null) {
                if (this.location != null) {
                    currentDebuggingProcess.showLocation(this.location, true);
                } else if (this.clazz != null) {
                    currentDebuggingProcess.showSourceFile(this.clazz);
                }
            }
        }

        boolean canViewAnnotations() {
            DebugStackFrameInfo currentStackFrame = this.stackFrame;
            return currentStackFrame != null && currentStackFrame.hasAnnotations();
        }

        void viewAnnotations() {
            DebugAnnotationInfo[] annotations;
            DebugStackFrameInfo currentStackFrame = this.stackFrame;
            if (currentStackFrame != null && (annotations = currentStackFrame.getAnnotations()) != null && annotations.length > 0) {
                String dlgTitle = DbgArb.getString(264);
                DataController.showAnnotationsDialog(dlgTitle, null, StackWindow.this.debuggingProcess, StackWindow.this.vm, StackWindow.this.thread, this.stackFrame, annotations);
            }
        }

        boolean canRestartMethod() {
            DebugVirtualMachine currentVm = StackWindow.this.vm;
            DebugStackFrameInfo currentStackFrame = this.stackFrame;
            if (StackWindow.this.debuggingProcess != null && currentVm != null && StackWindow.this.thread != null && currentVm.getCapabilities().canPopFrames() && currentVm.getCapabilities().canStepIntoMethod() && currentStackFrame.getFrameNumber() < StackWindow.this.thread.getStackFrameCount() - 1) {
                for (int row = StackWindow.this.tableData.indexOf((Object)this); row >= 0; --row) {
                    StackItem stackItem = (StackItem)((Object)StackWindow.this.tableData.get(row));
                    DebugMethodInfo method = stackItem.method;
                    if (method == null) {
                        return false;
                    }
                    if ((method.getAccess() & 0x100) == 0) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        boolean canPopToHere() {
            DebugVirtualMachine currentVm = StackWindow.this.vm;
            DebugStackFrameInfo currentStackFrame = this.stackFrame;
            if (StackWindow.this.debuggingProcess != null && currentVm != null && StackWindow.this.thread != null && currentVm.getCapabilities().canPopFrames() && currentStackFrame != null && currentStackFrame.getFrameNumber() != 0) {
                for (int row = StackWindow.this.tableData.indexOf((Object)this); row >= 0; --row) {
                    StackItem stackItem = (StackItem)((Object)StackWindow.this.tableData.get(row));
                    DebugMethodInfo method = stackItem.method;
                    if (method == null) {
                        return false;
                    }
                    if ((method.getAccess() & 0x100) == 0) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        void popToHere() {
            if (this.canPopToHere()) {
                DebugStackFrameInfo currentStackFrame = this.stackFrame;
                DebuggingProcess currentDebuggingProcess = StackWindow.this.debuggingProcess;
                if (currentStackFrame != null && currentDebuggingProcess != null) {
                    currentStackFrame.popBackToHere();
                    currentDebuggingProcess.stackFramesPopped(StackWindow.this.thread);
                }
            }
        }

        boolean canShowBytecode() {
            DebugVirtualMachine currentVm = StackWindow.this.vm;
            DebugStackFrameInfo currentStackFrame = this.stackFrame;
            return currentVm != null && currentVm.getCapabilities().canDisassembleMethod() && currentStackFrame != null && this.method != null && currentStackFrame.getLanguage() == 1;
        }

        void showBytecode() {
            DebuggingProcess currentDebuggingProcess;
            if (this.canShowBytecode() && (currentDebuggingProcess = StackWindow.this.debuggingProcess) != null) {
                currentDebuggingProcess.showBytecode(this.method, this.bc);
            }
        }
    }

    private final class StackTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[5];

        private StackTableModel() {
        }

        @Override
        public int getRowCount() {
            return StackWindow.this.tableData.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        public Class getColumnClass(int column) {
            return String.class;
        }

        void setColumnNames(String[] columnNames) {
            this.columnNames = Arrays.copyOf(columnNames, columnNames.length);
        }

        @Override
        public String getColumnName(int column) {
            if (this.columnNames.length > column) {
                return this.columnNames[column];
            }
            return StackWindow.NOT_AVAILABLE;
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                StackItem stackItem = (StackItem)((Object)StackWindow.this.tableData.get(row));
                return stackItem.getValueOfColumn(column);
            }
            catch (Exception e) {
                e.printStackTrace();
                return StackWindow.NOT_AVAILABLE;
            }
        }

        private String getAccessibleNameAt(int row, int column) {
            int id = 229;
            String columnName = this.getColumnName(column);
            String value = (String)this.getValueAt(row, column);
            if (value.length() == 0) {
                value = DbgArb.getString(796);
            }
            return DbgArb.format(id, columnName, value);
        }
    }

    class StackTableCellRenderer
    extends DefaultTableCellRenderer {
        private StackItem stackItem;
        private int modelColumn;

        StackTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.stackItem = (StackItem)((Object)StackWindow.this.tableData.get(row));
            this.modelColumn = table.convertColumnIndexToModel(column);
            int horizontalAlignment = StackWindow.this.columnNumeric[this.modelColumn] ? 4 : 2;
            this.setHorizontalAlignment(horizontalAlignment);
            if (column == 0) {
                this.setIcon(this.stackItem.getIcon());
            } else {
                this.setIcon(null);
            }
            AccessibleContext ac = this.getAccessibleContext();
            String accessibleName = StackWindow.this.model.getAccessibleNameAt(row, this.modelColumn);
            if (accessibleName != null) {
                ac.setAccessibleName(accessibleName);
            }
            return this;
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return this.stackItem.getToolTip(this.modelColumn);
        }

        void clear() {
            this.stackItem = null;
        }
    }
}

