/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Icon;
import oracle.ide.ExtensionRegistry;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.xml.XMLUtil;
import oracle.ideimpl.runner.DataValueToStringBehavior;
import oracle.ideimpl.runner.DebuggerHook;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.Log;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.ValueExpressionHelper;

final class ObjectPreferences {
    static final String FILENAME = "debuggerObjectPreferences.xml";
    static final String HS_FILENAME = "debuggerObjectPreferencesHs.xml";
    static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"debugger-object-preferences");
    static final String ROOT_TAG = "debugger-object-preferences";
    static final String DATAFILTERS_FILENAME = "dataFilters.xml";
    static final String DATAFILTERS_NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"debugger-data-filters");
    static final String DATAFILTERS_ROOT_TAG = "data-filters";
    static final String DATAVALUES_FILENAME = "dataValues.xml";
    static final String DATAVALUES_NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"debugger-data-values");
    static final String DATAVALUES_ROOT_TAG = "data-values";
    static final String REMOVE_ENTRY = "debugger-object-preferences-remove-entry";
    private static final String CHANGED_VALUE_EXPRESSIONS_KEY = "changed-value-expressions";
    private static final String USE_TOSTRING_INSTEAD_OF_CHANGED_VALUE_EXPRESSIONS_KEY = "use-tostring-instead-of-changed-value-expressions";
    private static final String USE_TOSTRING_KEY = "use-tostring";
    private static final String WHEN_OVERRIDDEN_KEY = "when-overridden";
    private static final String WHEN_NO_EXPRESSION_KEY = "when-no-expression";
    private static final String CHANGED_VALUE_EXPRESSION_SUGGESTIONS_KEY = "changed-value-expression-suggestions";
    private static final String CHANGED_HIDDEN_FIELDS_KEY = "changed-hidden-fields";
    private static final String CHANGED_HIDE_ALL_FIELDS_KEY = "changed-hide-all-fields";
    private static final String CHANGED_EXPAND_EXPRESSIONS_KEY = "changed-expand-expressions";
    private static final String CHANGED_EXPAND_EXPRESSION_SUGGESTIONS_KEY = "changed-expand-expression-suggestions";
    private Map<String, String> _changedValueExpressions;
    private Set<String> _useToStringInsteadOfChangedValueExpressions;
    private Map<String, DataValueToStringBehavior> _toStringBehavior;
    private Map<String, List<String>> _changedValueExpressionSuggestions;
    private Map<String, String[]> _changedHiddenFields;
    private Set<String> _changedHideAllFields;
    private Map<String, String> _changedExpandExpressions;
    private Map<String, List<String>> _changedExpandExpressionSuggestions;
    private static final String TOSTRING_METHOD_INVOCATION_EXPRESSION = "toString()";
    private static final Log oplogger = new Log("OPLogger");
    private static List<String> dangerousCollectionTypes = new ArrayList<String>();
    private static List<String> dangerousMapEntryTypes = new ArrayList<String>();
    private static String EXPAND_EXPRESSION_DELIMITERS;

    ObjectPreferences() {
        this.loadChangedSettings();
    }

    public Log getLogger() {
        return oplogger;
    }

    Map<String, String> deepCloneValueExpressions() {
        return this.deepCloneExpressions(DebuggerHook.getExpressions(), this._changedValueExpressions);
    }

    void setChangedValueExpressions(Map<String, String> changedValueExpressions) {
        this._changedValueExpressions = this.setChangedExpressions(DebuggerHook.getExpressions(), changedValueExpressions);
    }

    void setChangedValueExpression(String className, String value) {
        Map<String, String> currentValueExpressions = this.deepCloneValueExpressions();
        if (value == null) {
            currentValueExpressions.remove(className);
        } else {
            currentValueExpressions.put(className, value);
        }
        this.setChangedValueExpressions(currentValueExpressions);
    }

    String getValueExpression(DebugClassInfo clazz, DebugDataObjectInfo data) {
        String className = clazz.getName();
        DataValueToStringBehavior localSetting = this._toStringBehavior.get(className);
        oplogger.trace("getValueExpression(" + className + ") with class-specific behavior " + localSetting);
        if (localSetting == null) {
            localSetting = this.getInheritedToStringBehaviorSetting(className);
        }
        String expression = this.getExpression(className, DebuggerHook.getExpression((String)className), this._changedValueExpressions);
        oplogger.trace("getValueExpression(" + className + ") sees class-level expression " + expression);
        if (localSetting.useExpressionAlways()) {
            if (expression == null) {
                oplogger.trace(className + " set to never use toString(), has no expression, value will be blank");
                return "";
            }
            oplogger.trace(className + " set to never use toString(), returning expression");
            return expression;
        }
        if (localSetting.isUseToStringOnlyWhenNoExpressionSpecified() && expression != null) {
            oplogger.trace(className + " set to favor expression when provided, returning expression " + expression);
            return expression;
        }
        if (localSetting.useToStringAlways()) {
            oplogger.trace(className + " set to always use toString()");
            return TOSTRING_METHOD_INVOCATION_EXPRESSION;
        }
        if (localSetting.useToStringIfOverridden()) {
            while (!className.equals("java.lang.Object")) {
                if (dangerousCollectionTypes.contains(className) && this.avoidToStringForElementsInCollection(data)) {
                    return expression;
                }
                if (className.equals("java.util.HashMap$Node") && this.avoidToStringForElementInHashMapNode(data)) {
                    if (expression != null && expression.contains("getValue")) {
                        oplogger.trace(className + " should avoid toString, and object display expression has dangerous getValue() invocation; using empty expression");
                        return "";
                    }
                    return expression;
                }
                if (ObjectPreferences.doesClassDeclareToStringMethod(clazz)) {
                    oplogger.trace(className + " has overridden toString(), will use it");
                    return TOSTRING_METHOD_INVOCATION_EXPRESSION;
                }
                for (DebugClassInfo iface : clazz.getInterfaces(0)) {
                    if (!ObjectPreferences.doesClassDeclareToStringMethod(iface)) continue;
                    oplogger.trace(className + "'s interface " + iface.getName() + " has overridden toString(), will use it");
                    return TOSTRING_METHOD_INVOCATION_EXPRESSION;
                }
                if ((clazz = clazz.getSuperClass(1)) == null) break;
                className = clazz.getName();
            }
            oplogger.trace(className + " has no overridden toString() in hierarchy, will use expression");
            return expression;
        }
        oplogger.trace("unexpected fall-through " + localSetting + " with expression " + expression);
        return null;
    }

    private static boolean doesClassDeclareToStringMethod(DebugClassInfo clazz) {
        DebugMethodInfo[] methods;
        for (DebugMethodInfo method : methods = clazz.getMethods()) {
            if (!method.getNameWithoutClass().equals("java.lang.String toString()")) continue;
            return true;
        }
        return false;
    }

    String getValueExpression(DebugDataObjectInfo dataObject) {
        return ValueExpressionHelper.getValueExpression(dataObject);
    }

    DataValueToStringBehavior getInheritedToStringBehaviorSetting(String currentScope) {
        String packagename = currentScope;
        while (packagename.indexOf(46) != -1) {
            packagename = packagename.substring(0, packagename.lastIndexOf(46));
            oplogger.trace("looking for package behavior for " + packagename + ".*");
            DataValueToStringBehavior packageBehavior = this._toStringBehavior.get(packagename + ".*");
            if (packageBehavior == null) continue;
            oplogger.trace(" found, object display toString preference for " + currentScope + " inherited from " + packagename);
            return packageBehavior;
        }
        oplogger.trace("OP override of toString behavior not found, object display toString preference for " + currentScope + " inherited from global");
        DataValueToStringBehavior globalBehavior = this._toStringBehavior.get("*");
        if (globalBehavior == null) {
            oplogger.trace("OP global toString behavior setting not found, initializing to default values");
            globalBehavior = new DataValueToStringBehavior();
            globalBehavior.setUseToString(true);
            globalBehavior.setUseToStringOnlyWhenOverridden(true);
            globalBehavior.setUseToStringOnlyWhenNoExpressionSpecified(true);
        }
        return globalBehavior;
    }

    void setUseToStringBehavior(String className, DataValueToStringBehavior behavior) {
        DataValueToStringBehavior inherited = this.getInheritedToStringBehaviorSetting(className);
        if (behavior.equals((Object)inherited)) {
            this._toStringBehavior.remove(className);
        } else {
            this._toStringBehavior.put(className, behavior);
        }
        this.saveChangedSettings();
    }

    DataValueToStringBehavior getUseToStringBehavior(String className) {
        if (this._toStringBehavior.containsKey(className)) {
            return this._toStringBehavior.get(className);
        }
        return this.getInheritedToStringBehaviorSetting(className);
    }

    Map<String, DataValueToStringBehavior> deepCloneToStringBehaviorMap() {
        Map clone = DebuggerHook.getToStringBehavior();
        oplogger.trace("OP.deepCloneToStringBehaviorMap loads " + clone.size() + " entries from hook");
        for (String className : this._toStringBehavior.keySet()) {
            clone.put(className, this._toStringBehavior.get(className));
        }
        oplogger.trace("OP.deepCloneToStringBehaviorMap merges " + this._toStringBehavior.size() + " user entries, clone size now " + clone.size());
        return clone;
    }

    void setUseToStringBehaviorMap(Map<String, DataValueToStringBehavior> behavior) {
        this._toStringBehavior = behavior;
    }

    List<String> getValueExpressionSuggestions(String className) {
        return this.getSuggestions(className, DebuggerHook.getExpressionSuggestions((String)className), this._changedValueExpressionSuggestions);
    }

    void addChangedValueExpressionSuggestion(String className, String suggestion) {
        this.addSuggestion(this._changedValueExpressionSuggestions, className, suggestion);
    }

    boolean isHiddenFieldsEmpty() {
        return !DebuggerHook.hasHideFields() && this._changedHiddenFields.isEmpty();
    }

    Map<String, String[]> deepCloneHiddenFields() {
        TreeMap<String, String[]> clone = new TreeMap<String, String[]>();
        Map hiddenFields = DebuggerHook.getHideFields();
        for (String className : hiddenFields.keySet()) {
            List list = (List)hiddenFields.get(className);
            String[] changedList = this._changedHiddenFields.get(className);
            if (changedList == null) {
                clone.put(className, list.toArray(new String[list.size()]));
                continue;
            }
            if (changedList.length == 0) continue;
            clone.put(className, changedList);
        }
        for (String className : this._changedHiddenFields.keySet()) {
            String[] userList;
            if (hiddenFields.get(className) != null || (userList = this._changedHiddenFields.get(className)).length <= 0) continue;
            clone.put(className, userList);
        }
        return clone;
    }

    void setChangedHiddenFields(Map<String, String[]> changedHiddenFields) {
        Map hiddenFields = DebuggerHook.getHideFields();
        for (String className : hiddenFields.keySet()) {
            if (changedHiddenFields.get(className) != null) continue;
            changedHiddenFields.put(className, new String[0]);
        }
        this._changedHiddenFields = changedHiddenFields;
    }

    List<String> getHiddenFields(String className) {
        String[] userArray = this._changedHiddenFields.get(className);
        if (userArray != null) {
            return Arrays.asList(userArray);
        }
        return DebuggerHook.getHideFields((String)className);
    }

    boolean isHideAllFieldsEmpty() {
        return !DebuggerHook.hasHideAllFields() && this._changedHideAllFields.isEmpty();
    }

    Set<String> deepCloneHideAllFields() {
        TreeSet<String> clone = new TreeSet<String>();
        List hideAllFields = DebuggerHook.getHideAllFields();
        for (String className : hideAllFields) {
            if (this._changedHideAllFields.contains(REMOVE_ENTRY + className)) continue;
            clone.add(className);
        }
        for (String className : this._changedHideAllFields) {
            if (className.startsWith(REMOVE_ENTRY) || hideAllFields.contains(className)) continue;
            clone.add(className);
        }
        return clone;
    }

    void setChangedHideAllFields(Set<String> hideAllFields) {
        for (String className : DebuggerHook.getHideAllFields()) {
            if (hideAllFields.contains(className)) continue;
            hideAllFields.add(REMOVE_ENTRY + className);
        }
        this._changedHideAllFields = hideAllFields;
    }

    private boolean getHideAllFields(String className) {
        if (this._changedHideAllFields.contains(REMOVE_ENTRY + className)) {
            return false;
        }
        if (this._changedHideAllFields.contains(className)) {
            return true;
        }
        return DebuggerHook.getHideAllFields((String)className);
    }

    Set<String> getTypesWhereAllFieldsShouldBeHidden(DebugDataObjectInfo dataObject) {
        HashSet<String> typesWhereAllFieldsShouldBeHidden = new HashSet<String>();
        if (!this.isHideAllFieldsEmpty()) {
            for (DebugClassInfo clazz = dataObject.getClassInfo(); clazz != null; clazz = clazz.getSuperClass(1)) {
                DebugClassInfo[] interfaces;
                String className = clazz.getName();
                if (this.getHideAllFields(className)) {
                    typesWhereAllFieldsShouldBeHidden.add(className);
                }
                if ((interfaces = clazz.getInterfaces()) == null) continue;
                int length = interfaces.length;
                for (int i = 0; i < length; ++i) {
                    String interfaceName = interfaces[i].getName();
                    if (!this.getHideAllFields(interfaceName)) continue;
                    typesWhereAllFieldsShouldBeHidden.add(interfaceName);
                }
            }
        }
        return typesWhereAllFieldsShouldBeHidden;
    }

    Map<String, String> deepCloneExpandExpressions() {
        return this.deepCloneExpressions(DebuggerHook.getExpansions(), this._changedExpandExpressions);
    }

    void setChangedExpandExpressions(Map<String, String> changedExpandExpressions) {
        this._changedExpandExpressions = this.setChangedExpressions(DebuggerHook.getExpansions(), changedExpandExpressions);
    }

    private String getExpandExpression(String className) {
        return this.getExpression(className, DebuggerHook.getExpansion((String)className), this._changedExpandExpressions);
    }

    List<String> getExpandExpressions(DebugDataObjectInfo dataObject) {
        HashSet<String> expressions = new HashSet<String>();
        for (DebugClassInfo clazz = dataObject.getClassInfo(); clazz != null; clazz = clazz.getSuperClass(1)) {
            DebugClassInfo[] interfaces;
            String className = clazz.getName();
            String expression = this.getExpandExpression(className);
            if (expression != null) {
                expressions.add(expression);
            }
            if ((interfaces = clazz.getInterfaces()) == null) continue;
            int length = interfaces.length;
            for (int i = 0; i < length; ++i) {
                String interfaceName = interfaces[i].getName();
                expression = this.getExpandExpression(interfaceName);
                if (expression == null) continue;
                expressions.add(expression);
            }
        }
        return new ArrayList<String>(expressions);
    }

    List<String> getExpandExpressionSuggestions(String className) {
        return this.getSuggestions(className, DebuggerHook.getExpressionSuggestions((String)className), this._changedExpandExpressionSuggestions);
    }

    void addChangedExpandExpressionSuggestion(String className, String suggestion) {
        this.addSuggestion(this._changedExpandExpressionSuggestions, className, suggestion);
    }

    Icon getIcon(String className) {
        return DebuggerHook.getIcon((String)className);
    }

    private Map<String, String> deepCloneExpressions(Map<String, String> added, Map<String, String> changed) {
        TreeMap<String, String> clone = new TreeMap<String, String>();
        for (String className : added.keySet()) {
            String value = added.get(className);
            String changedValue = changed.get(className);
            if (changedValue == null) {
                clone.put(className, value);
                continue;
            }
            if (changedValue.equals(REMOVE_ENTRY)) continue;
            clone.put(className, changedValue);
        }
        for (String className : changed.keySet()) {
            String changedValue;
            if (added.get(className) != null || (changedValue = changed.get(className)).equals(REMOVE_ENTRY)) continue;
            clone.put(className, changedValue);
        }
        return clone;
    }

    private Map<String, String> setChangedExpressions(Map<String, String> added, Map<String, String> changed) {
        for (String className : added.keySet()) {
            if (changed.get(className) != null) continue;
            changed.put(className, REMOVE_ENTRY);
        }
        return changed;
    }

    private String getExpression(String className, String expression, Map<String, String> changed) {
        String value = changed.get(className);
        if (value == null) {
            return expression;
        }
        if (!value.equals(REMOVE_ENTRY)) {
            return value;
        }
        return null;
    }

    private List<String> getSuggestions(String className, List<String> added, Map<String, List<String>> changed) {
        ArrayList<String> list = new ArrayList<String>();
        List<String> changedList = changed.get(className);
        if (changedList != null) {
            list.addAll(changedList);
        }
        if (added != null) {
            list.addAll(added);
        }
        return list;
    }

    private void addSuggestion(Map<String, List<String>> suggestions, String className, String suggestion) {
        List<String> list = suggestions.get(className);
        if (list == null) {
            list = new ArrayList<String>();
            suggestions.put(className, list);
        }
        if (!list.contains(suggestion)) {
            list.add(suggestion);
        }
    }

    static String[] tokenizeExpandExpression(String expression) {
        ArrayList<String> temp = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(expression, EXPAND_EXPRESSION_DELIMITERS);
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0) continue;
            temp.add(token);
        }
        return temp.toArray(new String[temp.size()]);
    }

    void saveChangedSettings() {
        try {
            if (this._changedValueExpressions.isEmpty() && this._useToStringInsteadOfChangedValueExpressions.isEmpty() && this._changedValueExpressionSuggestions.isEmpty() && this._changedHiddenFields.isEmpty() && this._changedHideAllFields.isEmpty() && this._changedExpandExpressions.isEmpty() && this._changedExpandExpressionSuggestions.isEmpty() && this._toStringBehavior.isEmpty()) {
                return;
            }
            URL url = ObjectPreferences.getXMLURL(HS_FILENAME);
            HashStructure hash = HashStructure.newInstance();
            this.storeStringMap(hash, this._changedValueExpressions, CHANGED_VALUE_EXPRESSIONS_KEY);
            this.storeSet(hash, this._useToStringInsteadOfChangedValueExpressions, USE_TOSTRING_INSTEAD_OF_CHANGED_VALUE_EXPRESSIONS_KEY);
            this.storeListMap(hash, this._changedValueExpressionSuggestions, CHANGED_VALUE_EXPRESSION_SUGGESTIONS_KEY);
            this.storeArrayMap(hash, this._changedHiddenFields, CHANGED_HIDDEN_FIELDS_KEY);
            this.storeSet(hash, this._changedHideAllFields, CHANGED_HIDE_ALL_FIELDS_KEY);
            this.storeStringMap(hash, this._changedExpandExpressions, CHANGED_EXPAND_EXPRESSIONS_KEY);
            this.storeListMap(hash, this._changedExpandExpressionSuggestions, CHANGED_EXPAND_EXPRESSION_SUGGESTIONS_KEY);
            this.storeToStringBehaviorMap(hash, this._toStringBehavior);
            HashStructureIO hashIo = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
            hashIo.save(url, (Object)hash);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void storeStringMap(HashStructure hash, Map<String, String> map, String name) {
        HashStructure mapHash = HashStructure.newInstance();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            mapHash.putString(entry.getKey(), entry.getValue());
        }
        hash.putHashStructure(name, mapHash);
    }

    private Map<String, String> loadStringMap(HashStructure hash, String name) {
        Object object;
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (hash.containsKey(name) && (object = hash.getObject(name)) instanceof HashStructure) {
            HashStructure mapHash = (HashStructure)object;
            for (String key : mapHash.persistentKeySet()) {
                map.put(key, mapHash.getObject(key).toString());
            }
        }
        return map;
    }

    private void storeToStringBehaviorMap(HashStructure hash, Map<String, DataValueToStringBehavior> behavior) {
        HashStructure isUseToStringHash = HashStructure.newInstance();
        HashStructure whenOverriddenHash = HashStructure.newInstance();
        HashStructure whenNoExpressionHash = HashStructure.newInstance();
        for (Map.Entry<String, DataValueToStringBehavior> entry : behavior.entrySet()) {
            isUseToStringHash.putBoolean(entry.getKey(), entry.getValue().isUseToString());
            whenOverriddenHash.putBoolean(entry.getKey(), entry.getValue().isUseToStringOnlyWhenOverridden());
            whenNoExpressionHash.putBoolean(entry.getKey(), entry.getValue().isUseToStringOnlyWhenNoExpressionSpecified());
        }
        hash.putHashStructure(USE_TOSTRING_KEY, isUseToStringHash);
        hash.putHashStructure(WHEN_OVERRIDDEN_KEY, whenOverriddenHash);
        hash.putHashStructure(WHEN_NO_EXPRESSION_KEY, whenNoExpressionHash);
    }

    private Map<String, DataValueToStringBehavior> loadToStringBehaviorMap(HashStructure hash) {
        Map map = DebuggerHook.getToStringBehavior();
        oplogger.trace("OP.loadToStringBehaviorMap loads " + map.size() + " entries from hook");
        if (hash.containsKey(USE_TOSTRING_KEY)) {
            DataValueToStringBehavior behavior;
            Object object = hash.getObject(USE_TOSTRING_KEY);
            if (object instanceof HashStructure) {
                HashStructure isUseToStringHash = (HashStructure)object;
                for (String key : isUseToStringHash.persistentKeySet()) {
                    behavior = new DataValueToStringBehavior();
                    behavior.setUseToString(isUseToStringHash.getBoolean(key));
                    map.put(key, behavior);
                }
            }
            if ((object = hash.getObject(WHEN_OVERRIDDEN_KEY)) instanceof HashStructure) {
                HashStructure whenOverriddenHash = (HashStructure)object;
                for (String key : whenOverriddenHash.persistentKeySet()) {
                    behavior = (DataValueToStringBehavior)map.get(key);
                    if (key == null) continue;
                    behavior.setUseToStringOnlyWhenOverridden(whenOverriddenHash.getBoolean(key));
                }
            }
            if ((object = hash.getObject(WHEN_NO_EXPRESSION_KEY)) instanceof HashStructure) {
                HashStructure whenNoExpressionHash = (HashStructure)object;
                for (String key : whenNoExpressionHash.persistentKeySet()) {
                    behavior = (DataValueToStringBehavior)map.get(key);
                    if (key == null) continue;
                    behavior.setUseToStringOnlyWhenNoExpressionSpecified(whenNoExpressionHash.getBoolean(key));
                }
            }
        }
        oplogger.trace("OP.loadToStringBehaviorMap loads user entries, map size now " + map.size());
        Set<String> useToStringClasses = this.loadSet(hash, USE_TOSTRING_INSTEAD_OF_CHANGED_VALUE_EXPRESSIONS_KEY);
        Iterator<String> iter = useToStringClasses.iterator();
        while (iter.hasNext()) {
            String className = iter.next();
            if (map.containsKey(className)) continue;
            DataValueToStringBehavior useToStringAlways = new DataValueToStringBehavior();
            useToStringAlways.setUseToString(true);
            oplogger.trace("OP.loadToStringBehaviorMap converts old-style useToString preference for " + className);
            map.put(className, useToStringAlways);
            iter.remove();
        }
        return map;
    }

    private void storeListMap(HashStructure hash, Map<String, List<String>> map, String name) {
        HashStructure mapHash = HashStructure.newInstance();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            List<String> list = entry.getValue();
            ListStructure listStruct = ListStructure.newInstance();
            listStruct.addAll(list);
            mapHash.putListStructure(entry.getKey(), listStruct);
        }
        hash.putHashStructure(name, mapHash);
    }

    private Map<String, List<String>> loadListMap(HashStructure hash, String name) {
        Object object;
        TreeMap<String, List<String>> map = new TreeMap<String, List<String>>();
        if (hash.containsKey(name) && (object = hash.getObject(name)) instanceof HashStructure) {
            HashStructure mapHash = (HashStructure)object;
            for (String key : mapHash.persistentKeySet()) {
                Object listObject = mapHash.getObject(key);
                if (!(listObject instanceof ListStructure)) continue;
                ListStructure listStruct = (ListStructure)listObject;
                ArrayList<String> list = new ArrayList<String>();
                for (Object listStructObject : listStruct) {
                    list.add(listStructObject.toString());
                }
                map.put(key, list);
            }
        }
        return map;
    }

    private void storeArrayMap(HashStructure hash, Map<String, String[]> map, String name) {
        HashStructure mapHash = HashStructure.newInstance();
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String[] strings = entry.getValue();
            ListStructure listStruct = ListStructure.newInstance();
            for (String s : strings) {
                listStruct.add((Object)s);
            }
            mapHash.putListStructure(entry.getKey(), listStruct);
        }
        hash.putHashStructure(name, mapHash);
    }

    private Map<String, String[]> loadArrayMap(HashStructure hash, String name) {
        Object object;
        TreeMap<String, String[]> map = new TreeMap<String, String[]>();
        if (hash.containsKey(name) && (object = hash.getObject(name)) instanceof HashStructure) {
            HashStructure mapHash = (HashStructure)object;
            for (String key : mapHash.persistentKeySet()) {
                Object listObject = mapHash.getObject(key);
                if (!(listObject instanceof ListStructure)) continue;
                ListStructure listStruct = (ListStructure)listObject;
                String[] strings = new String[listStruct.size()];
                for (int x = 0; x < listStruct.size(); ++x) {
                    strings[x] = listStruct.get(x).toString();
                }
                map.put(key, strings);
            }
        }
        return map;
    }

    private void storeSet(HashStructure hash, Set<String> set, String name) {
        ListStructure listStruct = ListStructure.newInstance();
        for (String s : set) {
            listStruct.add((Object)s);
        }
        hash.putListStructure(name, listStruct);
    }

    private Set<String> loadSet(HashStructure hash, String name) {
        Object object;
        TreeSet<String> set = new TreeSet<String>();
        if (hash.containsKey(name) && (object = hash.getObject(name)) instanceof ListStructure) {
            ListStructure listStruct = (ListStructure)object;
            for (Object listObject : listStruct) {
                set.add(listObject.toString());
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadChangedSettings() {
        try {
            URL hsUrl = ObjectPreferences.getXMLURL(HS_FILENAME);
            if (URLFileSystem.exists((URL)hsUrl)) {
                HashStructureIO hashIo = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
                Object hashObject = hashIo.load(hsUrl);
                if (hashObject instanceof HashStructure) {
                    HashStructure hash = (HashStructure)hashObject;
                    this._changedValueExpressions = this.loadStringMap(hash, CHANGED_VALUE_EXPRESSIONS_KEY);
                    this._useToStringInsteadOfChangedValueExpressions = this.loadSet(hash, USE_TOSTRING_INSTEAD_OF_CHANGED_VALUE_EXPRESSIONS_KEY);
                    this._changedValueExpressionSuggestions = this.loadListMap(hash, CHANGED_VALUE_EXPRESSION_SUGGESTIONS_KEY);
                    this._changedHiddenFields = this.loadArrayMap(hash, CHANGED_HIDDEN_FIELDS_KEY);
                    this._changedHideAllFields = this.loadSet(hash, CHANGED_HIDE_ALL_FIELDS_KEY);
                    this._changedExpandExpressions = this.loadStringMap(hash, CHANGED_EXPAND_EXPRESSIONS_KEY);
                    this._changedExpandExpressionSuggestions = this.loadListMap(hash, CHANGED_EXPAND_EXPRESSION_SUGGESTIONS_KEY);
                    this._toStringBehavior = this.loadToStringBehaviorMap(hash);
                }
                return;
            }
            URL url = ObjectPreferences.getXMLURL(FILENAME);
            if (URLFileSystem.exists((URL)url)) {
                this._changedValueExpressions = new TreeMap<String, String>();
                this._changedValueExpressionSuggestions = new TreeMap<String, List<String>>();
                this._changedHiddenFields = new TreeMap<String, String[]>();
                this._changedHideAllFields = new TreeSet<String>();
                this._changedExpandExpressions = new TreeMap<String, String>();
                this._changedExpandExpressionSuggestions = new TreeMap<String, List<String>>();
                Object2Dom o2d = Object2Dom.newInstance();
                Object[] load = (Object[])o2d.toObject(url, this.getClass().getClassLoader());
                int loadLength = load.length;
                if (loadLength > 0 && load[0] instanceof Map) {
                    this._changedValueExpressions.putAll((Map)load[0]);
                }
                if (loadLength > 1 && load[1] instanceof Map) {
                    this._changedValueExpressionSuggestions.putAll((Map)load[1]);
                }
                if (loadLength > 2 && load[2] instanceof Map) {
                    this._changedHiddenFields.putAll((Map)load[2]);
                }
                if (loadLength > 3 && load[3] instanceof Set) {
                    this._changedHideAllFields.addAll((Set)load[3]);
                }
                if (loadLength > 4 && load[4] instanceof Map) {
                    this._changedExpandExpressions.putAll((Map)load[4]);
                }
                if (loadLength > 5 && load[5] instanceof Map) {
                    this._changedExpandExpressionSuggestions.putAll((Map)load[5]);
                }
                return;
            }
            this.loadDataFilters();
            this.loadDataValues();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (this._changedValueExpressions == null) {
                this._changedValueExpressions = new TreeMap<String, String>();
            }
            if (this._useToStringInsteadOfChangedValueExpressions == null) {
                this._useToStringInsteadOfChangedValueExpressions = new TreeSet<String>();
            }
            if (this._changedExpandExpressionSuggestions == null) {
                this._changedValueExpressionSuggestions = new TreeMap<String, List<String>>();
            }
            if (this._changedHiddenFields == null) {
                this._changedHiddenFields = new TreeMap<String, String[]>();
            }
            if (this._changedHideAllFields == null) {
                this._changedHideAllFields = new TreeSet<String>();
            }
            if (this._changedExpandExpressions == null) {
                this._changedExpandExpressions = new TreeMap<String, String>();
            }
            if (this._changedExpandExpressionSuggestions == null) {
                this._changedExpandExpressionSuggestions = new TreeMap<String, List<String>>();
            }
            if (this._toStringBehavior == null) {
                this._toStringBehavior = DebuggerHook.getToStringBehavior();
                oplogger.trace("ObjectPreferences: no user settings file, loaded  " + this._toStringBehavior.size() + " entries from hook");
            }
        }
    }

    void loadDataFilters() {
        try {
            URL url = ObjectPreferences.getXMLURL(DATAFILTERS_FILENAME);
            Object2Dom o2d = Object2Dom.newInstance();
            Map dataFilters = (Map)o2d.toObject(url, this.getClass().getClassLoader());
            this._changedHiddenFields.putAll(dataFilters);
        }
        catch (FileNotFoundException url) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void loadDataValues() {
        try {
            URL url = ObjectPreferences.getXMLURL(DATAVALUES_FILENAME);
            Object2Dom o2d = Object2Dom.newInstance();
            Map dataValues = (Map)o2d.toObject(url, this.getClass().getClassLoader());
            this._changedValueExpressions.putAll(dataValues);
        }
        catch (FileNotFoundException url) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static URL getXMLURL(String filename) {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        URL url = er.getSystemDirectory(JDebugger.getExtensionID());
        return URLFactory.newURL((URL)url, (String)filename);
    }

    private boolean avoidToStringForElementInHashMapNode(DebugDataObjectInfo data) {
        oplogger.trace("For HashMap entry, must check element type for toString behavior");
        DebugMethodInfo valueMethod = this.getMethodNamed(data, "getValue");
        ArrayList<DebugDataObjectInfo> arguments = new ArrayList<DebugDataObjectInfo>();
        arguments.add(data);
        if (valueMethod == null) {
            return false;
        }
        DebugDataObjectInfo element = null;
        try {
            element = (DebugDataObjectInfo)valueMethod.invoke(arguments);
        }
        catch (Throwable t) {
            oplogger.trace("  failure invoking getValue()" + t.getMessage());
            return true;
        }
        if (element == null) {
            return false;
        }
        oplogger.trace(" map's getValue() method returned element " + element.getClassInfo().getName());
        String expressionForElement = this.getValueExpression(element.getClassInfo(), element);
        if (expressionForElement == null) {
            oplogger.trace("   element expression is null, safe to use toString()");
            return false;
        }
        if (expressionForElement.length() == 0) {
            oplogger.trace("   element expression is empty string, do not use toString() for map entry");
            return true;
        }
        if (expressionForElement.equals(TOSTRING_METHOD_INVOCATION_EXPRESSION)) {
            oplogger.trace("    element uses toString() for display, safe to use for map entry");
            return false;
        }
        oplogger.trace("   element uses non-toString expression:" + expressionForElement + ", OK to use toString() for map entry");
        return false;
    }

    private boolean avoidToStringForElementsInCollection(DebugDataObjectInfo data) {
        oplogger.trace("For collection where toString dumps content, must check element type in collection for toString behavior");
        DebugMethodInfo valuesMethod = this.getMethodNamed(data, "values");
        ArrayList<DebugDataObjectInfo> arguments = new ArrayList<DebugDataObjectInfo>();
        arguments.add(data);
        if (valuesMethod != null) {
            oplogger.trace("  have map type, invoking values() ... ");
            DebugDataObjectInfo setInfo = null;
            try {
                setInfo = (DebugDataObjectInfo)valuesMethod.invoke(arguments);
                if (setInfo == null) {
                    oplogger.trace("  map values() empty, so toString is harmless");
                    return false;
                }
                oplogger.trace("  ... got " + setInfo.getClassInfo().getName());
            }
            catch (Throwable t) {
                oplogger.trace("  failure invoking values()" + t.getMessage());
                return true;
            }
            arguments.clear();
            arguments.add(setInfo);
            data = setInfo;
        } else {
            oplogger.trace("  have list or set type, no values() call needed");
        }
        DebugMethodInfo iteratorMethod = this.getMethodNamed(data, "iterator");
        if (iteratorMethod == null) {
            oplogger.trace("  logic error: no iterator() method in " + data.getClassInfo().getName());
            return false;
        }
        DebugDataObjectInfo iterInfo = null;
        try {
            iterInfo = (DebugDataObjectInfo)iteratorMethod.invoke(arguments);
            if (iterInfo == null) {
                oplogger.trace("   iterator() returned null for " + data.getClassInfo().getName());
                return false;
            }
            arguments.clear();
            arguments.add(iterInfo);
            data = iterInfo;
        }
        catch (Throwable t) {
            oplogger.trace("  failure invoking iterator()" + t.getMessage());
            return true;
        }
        DebugMethodInfo nextMethod = this.getMethodNamed(data, "next");
        if (nextMethod == null) {
            return false;
        }
        DebugDataObjectInfo element = null;
        try {
            element = (DebugDataObjectInfo)nextMethod.invoke(arguments);
        }
        catch (Exception e) {
            oplogger.trace("  failure invoking iterator.next()" + e.getMessage());
            return true;
        }
        if (element == null) {
            return false;
        }
        oplogger.trace(" collection's iterator.next() returned element " + element.getClassInfo().getName());
        String expressionForElement = this.getValueExpression(element.getClassInfo(), element);
        if (expressionForElement == null) {
            return false;
        }
        if (expressionForElement.length() == 0) {
            oplogger.trace("   element expression is empty string, do not use toString() for collection");
            return true;
        }
        if (expressionForElement.equals(TOSTRING_METHOD_INVOCATION_EXPRESSION)) {
            oplogger.trace("    element uses toString() for display, safe to use for collection");
            return false;
        }
        oplogger.trace("   element uses non-toString expression:" + expressionForElement + ", OK to use toString() for collection");
        return false;
    }

    private DebugMethodInfo getMethodNamed(DebugDataObjectInfo data, String methodName) {
        DebugClassInfo classInfo = data.getClassInfo();
        DebugMethodInfo[] methods = classInfo.getMethods();
        DebugMethodInfo foundMethod = null;
        for (DebugMethodInfo method : methods) {
            if (!method.getNameWithoutClassOrSignature().equals(methodName)) continue;
            foundMethod = method;
            break;
        }
        return foundMethod;
    }

    static {
        dangerousCollectionTypes.add("java.util.AbstractCollection");
        dangerousCollectionTypes.add("java.util.AbstractMap");
        dangerousMapEntryTypes.add("java.util.Map$Entry");
        dangerousMapEntryTypes.add("java.util.HashMap$Node");
        EXPAND_EXPRESSION_DELIMITERS = ";";
    }
}

