/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Frame;
import java.util.Arrays;
import java.util.List;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.MonitorsController;
import oracle.jdevimpl.runner.debug.MonitorsWindow;
import oracle.jdevimpl.runner.debug.MonitorsWindowSettings;
import oracle.jdevimpl.runner.debug.ThreadsPanel;
import oracle.jdevimpl.runner.debug.Utils;

final class MonitorsThreadsPanel
extends ThreadsPanel {
    private String accessibleName;
    private DebugThreadInfo[] threads;
    private IdeAction _actionSettings;
    private JMenuItem _menuitemSettings;
    private int _SETTINGS_CMD_ID;

    MonitorsThreadsPanel(MonitorsWindow monitorsWindow, int panelId, String accessibleName, int preferredVisibleRowCount, MonitorsWindowSettings monitorsWindowSettings) {
        super(monitorsWindow, monitorsWindowSettings.getThreadsPanelSettings());
        this.accessibleName = accessibleName;
        this.preferredVisibleRowCount = preferredVisibleRowCount;
        this.boldCurrentThreadName = false;
        switch (panelId) {
            case 1: {
                this._actionGoTo = MonitorsController.actionOwningThreadGoTo;
                this._actionSettings = MonitorsController.actionOwningThreadSettings;
                this._actionSave = MonitorsController.actionOwningThreadSave;
                this._GOTO_CMD_ID = MonitorsController.OWNING_THREAD_GOTO_CMD_ID;
                this._SETTINGS_CMD_ID = MonitorsController.OWNING_THREAD_SETTINGS_CMD_ID;
                this._SAVE_CMD_ID = MonitorsController.OWNING_THREAD_SAVE_CMD_ID;
                IdeAction[] actions = new IdeAction[]{this._actionGoTo, this._actionSettings, this._actionSave};
                JDebugger.setControllerForActions(actions, this);
                break;
            }
            case 2: {
                this._actionGoTo = MonitorsController.actionWaitingThreadsGoTo;
                this._actionSettings = MonitorsController.actionWaitingThreadsSettings;
                this._actionSave = MonitorsController.actionWaitingThreadsSave;
                this._GOTO_CMD_ID = MonitorsController.WAITING_THREADS_GOTO_CMD_ID;
                this._SETTINGS_CMD_ID = MonitorsController.WAITING_THREADS_SETTINGS_CMD_ID;
                this._SAVE_CMD_ID = MonitorsController.WAITING_THREADS_SAVE_CMD_ID;
                IdeAction[] actions = new IdeAction[]{this._actionGoTo, this._actionSettings, this._actionSave};
                JDebugger.setControllerForActions(actions, this);
                break;
            }
            case 3: {
                this._actionGoTo = MonitorsController.actionBlockedThreadsGoTo;
                this._actionSettings = MonitorsController.actionBlockedThreadsSettings;
                this._actionSave = MonitorsController.actionBlockedThreadsSave;
                this._GOTO_CMD_ID = MonitorsController.BLOCKED_THREADS_GOTO_CMD_ID;
                this._SETTINGS_CMD_ID = MonitorsController.BLOCKED_THREADS_SETTINGS_CMD_ID;
                this._SAVE_CMD_ID = MonitorsController.BLOCKED_THREADS_SAVE_CMD_ID;
                IdeAction[] actions = new IdeAction[]{this._actionGoTo, this._actionSettings, this._actionSave};
                JDebugger.setControllerForActions(actions, this);
            }
        }
        monitorsWindowSettings.getThreadsPanelSettings().addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent e) {
                if (Utils.structureReallyChanged(e)) {
                    MonitorsThreadsPanel.this.threadsPanelSettingsChanged(true);
                }
            }
        });
    }

    @Override
    protected void adjustGUI() {
        this.treeTable.getAccessibleContext().setAccessibleName(this.accessibleName);
        this.columnDefaultWidth[1] = this.columnDefaultWidth[1] * 2;
        this.column[1].setPreferredWidth(this.columnDefaultWidth[1]);
    }

    void setThreads(DebugThreadInfo[] threads) {
        this.threads = threads;
    }

    void setThread(DebugThreadInfo thread) {
        if (thread != null) {
            this.threads = new DebugThreadInfo[1];
            this.threads[0] = thread;
        } else {
            this.threads = null;
        }
    }

    void clearThreads() {
        this.threads = null;
        super.clearThreads(this.windowOptions);
    }

    @Override
    protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
        super.addPopupMenuItemsForCommon(popup, context);
        this.update(this._actionSettings, context);
        if (this._actionSettings.isEnabled()) {
            if (this._menuitemSettings == null) {
                this._menuitemSettings = popup.createMenuItem((ToggleAction)this._actionSettings);
            }
            popup.add((Component)this._menuitemSettings, JDeveloperMenuConstants.SECTION_TOOLS_CTXT_MENU);
        }
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == this._SETTINGS_CMD_ID) {
            String[] path = new String[]{DbgArb.getString(620), DbgArb.getString(722), DbgArb.getString(723)};
            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
            return true;
        }
        return super.handleEvent(action, context);
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (action.getValue("Debugger.actionOwner") == this) {
            if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                action.setEnabled(false);
                return true;
            }
            if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || cmdId == this._SETTINGS_CMD_ID)) {
                action.setEnabled(false);
                return true;
            }
        }
        if (cmdId == this._SETTINGS_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        return super.update(action, context);
    }

    @Override
    protected void addThreadItems() {
        if (this.threads != null) {
            List root = this.getRoot();
            Arrays.sort(this.threads, this);
            for (int i = 0; i < this.threads.length; ++i) {
                root.add(new ThreadsPanel.ThreadItem(this, this.threads[i]));
            }
        }
    }
}

