/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Frame;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DataController;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DataTable;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.MonitorDataItem;
import oracle.jdevimpl.runner.debug.MonitorsPanel;

final class MonitorsController
extends DataController {
    private static IdeAction actionViewWhole;
    private static IdeAction actionViewAnnotations;
    private static IdeAction actionViewAnnotationsForClass;
    private static IdeAction actionAdjustRange;
    private static IdeAction actionToggleValue;
    private static IdeAction actionModifyValue;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoto;
    private static IdeAction actionGotoDeclared;
    private static IdeAction actionGotoField;
    private static IdeAction actionUseFilters;
    private static IdeAction actionObjectPreferences;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemSettings;
    private static final int VIEW_WHOLE_CMD_ID;
    private static final int VIEW_ANNOTATIONS_CMD_ID;
    private static final int VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    private static final int ADJUST_RANGE_CMD_ID;
    private static final int TOGGLE_VALUE_CMD_ID;
    private static final int MODIFY_VALUE_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int GOTO_DECLARED_CMD_ID;
    private static final int GOTO_FIELD_CMD_ID;
    private static final int USE_FILTERS_CMD_ID;
    private static final int OBJECT_PREFERENCES_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static IdeAction actionOwningThreadGoTo;
    static IdeAction actionOwningThreadSave;
    static IdeAction actionOwningThreadSettings;
    static final int OWNING_THREAD_GOTO_CMD_ID;
    static final int OWNING_THREAD_SAVE_CMD_ID;
    static final int OWNING_THREAD_SETTINGS_CMD_ID;
    static IdeAction actionWaitingThreadsGoTo;
    static IdeAction actionWaitingThreadsSave;
    static IdeAction actionWaitingThreadsSettings;
    static final int WAITING_THREADS_GOTO_CMD_ID;
    static final int WAITING_THREADS_SAVE_CMD_ID;
    static final int WAITING_THREADS_SETTINGS_CMD_ID;
    static IdeAction actionBlockedThreadsGoTo;
    static IdeAction actionBlockedThreadsSave;
    static IdeAction actionBlockedThreadsSettings;
    static final int BLOCKED_THREADS_GOTO_CMD_ID;
    static final int BLOCKED_THREADS_SAVE_CMD_ID;
    static final int BLOCKED_THREADS_SETTINGS_CMD_ID;

    MonitorsController(DataPanelSettings dataPanelSettings, MonitorsPanel monitorsPanel) {
        super(dataPanelSettings, monitorsPanel);
        this._actionViewWhole = actionViewWhole;
        this._actionViewAnnotations = actionViewAnnotations;
        this._actionViewAnnotationsForClass = actionViewAnnotationsForClass;
        this._actionAdjustRange = actionAdjustRange;
        this._actionToggleValue = actionToggleValue;
        this._actionModifyValue = actionModifyValue;
        this._actionWatch = null;
        this._actionInspect = null;
        this._actionWatchClassLoader = actionWatchClassLoader;
        this._actionInspectClassLoader = actionInspectClassLoader;
        this._actionGoto = actionGoto;
        this._actionGotoDeclared = actionGotoDeclared;
        this._actionGotoField = actionGotoField;
        this._actionUseFilters = actionUseFilters;
        this._actionObjectPreferences = actionObjectPreferences;
        this._actionCollapseAll = actionCollapseAll;
        this._actionSave = actionSave;
        this._actionSettings = actionSettings;
        this._VIEW_WHOLE_CMD_ID = VIEW_WHOLE_CMD_ID;
        this._VIEW_ANNOTATIONS_CMD_ID = VIEW_ANNOTATIONS_CMD_ID;
        this._VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
        this._ADJUST_RANGE_CMD_ID = ADJUST_RANGE_CMD_ID;
        this._TOGGLE_VALUE_CMD_ID = TOGGLE_VALUE_CMD_ID;
        this._MODIFY_VALUE_CMD_ID = MODIFY_VALUE_CMD_ID;
        this._WATCH_CMD_ID = -1;
        this._INSPECT_CMD_ID = -1;
        this._WATCH_CLASSLOADER_CMD_ID = WATCH_CLASSLOADER_CMD_ID;
        this._INSPECT_CLASSLOADER_CMD_ID = INSPECT_CLASSLOADER_CMD_ID;
        this._GOTO_CMD_ID = GOTO_CMD_ID;
        this._GOTO_DECLARED_CMD_ID = GOTO_DECLARED_CMD_ID;
        this._GOTO_FIELD_CMD_ID = GOTO_FIELD_CMD_ID;
        this._USE_FILTERS_CMD_ID = USE_FILTERS_CMD_ID;
        this._OBJECT_PREFERENCES_CMD_ID = OBJECT_PREFERENCES_CMD_ID;
        this._COLLAPSE_ALL_CMD_ID = COLLAPSE_ALL_CMD_ID;
        this._SAVE_CMD_ID = SAVE_CMD_ID;
        this.setControllerForActions();
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionViewWhole, actionViewAnnotations, actionViewAnnotationsForClass, actionAdjustRange, actionToggleValue, actionModifyValue, actionWatchClassLoader, actionInspectClassLoader, actionGoto, actionGotoDeclared, actionGotoField, actionUseFilters, actionObjectPreferences, actionSettings, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(actions, this);
    }

    @Override
    protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
        super.addPopupMenuItemsForCommon(popup, context);
        this.addPopupItem(popup, context, actionSettings, menuitemSettings, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (action.getValue("Debugger.actionOwner") == this) {
            DataTable dataTable = this.getDataPanel().getDataTable();
            if (dataTable == null || !this.getDataPanel().getDockableWindow().isVisible()) {
                action.setEnabled(false);
                return true;
            }
            if (!(dataTable.getTable().isEnabled() && this.getDebuggingProcess() != null && this.vm != null || cmdId == SETTINGS_CMD_ID)) {
                action.setEnabled(false);
                return true;
            }
        }
        if (cmdId == SETTINGS_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        return super.update(action, context);
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == SETTINGS_CMD_ID) {
            String[] path = new String[]{DbgArb.getString(620), DbgArb.getString(722)};
            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
            return true;
        }
        return super.handleEvent(action, context);
    }

    @Override
    protected void addDataItems() {
        if (this.vm != null) {
            DebugMonitorInfo monitor;
            int i;
            List<DataItem> root = this.getRoot();
            DebugMonitorInfo[] monitors = this.vm.listMonitorsInUse();
            int length = monitors.length;
            boolean[] deadlocked = new boolean[length];
            for (i = 0; i < length; ++i) {
                monitor = monitors[i];
                deadlocked[i] = this.isDeadlocked(monitor);
            }
            for (i = 0; i < length; ++i) {
                if (!deadlocked[i]) continue;
                monitor = monitors[i];
                root.add(new MonitorDataItem(this.getDataPanel(), monitor, true));
            }
            for (i = 0; i < length; ++i) {
                if (deadlocked[i]) continue;
                monitor = monitors[i];
                root.add(new MonitorDataItem(this.getDataPanel(), monitor, false));
            }
            this.updateInstanceCounts(this.vm);
            this.model.updateChangeTracking();
        }
    }

    private boolean isDeadlocked(DebugMonitorInfo monitor) {
        DebugThreadInfo[][] deadlocks = this.getDebuggingProcess().getDeadlocks();
        int length = deadlocks.length;
        if (length != 0) {
            for (int i = 0; i < length; ++i) {
                int jLength = deadlocks[i].length;
                for (int j = 0; j < jLength; ++j) {
                    DebugThreadInfo t = deadlocks[i][j];
                    DebugMonitorInfo mon = t.getMonitorThreadBlockedFor();
                    if (!monitor.equals(mon)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        VIEW_WHOLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsViewWhole");
        VIEW_ANNOTATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsViewAnnotations");
        VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsViewAnnotationsForClass");
        ADJUST_RANGE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsAdjustRange");
        TOGGLE_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsToggleValue");
        MODIFY_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsModifyValue");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsGoto");
        GOTO_DECLARED_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsGotoDeclared");
        GOTO_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsGotoField");
        USE_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsUseFilters");
        OBJECT_PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsObjectPreferences");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsSettings");
        OWNING_THREAD_GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsOwningThreadGoTo");
        OWNING_THREAD_SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsOwningThreadSave");
        OWNING_THREAD_SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsOwningThreadSettings");
        WAITING_THREADS_GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsWaitingThreadsGoTo");
        WAITING_THREADS_SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsWaitingThreadsSave");
        WAITING_THREADS_SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsWaitingThreadsSettings");
        BLOCKED_THREADS_GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsBlockedThreadsGoTo");
        BLOCKED_THREADS_SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsBlockedThreadsSave");
        BLOCKED_THREADS_SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsBlockedThreadsSettings");
        if (actionViewWhole == null) {
            actionViewWhole = IdeAction.findOrCreate((int)VIEW_WHOLE_CMD_ID, null, (String)DbgArb.getString(270), null, (Integer)DbgArb.getInteger(271), null, null, (boolean)false);
            actionViewWhole.setEnabled(false);
            actionViewAnnotations = IdeAction.findOrCreate((int)VIEW_ANNOTATIONS_CMD_ID, null, (String)DbgArb.getString(264), null, (Integer)DbgArb.getInteger(267), null, null, (boolean)false);
            actionViewAnnotations.putValue("NoCtxName", (Object)DbgArb.getString(264));
            actionViewAnnotations.setEnabled(false);
            actionViewAnnotationsForClass = IdeAction.findOrCreate((int)VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID, null, (String)DbgArb.getString(268), null, (Integer)DbgArb.getInteger(269), null, null, (boolean)false);
            actionViewAnnotationsForClass.setEnabled(false);
            actionAdjustRange = IdeAction.findOrCreate((int)ADJUST_RANGE_CMD_ID, null, (String)DbgArb.getString(272), null, (Integer)DbgArb.getInteger(273), null, null, (boolean)false);
            actionAdjustRange.setEnabled(false);
            actionToggleValue = IdeAction.findOrCreate((int)TOGGLE_VALUE_CMD_ID, null, (String)DbgArb.getString(274), null, (Integer)DbgArb.getInteger(275), null, null, (boolean)false);
            actionToggleValue.setEnabled(false);
            actionModifyValue = IdeAction.findOrCreate((int)MODIFY_VALUE_CMD_ID, null, (String)DbgArb.getString(276), null, (Integer)DbgArb.getInteger(277), null, null, (boolean)false);
            actionModifyValue.setEnabled(false);
            actionWatchClassLoader = IdeAction.findOrCreate((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(296), null, (Integer)DbgArb.getInteger(297), null, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.findOrCreate((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(298), null, (Integer)DbgArb.getInteger(299), null, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionGoto = IdeAction.findOrCreate((int)GOTO_CMD_ID, null, (String)DbgArb.getString(284), null, (Integer)DbgArb.getInteger(286), null, null, (boolean)false);
            actionGoto.putValue("NoCtxName", (Object)DbgArb.getString(284));
            actionGoto.setEnabled(false);
            actionGotoDeclared = IdeAction.findOrCreate((int)GOTO_DECLARED_CMD_ID, null, (String)DbgArb.getString(287), null, (Integer)DbgArb.getInteger(289), null, null, (boolean)false);
            actionGotoDeclared.putValue("NoCtxName", (Object)DbgArb.getString(287));
            actionGotoDeclared.setEnabled(false);
            actionGotoField = IdeAction.findOrCreate((int)GOTO_FIELD_CMD_ID, null, (String)DbgArb.getString(290), null, (Integer)DbgArb.getInteger(292), null, null, (boolean)false);
            actionGotoField.putValue("NoCtxName", (Object)DbgArb.getString(290));
            actionGotoField.setEnabled(false);
            actionUseFilters = IdeAction.findOrCreate((int)USE_FILTERS_CMD_ID, null, (String)DbgArb.getString(300), null, (Integer)DbgArb.getInteger(301), null, null, (boolean)false);
            actionUseFilters.putValue("Check", (Object)Boolean.TRUE);
            actionUseFilters.setEnabled(false);
            actionObjectPreferences = IdeAction.findOrCreate((int)OBJECT_PREFERENCES_CMD_ID, null, (String)DbgArb.format(302, ""), null, (Integer)DbgArb.getInteger(303), (Icon)OracleIcons.getIcon((String)"debugger/objectdisplaypreferences.png"), null, (boolean)false);
            actionObjectPreferences.setEnabled(false);
            actionSettings = IdeAction.findOrCreate((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(98), null, (Integer)RunMgrArb.getInteger(99), (Icon)OracleIcons.getIcon((String)"settings.png"), null, (boolean)false);
            actionSettings.setEnabled(false);
            actionCollapseAll = IdeAction.findOrCreate((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(94), null, (Integer)RunMgrArb.getInteger(95), null, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.findOrCreate((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(96), null, (Integer)RunMgrArb.getInteger(97), (Icon)OracleIcons.getIcon((String)"export.png"), null, (boolean)false);
            actionSave.setEnabled(false);
            actionOwningThreadGoTo = IdeAction.findOrCreate((int)OWNING_THREAD_GOTO_CMD_ID, null, (String)DbgArb.getString(207), null, (Integer)DbgArb.getInteger(208), null, null, (boolean)false);
            actionOwningThreadGoTo.setEnabled(false);
            actionOwningThreadSettings = IdeAction.findOrCreate((int)OWNING_THREAD_SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(98), null, (Integer)RunMgrArb.getInteger(99), null, null, (boolean)false);
            actionOwningThreadSettings.setEnabled(false);
            actionOwningThreadSave = IdeAction.findOrCreate((int)OWNING_THREAD_SAVE_CMD_ID, null, (String)RunMgrArb.getString(96), null, (Integer)RunMgrArb.getInteger(97), null, null, (boolean)false);
            actionOwningThreadSave.setEnabled(false);
            actionWaitingThreadsGoTo = IdeAction.findOrCreate((int)WAITING_THREADS_GOTO_CMD_ID, null, (String)DbgArb.getString(207), null, (Integer)DbgArb.getInteger(208), null, null, (boolean)false);
            actionWaitingThreadsGoTo.setEnabled(false);
            actionWaitingThreadsSettings = IdeAction.findOrCreate((int)WAITING_THREADS_SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(98), null, (Integer)RunMgrArb.getInteger(99), null, null, (boolean)false);
            actionWaitingThreadsSettings.setEnabled(false);
            actionWaitingThreadsSave = IdeAction.findOrCreate((int)WAITING_THREADS_SAVE_CMD_ID, null, (String)RunMgrArb.getString(96), null, (Integer)RunMgrArb.getInteger(97), null, null, (boolean)false);
            actionWaitingThreadsSave.setEnabled(false);
            actionBlockedThreadsGoTo = IdeAction.findOrCreate((int)BLOCKED_THREADS_GOTO_CMD_ID, null, (String)DbgArb.getString(207), null, (Integer)DbgArb.getInteger(208), null, null, (boolean)false);
            actionBlockedThreadsGoTo.setEnabled(false);
            actionBlockedThreadsSettings = IdeAction.findOrCreate((int)BLOCKED_THREADS_SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(98), null, (Integer)RunMgrArb.getInteger(99), null, null, (boolean)false);
            actionBlockedThreadsSettings.setEnabled(false);
            actionBlockedThreadsSave = IdeAction.findOrCreate((int)BLOCKED_THREADS_SAVE_CMD_ID, null, (String)RunMgrArb.getString(96), null, (Integer)RunMgrArb.getInteger(97), null, null, (boolean)false);
            actionBlockedThreadsSave.setEnabled(false);
        }
    }
}

