/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.BaseEvaluator;
import oracle.jdevimpl.runner.debug.DataController;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DataTable;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.LocalsPanel;

final class LocalsController
extends DataController {
    private static IdeAction actionViewWhole;
    private static IdeAction actionViewAnnotations;
    private static IdeAction actionViewAnnotationsForClass;
    private static IdeAction actionAdjustRange;
    private static IdeAction actionToggleValue;
    private static IdeAction actionModifyValue;
    private static IdeAction actionWatch;
    private static IdeAction actionInspect;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoto;
    private static IdeAction actionGotoDeclared;
    private static IdeAction actionGotoField;
    private static IdeAction actionUseFilters;
    private static IdeAction actionObjectPreferences;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemSettings;
    private static final int VIEW_WHOLE_CMD_ID;
    private static final int VIEW_ANNOTATIONS_CMD_ID;
    private static final int VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    private static final int ADJUST_RANGE_CMD_ID;
    private static final int TOGGLE_VALUE_CMD_ID;
    private static final int MODIFY_VALUE_CMD_ID;
    private static final int WATCH_CMD_ID;
    private static final int INSPECT_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int GOTO_DECLARED_CMD_ID;
    private static final int GOTO_FIELD_CMD_ID;
    private static final int USE_FILTERS_CMD_ID;
    private static final int OBJECT_PREFERENCES_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;

    LocalsController(DataPanelSettings dataPanelSettings, LocalsPanel localsPanel) {
        super(dataPanelSettings, localsPanel);
        LocalsController.createActions();
        this.setControllerForActions();
        this.assignSuperClassActions();
    }

    private void assignSuperClassActions() {
        this._actionViewWhole = actionViewWhole;
        this._actionViewAnnotations = actionViewAnnotations;
        this._actionViewAnnotationsForClass = actionViewAnnotationsForClass;
        this._actionAdjustRange = actionAdjustRange;
        this._actionToggleValue = actionToggleValue;
        this._actionModifyValue = actionModifyValue;
        this._actionWatch = actionWatch;
        this._actionInspect = actionInspect;
        this._actionWatchClassLoader = actionWatchClassLoader;
        this._actionInspectClassLoader = actionInspectClassLoader;
        this._actionGoto = actionGoto;
        this._actionGotoDeclared = actionGotoDeclared;
        this._actionGotoField = actionGotoField;
        this._actionUseFilters = actionUseFilters;
        this._actionObjectPreferences = actionObjectPreferences;
        this._actionCollapseAll = actionCollapseAll;
        this._actionSave = actionSave;
        this._actionSettings = actionSettings;
        this._VIEW_WHOLE_CMD_ID = VIEW_WHOLE_CMD_ID;
        this._VIEW_ANNOTATIONS_CMD_ID = VIEW_ANNOTATIONS_CMD_ID;
        this._VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
        this._ADJUST_RANGE_CMD_ID = ADJUST_RANGE_CMD_ID;
        this._TOGGLE_VALUE_CMD_ID = TOGGLE_VALUE_CMD_ID;
        this._MODIFY_VALUE_CMD_ID = MODIFY_VALUE_CMD_ID;
        this._WATCH_CMD_ID = WATCH_CMD_ID;
        this._INSPECT_CMD_ID = INSPECT_CMD_ID;
        this._WATCH_CLASSLOADER_CMD_ID = WATCH_CLASSLOADER_CMD_ID;
        this._INSPECT_CLASSLOADER_CMD_ID = INSPECT_CLASSLOADER_CMD_ID;
        this._GOTO_CMD_ID = GOTO_CMD_ID;
        this._GOTO_DECLARED_CMD_ID = GOTO_DECLARED_CMD_ID;
        this._GOTO_FIELD_CMD_ID = GOTO_FIELD_CMD_ID;
        this._USE_FILTERS_CMD_ID = USE_FILTERS_CMD_ID;
        this._OBJECT_PREFERENCES_CMD_ID = OBJECT_PREFERENCES_CMD_ID;
        this._COLLAPSE_ALL_CMD_ID = COLLAPSE_ALL_CMD_ID;
        this._SAVE_CMD_ID = SAVE_CMD_ID;
        this._SETTINGS_CMD_ID = SETTINGS_CMD_ID;
    }

    private static void createActions() {
        if (actionViewWhole == null) {
            actionViewWhole = IdeAction.get((int)VIEW_WHOLE_CMD_ID, null, (String)DbgArb.getString(270), null, (Integer)DbgArb.getInteger(271), null, null, (boolean)false);
            actionViewWhole.setEnabled(false);
            actionViewAnnotations = IdeAction.get((int)VIEW_ANNOTATIONS_CMD_ID, null, (String)DbgArb.getString(264), null, (Integer)DbgArb.getInteger(267), null, null, (boolean)false);
            actionViewAnnotations.putValue("NoCtxName", (Object)DbgArb.getString(264));
            actionViewAnnotations.setEnabled(false);
            actionViewAnnotationsForClass = IdeAction.get((int)VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID, null, (String)DbgArb.getString(268), null, (Integer)DbgArb.getInteger(269), null, null, (boolean)false);
            actionViewAnnotationsForClass.setEnabled(false);
            actionAdjustRange = IdeAction.get((int)ADJUST_RANGE_CMD_ID, null, (String)DbgArb.getString(272), null, (Integer)DbgArb.getInteger(273), null, null, (boolean)false);
            actionAdjustRange.setEnabled(false);
            actionToggleValue = IdeAction.get((int)TOGGLE_VALUE_CMD_ID, null, (String)DbgArb.getString(274), null, (Integer)DbgArb.getInteger(275), null, null, (boolean)false);
            actionToggleValue.setEnabled(false);
            actionModifyValue = IdeAction.get((int)MODIFY_VALUE_CMD_ID, null, (String)DbgArb.getString(276), null, (Integer)DbgArb.getInteger(277), null, null, (boolean)false);
            actionModifyValue.setEnabled(false);
            actionWatch = IdeAction.get((int)WATCH_CMD_ID, null, (String)DbgArb.getString(280), null, (Integer)DbgArb.getInteger(281), (Icon)OracleIcons.getIcon((String)"watch.png"), null, (boolean)false);
            actionWatch.setEnabled(false);
            actionInspect = IdeAction.get((int)INSPECT_CMD_ID, null, (String)DbgArb.getString(282), null, (Integer)DbgArb.getInteger(283), (Icon)OracleIcons.getIcon((String)"properties.png"), null, (boolean)false);
            actionInspect.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(296), null, (Integer)DbgArb.getInteger(297), null, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(298), null, (Integer)DbgArb.getInteger(299), null, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionGoto = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(284), null, (Integer)DbgArb.getInteger(286), null, null, (boolean)false);
            actionGoto.putValue("NoCtxName", (Object)DbgArb.getString(284));
            actionGoto.setEnabled(false);
            actionGotoDeclared = IdeAction.get((int)GOTO_DECLARED_CMD_ID, null, (String)DbgArb.getString(287), null, (Integer)DbgArb.getInteger(289), null, null, (boolean)false);
            actionGotoDeclared.putValue("NoCtxName", (Object)DbgArb.getString(287));
            actionGotoDeclared.setEnabled(false);
            actionGotoField = IdeAction.get((int)GOTO_FIELD_CMD_ID, null, (String)DbgArb.getString(290), null, (Integer)DbgArb.getInteger(292), null, null, (boolean)false);
            actionGotoField.putValue("NoCtxName", (Object)DbgArb.getString(290));
            actionGotoField.setEnabled(false);
            actionUseFilters = IdeAction.get((int)USE_FILTERS_CMD_ID, null, (String)DbgArb.getString(300), null, (Integer)DbgArb.getInteger(301), null, null, (boolean)false);
            actionUseFilters.putValue("Check", (Object)Boolean.TRUE);
            actionUseFilters.setEnabled(false);
            actionObjectPreferences = IdeAction.get((int)OBJECT_PREFERENCES_CMD_ID, null, (String)DbgArb.format(302, ""), null, (Integer)DbgArb.getInteger(303), (Icon)OracleIcons.getIcon((String)"debugger/objectdisplaypreferences.png"), null, (boolean)false);
            actionObjectPreferences.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(98), null, (Integer)RunMgrArb.getInteger(99), (Icon)OracleIcons.getIcon((String)"settings.png"), null, (boolean)false);
            actionSettings.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(94), null, (Integer)RunMgrArb.getInteger(95), null, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(96), null, (Integer)RunMgrArb.getInteger(97), (Icon)OracleIcons.getIcon((String)"export.png"), null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionViewWhole, actionViewAnnotations, actionViewAnnotationsForClass, actionAdjustRange, actionToggleValue, actionModifyValue, actionWatch, actionInspect, actionWatchClassLoader, actionInspectClassLoader, actionGoto, actionGotoDeclared, actionGotoField, actionUseFilters, actionObjectPreferences, actionSettings, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(actions, this);
    }

    @Override
    protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
        super.addPopupMenuItemsForCommon(popup, context);
        this.addPopupItem(popup, context, actionSettings, menuitemSettings, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (action.getValue("Debugger.actionOwner") == this) {
            DataTable dataTable = this.getDataPanel().getDataTable();
            if (dataTable == null || !this.getDataPanel().getDockableWindow().isVisible()) {
                action.setEnabled(false);
                return true;
            }
            if (!(dataTable.getTable().isEnabled() && this.getDebuggingProcess() != null && this.vm != null || cmdId == SETTINGS_CMD_ID)) {
                action.setEnabled(false);
                return true;
            }
        }
        if (cmdId == SETTINGS_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        return super.update(action, context);
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == SETTINGS_CMD_ID) {
            String[] path = new String[]{DbgArb.getString(620), DbgArb.getString(667)};
            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
            return true;
        }
        return super.handleEvent(action, context);
    }

    @Override
    protected void addDataItems() {
        DebugLocation location;
        DebugDataObjectInfo currentThrow;
        List<DataItem> root = this.getRoot();
        if (this.vm != null && this.thread != null && this.thread.equals(this.vm.getCurrentThread()) && this.frame != null && this.frame.getFrameNumber() == 0 && (currentThrow = this.vm.getCurrentThrow()) != null) {
            String part = BaseEvaluator.getThrowExpressionPart();
            root.add(new DataItem(this.getDataPanel(), currentThrow, part, part));
        }
        if (this.frame != null) {
            DebugStackSlotInfo[] slots;
            int sLength;
            String slotExpr;
            DebugVariableInfo[] a = this.frame.listArguments();
            int aLength = a.length;
            DebugVariableInfo[] l = this.frame.listLocals();
            int lLength = l.length;
            DebugFieldInfo[] sv = this.getSyntheticValues(a);
            int svLength = sv.length;
            boolean localVariableTablePresent = lLength > 0;
            int length = aLength + lLength + svLength;
            if (length > 0) {
                Object[] vars = new Object[length];
                if (aLength > 0) {
                    System.arraycopy(a, 0, vars, 0, aLength);
                }
                if (lLength > 0) {
                    System.arraycopy(l, 0, vars, aLength, lLength);
                }
                if (svLength > 0) {
                    System.arraycopy(sv, 0, vars, aLength + lLength, svLength);
                }
                if (this.getLocalsPanel().localsWindowSettings.isSortVarsByName(this.vm.getID())) {
                    Arrays.sort(vars, new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            String name1 = LocalsController.this.getDisplayName(o1);
                            String name2 = LocalsController.this.getDisplayName(o2);
                            return name1.compareToIgnoreCase(name2);
                        }
                    });
                }
                block0: for (int i = 0; i < length; ++i) {
                    if (vars[i] instanceof DebugFieldInfo) {
                        DebugFieldInfo field = (DebugFieldInfo)vars[i];
                        String realName = this.getDisplayName(field);
                        root.add(new DataItem(this.getDataPanel(), field, realName, realName));
                        continue;
                    }
                    DebugVariableInfo var = (DebugVariableInfo)vars[i];
                    if (this.getLocalsPanel().localsWindowSettings.isHideOutOfScopeVars() && !var.isInScope()) continue;
                    if (var.getName().startsWith("<")) {
                        for (int iSlot = 0; iSlot < aLength; ++iSlot) {
                            if (var != a[iSlot]) continue;
                            slotExpr = BaseEvaluator.getSlotExpressionPartPrefix() + iSlot;
                            root.add(new DataItem(this.getDataPanel(), var, slotExpr, slotExpr));
                            continue block0;
                        }
                        continue;
                    }
                    if (!var.getName().equals("this")) {
                        localVariableTablePresent = true;
                    }
                    root.add(new DataItem(this.getDataPanel(), var));
                }
            }
            if (!localVariableTablePresent && (sLength = (slots = this.frame.listSlots()).length) > 0) {
                int i;
                int countArgSlots = 0;
                for (i = 0; i < aLength; ++i) {
                    countArgSlots += a[i].getSlotSize();
                }
                for (i = countArgSlots; i < sLength; ++i) {
                    slotExpr = BaseEvaluator.getSlotExpressionPartPrefix() + i;
                    root.add(new DataItem(this.getDataPanel(), slots[i], slotExpr, slotExpr));
                }
            }
        }
        if (this.thread != null && this.frame != null && this.frame.getFrameNumber() == 0) {
            DebugDataInfo data;
            boolean addedReturnValue = false;
            DebugVariableInfo var = this.thread.getReturnValue();
            if (var != null && (data = var.getDataInfo()) != null) {
                String part = BaseEvaluator.getReturnExpressionPart();
                root.add(0, new DataItem(this.getDataPanel(), var, part, part));
                addedReturnValue = true;
            }
            if (!addedReturnValue && (var = this.thread.getReturnedValue()) != null && (data = var.getDataInfo()) != null) {
                String part = BaseEvaluator.getReturnedExpressionPart();
                root.add(0, new DataItem(this.getDataPanel(), var, part, part));
            }
        }
        if (this.frame != null && this.getLocalsPanel().localsWindowSettings.isShowStaticFolder() && (location = this.frame.getLocation()) != null) {
            DebugClassInfo clazz = location.getClassInfo();
            String className = clazz.getName();
            if (className.startsWith("$Oracle.")) {
                if (className.startsWith("$Oracle.PackageBody.")) {
                    DebugClassInfo bodyClass = clazz;
                    DataItem bodyFolder = new DataItem(this.getDataPanel(), bodyClass);
                    root.add(bodyFolder);
                    FastStringBuffer sb = new FastStringBuffer(className);
                    for (int i = 0; i < 4; ++i) {
                        sb.removeCharAt(15);
                    }
                    String specClassName = sb.toString();
                    DebugClassInfo specClass = this.vm.findFirstClassByName(specClassName);
                    DataItem specFolder = new DataItem(this.getDataPanel(), specClass);
                    root.add(specFolder);
                } else if (className.startsWith("$Oracle.Package.")) {
                    DebugClassInfo specClass = clazz;
                    DataItem specFolder = new DataItem(this.getDataPanel(), specClass);
                    root.add(specFolder);
                }
            } else if (clazz.getLanguage() != 8) {
                String outerClassName;
                DebugClassInfo outerClass;
                int firstDollar = className.indexOf(36);
                if (firstDollar != -1 && (outerClass = this.vm.findFirstClassByName(outerClassName = className.substring(0, firstDollar))) != null) {
                    clazz = outerClass;
                }
                DataItem staticFolder = new DataItem(this.getDataPanel(), clazz);
                root.add(staticFolder);
            }
        }
        if (this.vm != null) {
            this.updateInstanceCounts(this.vm);
        }
        this.model.updateChangeTracking();
    }

    private String getDisplayName(Object o) {
        String name;
        if (o instanceof DebugFieldInfo) {
            name = ((DebugFieldInfo)o).getName();
            if (name.startsWith("val$")) {
                name = name.substring(4);
            }
            if (name.startsWith("v$")) {
                name = name.substring(2);
            }
        } else {
            name = ((DebugVariableInfo)o).getName();
        }
        return name;
    }

    private DebugFieldInfo[] getSyntheticValues(DebugVariableInfo[] args) {
        ArrayList<DebugFieldInfo> temp = new ArrayList<DebugFieldInfo>();
        int length = args.length;
        for (int i = 0; i < length; ++i) {
            DebugDataObjectInfo o;
            DebugClassInfo clazz;
            if (!args[i].getName().equals("this")) continue;
            DebugDataInfo data = args[i].getDataInfo();
            if (!(data instanceof DebugDataObjectInfo) || (clazz = (o = (DebugDataObjectInfo)data).getClassInfo()) == null || clazz.getName().indexOf(36) == -1) break;
            for (DebugFieldInfo field : o.getFields(0, false, true, false)) {
                String name = field.getName();
                if (name.startsWith("val$")) {
                    temp.add(field);
                    continue;
                }
                if (!name.startsWith("v$")) continue;
                temp.add(field);
            }
            break;
        }
        return temp.toArray(new DebugFieldInfo[temp.size()]);
    }

    private LocalsPanel getLocalsPanel() {
        return (LocalsPanel)this.getDataPanel();
    }

    static {
        VIEW_WHOLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsViewWhole");
        VIEW_ANNOTATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsViewAnnotations");
        VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsViewAnnotationsForClass");
        ADJUST_RANGE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsAdjustRange");
        TOGGLE_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsToggleValue");
        MODIFY_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsModifyValue");
        WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsWatch");
        INSPECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsInspect");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsGoto");
        GOTO_DECLARED_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsGotoDeclared");
        GOTO_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsGotoField");
        USE_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsUseFilters");
        OBJECT_PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsObjectPreferences");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsSettings");
    }
}

