/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.controls.Toolbar;
import oracle.ide.util.PropertyAccess;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.ui.search.PromptedTextField;
import oracle.jdeveloper.debugger.support.DebuggerWindowOptions;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.runner.debug.DataController;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluatorDataItem;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.EvaluatorPanel;
import oracle.jdevimpl.runner.debug.InspectorController;
import oracle.jdevimpl.runner.debug.InspectorWindow;
import oracle.jdevimpl.runner.debug.InspectorWindowSettings;
import oracle.jdevimpl.runner.debug.VersionedDataItem;

final class InspectorPanel
extends EvaluatorPanel {
    private EvaluatorItem ei;
    private InspectorWindowSettings inspectorWindowSettings;
    private PromptedTextField inspectField = new PromptedTextField();
    private static final String INSPECTOR_KEY_EXPRESSION = ".expression";

    InspectorPanel(InspectorWindow inspectorWindow, InspectorWindowSettings inspectorWindowSettings) {
        super(inspectorWindow, inspectorWindowSettings.getDataPanelSettings());
        this.inspectField.setColumns(30);
        this.inspectField.setPrompt(DbgArb.getString(870));
        this.inspectorWindowSettings = inspectorWindowSettings;
        this.loadExpression((PropertyAccess)Ide.getIdeProperties());
    }

    InspectorPanel(InspectorWindow inspectorWindow, Object expression, InspectorWindowSettings inspectorWindowSettings) {
        super(inspectorWindow, inspectorWindowSettings.getDataPanelSettings());
        this.inspectField.setColumns(30);
        this.inspectField.setPrompt(DbgArb.getString(870));
        this.inspectorWindowSettings = inspectorWindowSettings;
        if (expression instanceof EvaluatorItem) {
            this.ei = (EvaluatorItem)expression;
        } else if (expression instanceof String) {
            this.ei = new EvaluatorItem((String)expression);
        }
        this.inspectField.setText(this.ei.getExpression());
        this.ei.addPropertyChangeSupport(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("expression")) {
                    InspectorPanel.this.inspectField.setText((String)evt.getNewValue());
                }
            }
        });
    }

    @Override
    void processFinished(DebuggingProcess debuggingProcess) {
        if (this.ei.isPinned(debuggingProcess)) {
            this.ei.unpin(debuggingProcess);
        }
        super.processFinished(debuggingProcess);
        if (this.ei.getTemporary() == debuggingProcess) {
            this.getDockableWindow().close();
        }
    }

    private String getKeyPrefix() {
        return this.dockableWindow.getId();
    }

    private void loadExpression(PropertyAccess properties) {
        String prefix = this.getKeyPrefix();
        String expression = properties.getProperty(prefix + INSPECTOR_KEY_EXPRESSION, "");
        this.ei = expression != null ? new EvaluatorItem(expression) : new EvaluatorItem("");
    }

    void saveExpression(PropertyAccess properties) {
        String prefix = this.getKeyPrefix();
        String expression = this.ei.getExpression();
        properties.setProperty(prefix + INSPECTOR_KEY_EXPRESSION, expression);
    }

    private void removeSavedExpression(PropertyAccess properties) {
        String prefix = this.getKeyPrefix();
        properties.setProperty(prefix + INSPECTOR_KEY_EXPRESSION, null);
    }

    void removeInspector() {
        this.removeSavedExpression((PropertyAccess)Ide.getIdeProperties());
        if (this.ei != null) {
            this.ei.unpinForAll();
        }
    }

    @Override
    protected DataController createController(DataPanelSettings dataPanelSettings) {
        return new InspectorController(dataPanelSettings, this);
    }

    final EvaluatorItem getEvaluatorItem() {
        return this.ei;
    }

    @Override
    String getWindowId() {
        return "Debugger.InspectorWindow";
    }

    @Override
    DebuggerWindowOptions.WindowId getWindowIdEnum() {
        return DebuggerWindowOptions.WindowId.InspectorWindow;
    }

    @Override
    protected Component adjustGUI(Component defaultGui) {
        Toolbar toolbar = new Toolbar();
        toolbar.setSecondaryViewToolbar(true);
        final JButton button = new JButton(OracleIcons.getIcon((String)"quick_query.png"));
        button.setToolTipText(DbgArb.getString(871));
        IconicButtonUI.install((AbstractButton)button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectorPanel.this.setExpression(InspectorPanel.this.inspectField.getText());
            }
        });
        String ACTION_ENTER = "enter";
        this.inspectField.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
        this.inspectField.getActionMap().put("enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                button.doClick();
            }
        });
        toolbar.add((Component)this.inspectField);
        toolbar.add((Component)button);
        toolbar.addSeparator();
        toolbar.add((Component)this.createHistoryButton());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(defaultGui, "Center");
        panel.add((Component)toolbar, "North");
        return panel;
    }

    protected JComponent createHistoryButton() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                InspectorPanel.this.setExpression(item.getText());
            }
        };
        return super.createHistoryButton(listener);
    }

    private void setExpression(String expression) {
        TreePath treePath;
        if (expression.equals(this.ei.getExpression())) {
            return;
        }
        InspectorController controller = (InspectorController)this.getController();
        DebugStackFrameInfo frame = controller.getFrame();
        if (controller.getThread() != null && frame != null) {
            controller.setFrame(controller.getThread().getStackFrame(frame.getFrameNumber()));
            controller.debugContextChanged();
        }
        if ((treePath = this.getDataTable().getPathForRow(0)).getPathCount() > 1) {
            DataItem item = (DataItem)treePath.getPathComponent(1);
            if (item instanceof EvaluatorDataItem) {
                ((EvaluatorDataItem)item).editExpression(expression, treePath);
            } else if (item instanceof VersionedDataItem) {
                VersionedDataItem vdi = (VersionedDataItem)item;
                EvaluatorDataItem edi = vdi.getEvaluatorDataItem();
                if (edi == null && vdi.getInfo() instanceof EvaluatorDataItem) {
                    edi = (EvaluatorDataItem)vdi.getInfo();
                }
                if (edi != null) {
                    edi.editExpression(expression, treePath);
                    vdi.expire();
                    vdi.updateVDI(edi, controller.getDebuggingProcess().getStoppedCount());
                }
            }
            this.getDataTable().expandPath(this.getDataTable().getPathForRow(0).getParentPath());
            this.getDockableWindow().updateTitle(null);
        }
        if (expression != null) {
            this.enableHistoryButton();
            this.historyList.updateHistory(expression);
        }
    }
}

