/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import com.sun.jdi.VMDisconnectedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.runner.DebuggerBreakpoint;
import oracle.ide.runner.DebuggerBreakpointDeclarator;
import oracle.ide.runner.DebuggerBreakpointLogEntry;
import oracle.ide.runner.DebuggerBreakpointPanel;
import oracle.ide.runner.DebuggerEvaluator;
import oracle.ide.runner.DebuggerExceptionBreakpoint;
import oracle.ide.runner.DebuggerExtender;
import oracle.ide.runner.DebuggerExtender2;
import oracle.ide.runner.DebuggerExtenderCallback;
import oracle.ide.runner.DebuggerExtenderDeclarator;
import oracle.ide.runner.DebuggerFileLineBreakpoint;
import oracle.ide.runner.DebuggerListener;
import oracle.ide.runner.DebuggerLocation;
import oracle.ide.runner.DebuggerMethodBreakpoint;
import oracle.ide.runner.DebuggerPropertiesBreakpoint;
import oracle.ide.runner.DebuggerURLLineBreakpoint;
import oracle.ideimpl.runner.DebuggerHook;
import oracle.jdevimpl.debugger.Breakpoint;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.runner.debug.BreakpointDefinitionPanel;
import oracle.jdevimpl.runner.debug.BreakpointDetails;
import oracle.jdevimpl.runner.debug.BreakpointRuntimeSupport;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.EvaluatorHandle;
import oracle.jdevimpl.runner.debug.ExtenderBreakpoint;
import oracle.jdevimpl.runner.debug.ExtenderCallback;

class ExtenderManager {
    private Map<String, ExtenderCallback> extenderMap = new HashMap<String, ExtenderCallback>();
    private Map<String, String> sourceExtensionToDebuggerExtenderMap = new HashMap<String, String>();
    private static ExtenderManager _instance = new ExtenderManager();

    private ExtenderManager() {
    }

    static ExtenderManager getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasExtender(String ID) {
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            return this.extenderMap.containsKey(ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExtenderCallback addExtender(DebuggerExtender extender) {
        String ID = null;
        try {
            ID = extender.getID();
            if (ID == null) {
                return null;
            }
        }
        catch (Exception ex) {
            FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
            ex.printStackTrace();
            return null;
        }
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            if (this.extenderMap.containsKey(ID)) {
                return null;
            }
            ExtenderCallback callback = new ExtenderCallback(extender, ID);
            this.extenderMap.put(ID, callback);
            DebuggerHook.addDebuggerListener((DebuggerListener)extender);
            return callback;
        }
    }

    ExtenderCallback addExtender(DebuggerExtenderDeclarator declarator) {
        DebuggerExtender extender = declarator.getDebuggerExtender();
        if (extender == null) {
            throw new IllegalArgumentException("Need a valid DebuggerExtenderDeclarator argument");
        }
        ExtenderCallback callback = this.addExtender(extender);
        declarator.setDebuggerExtenderCallback((DebuggerExtenderCallback)callback);
        extender.breakpointsLoaded();
        return callback;
    }

    ExtenderCallback addExtender(DebuggerExtenderDeclarator declarator, List<String> sourceExtensions) {
        DebuggerExtender extender = declarator.getDebuggerExtender();
        String extenderId = extender.getID();
        if (sourceExtensions != null && sourceExtensions.size() > 0 && !(extender instanceof DebuggerExtender2)) {
            throw new IllegalArgumentException("Debugger extender must implement DebuggerExtender2");
        }
        if (sourceExtensions != null) {
            for (String sourceExtension : sourceExtensions) {
                String currentRegistrant = this.sourceExtensionToDebuggerExtenderMap.get(sourceExtension);
                if (currentRegistrant != null && !currentRegistrant.equals(extenderId)) {
                    throw new IllegalArgumentException("Source file extension " + sourceExtension + " cannot be assigned to " + extenderId + " because it is already owned by " + currentRegistrant);
                }
                this.sourceExtensionToDebuggerExtenderMap.put(sourceExtension, extenderId);
            }
        }
        return this.addExtender(declarator);
    }

    ExtenderCallback addExtender(String extenderId) {
        Map extenderInfo = DebuggerHook.getDebuggerExtenderDeclarator((String)extenderId);
        if (extenderInfo != null && extenderInfo.size() > 0) {
            DebuggerExtenderDeclarator declarator = extenderInfo.keySet().toArray(new DebuggerExtenderDeclarator[1])[0];
            DebuggerExtender extender = declarator.getDebuggerExtender();
            List sourceExtensions = (List)extenderInfo.get(declarator);
            if (sourceExtensions != null && sourceExtensions.size() > 0 && !(extender instanceof DebuggerExtender2)) {
                DebuggerHook.notExtender2Error((String)extenderId);
            } else if (sourceExtensions != null) {
                for (String sourceExtension : sourceExtensions) {
                    String currentRegistrant = this.sourceExtensionToDebuggerExtenderMap.get(sourceExtension);
                    if (currentRegistrant != null && !currentRegistrant.equals(extenderId)) {
                        DebuggerHook.duplicateSourceExtensionError((String)extenderId, (String)currentRegistrant, (String)sourceExtension);
                        continue;
                    }
                    this.sourceExtensionToDebuggerExtenderMap.put(sourceExtension, extenderId);
                }
            }
            return this.addExtender(declarator);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeExtender(DebuggerExtender extender) {
        String ID = null;
        try {
            ID = extender.getID();
            if (ID == null) {
                return;
            }
        }
        catch (Exception ex) {
            FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
            ex.printStackTrace();
        }
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            this.extenderMap.remove(ID);
        }
    }

    boolean isExtenderBreakpoint(Breakpoint breakpoint) {
        return this.doExtenderAction(ExtenderAction.IS_EXTENDER_BREAKPOINT, null, breakpoint, true);
    }

    boolean stoppedAtExtenderBreakpoint(BreakpointDetails breakpointDetails) {
        return breakpointDetails != null && breakpointDetails.getDebuggerBreakpoint() != null;
    }

    void breakpointAdded(Breakpoint breakpoint) {
        this.doExtenderAction(ExtenderAction.BREAKPOINT_ADDED, null, breakpoint, false);
    }

    void breakpointChanged(DebuggingProcess debuggingProcess, Breakpoint breakpoint) {
        ExtenderActionDetails details = this.getExtenderActionDetails(breakpoint, false);
        if (details != null) {
            DebuggerBreakpoint.BreakpointState newState;
            switch (BreakpointRuntimeSupport.getRuntimeStatus(breakpoint, debuggingProcess)) {
                case 0: {
                    newState = DebuggerBreakpoint.BreakpointState.DISABLED;
                    break;
                }
                case 1: {
                    newState = DebuggerBreakpoint.BreakpointState.ENABLED;
                    break;
                }
                case 2: {
                    newState = DebuggerBreakpoint.BreakpointState.UNVERIFIED;
                    break;
                }
                case 3: {
                    newState = DebuggerBreakpoint.BreakpointState.VERIFIED;
                    break;
                }
                default: {
                    return;
                }
            }
            try {
                details.extender.breakpointChanged((DebuggerBreakpoint)details.extenderBreakpoint, newState);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    void breakpointMoved(Breakpoint breakpoint) {
        this.doExtenderAction(ExtenderAction.BREAKPOINT_MOVED, null, breakpoint, false);
    }

    void breakpointRefactored(Breakpoint breakpoint) {
        this.doExtenderAction(ExtenderAction.BREAKPOINT_REFACTORED, null, breakpoint, false);
    }

    void breakpointDeleted(Breakpoint breakpoint) {
        this.doExtenderAction(ExtenderAction.BREAKPOINT_DELETED, null, breakpoint, false);
    }

    void breakpointEdited(Breakpoint breakpoint) {
        this.doExtenderAction(ExtenderAction.BREAKPOINT_EDITED, null, breakpoint, false);
    }

    void breakpointScopeChanged(Breakpoint breakpoint) {
        this.doExtenderAction(ExtenderAction.BREAKPOINT_SCOPE_CHANGED, null, breakpoint, false);
    }

    void debuggeeStoppedAtBreakpoint(Context context, BreakpointDetails breakpointDetails) {
        ExtenderActionDetails actionDetails = this.getExtenderActionDetails(breakpointDetails.getBreakpoint(), true);
        if (actionDetails != null) {
            breakpointDetails.setDebuggerBreakpoint((DebuggerBreakpoint)actionDetails.extenderBreakpoint);
            breakpointDetails.setDebuggerExtender(actionDetails.extender);
            breakpointDetails.setExtenderCallback(actionDetails.callback);
            actionDetails.extender.debuggeeStoppedAtBreakpoint(context, (DebuggerBreakpoint)actionDetails.extenderBreakpoint);
        }
    }

    boolean canShowBreakpointLocation(Context context, Breakpoint breakpoint) {
        return this.doExtenderAction(ExtenderAction.CAN_SHOW_BREAKPOINT_LOCATION, context, breakpoint, true);
    }

    boolean showBreakpointLocation(Context context, Breakpoint breakpoint) {
        return this.doExtenderAction(ExtenderAction.SHOW_BREAKPOINT_LOCATION, context, breakpoint, true);
    }

    void newDebugSession(Context context) {
        this.callAllExtenders(ExtenderAction.NEW_DEBUG_SESSION, context);
    }

    boolean canShowIPLocation(Context context, BreakpointDetails breakpointDetails) {
        return this.doExtenderAction(ExtenderAction.CAN_SHOW_IP_LOCATION, context, breakpointDetails);
    }

    boolean canShowIPLocation(Context context, DebugLocation location) {
        return this.doExtenderAction(ExtenderAction.CAN_SHOW_IP_LOCATION, context, location);
    }

    boolean showIPLocation(Context context, BreakpointDetails breakpointDetails) {
        return this.doExtenderAction(ExtenderAction.SHOW_IP_LOCATION, context, breakpointDetails);
    }

    boolean showIPLocation(Context context, DebugLocation location) {
        return this.doExtenderAction(ExtenderAction.SHOW_IP_LOCATION, context, location);
    }

    void setEvaluator(DebuggingProcess process, Breakpoint breakpoint, Evaluator evaluator) {
        ExtenderActionDetails details = this.getExtenderActionDetails(breakpoint, true);
        if (details != null) {
            EvaluatorHandle debuggerEvaluator = new EvaluatorHandle(evaluator, process, details.callback.getCustomDataProvider());
            try {
                details.extender.setEvaluator(process.getContext(), (DebuggerEvaluator)debuggerEvaluator);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    Breakpoint stepOver(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.overrideStepping(process, breakpointDetails, ExtenderAction.STEP_OVER);
    }

    boolean canStepOver(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.canOverrideStepping(process, breakpointDetails, ExtenderAction.STEP_OVER);
    }

    Breakpoint stepInto(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.overrideStepping(process, breakpointDetails, ExtenderAction.STEP_INTO);
    }

    boolean canStepInto(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.canOverrideStepping(process, breakpointDetails, ExtenderAction.STEP_INTO);
    }

    Breakpoint stepOut(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.overrideStepping(process, breakpointDetails, ExtenderAction.STEP_OUT);
    }

    boolean canStepOut(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.canOverrideStepping(process, breakpointDetails, ExtenderAction.STEP_OUT);
    }

    Breakpoint stepToEndOfMethod(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.overrideStepping(process, breakpointDetails, ExtenderAction.STEP_TO_END_OF_METHOD);
    }

    boolean canStepToEndOfMethod(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.canOverrideStepping(process, breakpointDetails, ExtenderAction.STEP_TO_END_OF_METHOD);
    }

    Breakpoint runToCursor(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.overrideStepping(process, breakpointDetails, ExtenderAction.RUN_TO_CURSOR);
    }

    boolean canRunToCursor(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.canOverrideStepping(process, breakpointDetails, ExtenderAction.RUN_TO_CURSOR);
    }

    boolean updateBreakpointIcon(Breakpoint breakpoint) {
        return this.doExtenderAction(ExtenderAction.UPDATE_BREAKPOINT_ICON, null, breakpoint, false);
    }

    boolean showBreakpointIcon(Breakpoint breakpoint) {
        return this.doExtenderAction(ExtenderAction.SHOW_BREAKPOINT_ICON, null, breakpoint, false);
    }

    boolean hideBreakpointIcon(Breakpoint breakpoint) {
        return this.doExtenderAction(ExtenderAction.HIDE_BREAKPOINT_ICON, null, breakpoint, false);
    }

    void breakpointsLoaded() {
        this.callAllExtenders(ExtenderAction.BREAKPOINTS_LOADED, null);
    }

    void temporaryBreakpointSet(Context context, Breakpoint breakpoint) {
        ExtenderCallback callback = this.getCallbackFromId(breakpoint.getDebuggerExtenderID(), true);
        if (callback != null) {
            ExtenderBreakpoint extenderBreakpoint = new ExtenderBreakpoint(breakpoint);
            callback.addExtenderBreakpoint(extenderBreakpoint);
            try {
                callback.getExtender().temporaryBreakpointSet(context, (DebuggerBreakpoint)extenderBreakpoint);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    boolean canCreateCustomBreakpoint(String breakpointTypeString, Workspace workspace, Project project) {
        ExtenderCallback callback = this.getExtenderFromCustomBreakpointType(breakpointTypeString, false);
        if (callback != null) {
            try {
                return callback.getExtender().canCreateCustomBreakpoint(breakpointTypeString, workspace, project);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return true;
    }

    BreakpointDefinitionPanel getCustomBreakpointPanel(String customBreakpointType, Breakpoint breakpoint, ChangeListener changeListener) {
        ExtenderCallback callback = null;
        ExtenderBreakpoint debuggerBreakpoint = null;
        if (breakpoint != null) {
            ExtenderActionDetails details = this.getExtenderActionDetails(breakpoint, true);
            if (details != null) {
                callback = details.callback;
                debuggerBreakpoint = details.extenderBreakpoint;
            }
        } else {
            callback = this.getExtenderFromCustomBreakpointType(customBreakpointType, true);
        }
        if (callback != null) {
            try {
                DebuggerBreakpointPanel dbp = callback.getExtender().getCustomBreakpointPanel(customBreakpointType, (DebuggerBreakpoint)debuggerBreakpoint, changeListener);
                if (dbp != null) {
                    return new BreakpointDefinitionPanel(dbp, breakpoint, callback);
                }
            }
            catch (VMDisconnectedException dbp) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<String> getCustomBreakpointTypes() {
        ArrayList<String> customBreakpointTypes = new ArrayList<String>();
        customBreakpointTypes.addAll(DebuggerHook.getDebuggerExtenderCustomBreakpointTypes());
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            for (ExtenderCallback callback : this.extenderMap.values()) {
                customBreakpointTypes.addAll(callback.getCustomBreakpointTypes());
            }
        }
        return customBreakpointTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DebuggerBreakpointDeclarator getCustomBreakpointDeclarator(String customBreakpointType) {
        DebuggerBreakpointDeclarator declarator = DebuggerHook.getDebuggerExtenderCustomBreakpointDeclarator((String)customBreakpointType);
        if (declarator != null) {
            return declarator;
        }
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            for (ExtenderCallback callback : this.extenderMap.values()) {
                if (!callback.knowsCustomBreakpointType(customBreakpointType)) continue;
                return callback.getCustomBreakpointDeclarator(customBreakpointType);
            }
        }
        return null;
    }

    static int getBreakpointType(DebuggerBreakpoint.BreakpointKind kind) {
        int bpType = 0;
        switch (kind) {
            default: {
                bpType = 0;
                break;
            }
            case METHOD: {
                bpType = 1;
                break;
            }
            case URL_LINE: {
                bpType = 5;
                break;
            }
            case EXCEPTION: {
                bpType = 2;
                break;
            }
            case PROPERTIES: {
                bpType = 8;
            }
        }
        return bpType;
    }

    static Breakpoint createBreakpoint(DebuggerBreakpoint debuggerBreakpoint, Project project, String extenderId) {
        Breakpoint bp = null;
        switch (debuggerBreakpoint.getKind()) {
            case METHOD: {
                if (!(debuggerBreakpoint instanceof DebuggerMethodBreakpoint)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                DebuggerMethodBreakpoint methodBreakpoint = (DebuggerMethodBreakpoint)debuggerBreakpoint;
                bp = new Breakpoint(methodBreakpoint.getScope(), project, 1, methodBreakpoint.getMethodName());
                break;
            }
            case FILE_LINE: {
                if (!(debuggerBreakpoint instanceof DebuggerFileLineBreakpoint)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                DebuggerFileLineBreakpoint fileLineBreakpoint = (DebuggerFileLineBreakpoint)debuggerBreakpoint;
                bp = new Breakpoint(fileLineBreakpoint.getScope(), project, 0, null, fileLineBreakpoint.getPackage(), fileLineBreakpoint.getFileName(), fileLineBreakpoint.getLine());
                break;
            }
            case URL_LINE: {
                if (!(debuggerBreakpoint instanceof DebuggerURLLineBreakpoint)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                DebuggerURLLineBreakpoint urlLineBreakpoint = (DebuggerURLLineBreakpoint)debuggerBreakpoint;
                bp = new Breakpoint(urlLineBreakpoint.getScope(), project, 5, urlLineBreakpoint.getURL(), urlLineBreakpoint.getLine());
                break;
            }
            case EXCEPTION: {
                if (!(debuggerBreakpoint instanceof DebuggerExceptionBreakpoint)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                DebuggerExceptionBreakpoint exceptionBreakpoint = (DebuggerExceptionBreakpoint)debuggerBreakpoint;
                bp = new Breakpoint(exceptionBreakpoint.getScope(), 2, exceptionBreakpoint.getExceptionName(), exceptionBreakpoint.isBreakOnCaughtExceptions(), exceptionBreakpoint.isBreakOnUncaughtExceptions());
                break;
            }
            case PROPERTIES: {
                if (!(debuggerBreakpoint instanceof DebuggerPropertiesBreakpoint)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                DebuggerPropertiesBreakpoint propertiesBreakpoint = (DebuggerPropertiesBreakpoint)debuggerBreakpoint;
                bp = new Breakpoint(propertiesBreakpoint.getScope(), 8, propertiesBreakpoint.getProperties());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid breakpoint");
            }
        }
        bp.setShallow(true);
        bp.setDebuggerExtenderID(extenderId);
        bp.setEnabled(debuggerBreakpoint.isEnabled());
        bp.setCondition(debuggerBreakpoint.getCondition());
        bp.setEditCondition(debuggerBreakpoint.canEditCondition());
        bp.setHiddenCondition(debuggerBreakpoint.getHiddenCondition());
        bp.setPassCount(debuggerBreakpoint.getPassCount());
        bp.setEditPassCount(debuggerBreakpoint.canEditPassCount());
        bp.setGroupName(debuggerBreakpoint.getGroupName());
        bp.setEditGroupName(debuggerBreakpoint.canEditGroupName());
        bp.setCustomDescription(debuggerBreakpoint.getCustomDescription());
        bp.setCustomTypeString(debuggerBreakpoint.getCustomTypeString());
        bp.setThreadName(null);
        bp.setThreadNameNot(null);
        if (debuggerBreakpoint.getBreakForThreadNamed() != null) {
            bp.setThreadName(debuggerBreakpoint.getBreakForThreadNamed());
        } else if (debuggerBreakpoint.getBreakForThreadNotNamed() != null) {
            bp.setThreadNameNot(debuggerBreakpoint.getBreakForThreadNotNamed());
        }
        bp.setEditBreakForThreads(debuggerBreakpoint.canEditBreakForThreads());
        bp.setActionHalt(debuggerBreakpoint.isHaltOnBreakpointHit());
        bp.setActionBeep(debuggerBreakpoint.isBeepOnBreakpointHit());
        DebuggerBreakpointLogEntry logEntry = debuggerBreakpoint.getLogEntryOnBreakpointHit();
        if (logEntry != null) {
            bp.setActionLog(logEntry.isEnabled());
            bp.setActionLogStack(logEntry.isLogStackTrace());
            bp.setActionLogExpression(logEntry.getLogExpression());
            bp.setActionLogTag(logEntry.getLogTag());
        } else {
            bp.setActionLog(false);
            bp.setActionLogStack(false);
            bp.setActionLogExpression(null);
            bp.setActionLogTag(null);
        }
        bp.setActionEnableOther(debuggerBreakpoint.getEnableBreakpointGroupOnBreakpointHit());
        bp.setActionDisableOther(debuggerBreakpoint.getDisableBreakpointGroupOnBreakpointHit());
        bp.setEditBreakpointHitActions(debuggerBreakpoint.canEditBreakpointHitActions());
        bp.setProperties(debuggerBreakpoint.getProperties());
        bp.setShallow(false);
        return bp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtenderCallback getExtenderFromCustomBreakpointType(String customBreakpointType, boolean forceLoadingOfExtender) {
        String extenderId = DebuggerHook.getDebuggerExtenderCustomBreakpointExtenderId((String)customBreakpointType);
        if (this.hasExtender(extenderId) || forceLoadingOfExtender) {
            Map<String, ExtenderCallback> map = this.extenderMap;
            synchronized (map) {
                DebuggerBreakpointDeclarator bpDeclarator = this.getCustomBreakpointDeclarator(customBreakpointType);
                if (bpDeclarator != null) {
                    return this.getCallbackFromId(extenderId, true);
                }
            }
        }
        return null;
    }

    private Breakpoint overrideStepping(DebuggingProcess process, BreakpointDetails breakpointDetails, ExtenderAction action) {
        DebuggerBreakpoint debuggerBreakpoint;
        DebuggerExtender extender = breakpointDetails.getDebuggerExtender();
        ExtenderCallback callback = breakpointDetails.getExtenderCallback();
        if (extender != null && callback != null && (debuggerBreakpoint = breakpointDetails.getDebuggerBreakpoint()) != null) {
            try {
                switch (action) {
                    case STEP_OVER: {
                        debuggerBreakpoint = extender.stepOver(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    case STEP_INTO: {
                        debuggerBreakpoint = extender.stepInto(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    case STEP_OUT: {
                        debuggerBreakpoint = extender.stepOut(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    case STEP_TO_END_OF_METHOD: {
                        debuggerBreakpoint = extender.stepToEndOfMethod(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    case RUN_TO_CURSOR: {
                        debuggerBreakpoint = extender.runToCursor(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    default: {
                        throw new Exception();
                    }
                }
                if (debuggerBreakpoint != null) {
                    return ExtenderManager.createBreakpoint(debuggerBreakpoint, null, callback.getExtenderId());
                }
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
            catch (VMDisconnectedException iae) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return null;
    }

    private boolean canOverrideStepping(DebuggingProcess process, BreakpointDetails breakpointDetails, ExtenderAction action) {
        DebuggerBreakpoint debuggerBreakpoint;
        DebuggerExtender extender = breakpointDetails.getDebuggerExtender();
        if (extender != null && (debuggerBreakpoint = breakpointDetails.getDebuggerBreakpoint()) != null) {
            try {
                switch (action) {
                    case STEP_OVER: {
                        return extender.canStepOver(process.getContext(), debuggerBreakpoint);
                    }
                    case STEP_INTO: {
                        return extender.canStepInto(process.getContext(), debuggerBreakpoint);
                    }
                    case STEP_OUT: {
                        return extender.canStepOut(process.getContext(), debuggerBreakpoint);
                    }
                    case STEP_TO_END_OF_METHOD: {
                        return extender.canStepToEndOfMethod(process.getContext(), debuggerBreakpoint);
                    }
                    case RUN_TO_CURSOR: {
                        return extender.canRunToCursor(process.getContext(), debuggerBreakpoint);
                    }
                }
                throw new Exception();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return false;
    }

    private boolean doExtenderAction(ExtenderAction action, Context context, BreakpointDetails breakpointDetails) {
        DebuggerBreakpoint debuggerBreakpoint;
        DebuggerExtender extender = breakpointDetails.getDebuggerExtender();
        if (extender != null && (debuggerBreakpoint = breakpointDetails.getDebuggerBreakpoint()) != null) {
            try {
                switch (action) {
                    case CAN_SHOW_IP_LOCATION: {
                        return extender.canShowIPLocation(context, debuggerBreakpoint);
                    }
                    case SHOW_IP_LOCATION: {
                        return extender.showIPLocation(context, debuggerBreakpoint);
                    }
                }
                throw new Exception();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return false;
    }

    private boolean doExtenderAction(ExtenderAction action, Context context, DebugLocation location) {
        DebuggerExtender2 extender = this.getExtenderForLocation(location);
        if (extender != null) {
            try {
                switch (action) {
                    case CAN_SHOW_IP_LOCATION: {
                        return extender.canShowIPLocation(context, (DebuggerLocation)location);
                    }
                    case SHOW_IP_LOCATION: {
                        return extender.showIPLocation(context, (DebuggerLocation)location);
                    }
                }
                throw new Exception();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return false;
    }

    private boolean doExtenderAction(ExtenderAction action, Context context, Breakpoint breakpoint, boolean forceLoadingOfExtender) {
        ExtenderActionDetails details = this.getExtenderActionDetails(breakpoint, forceLoadingOfExtender);
        if (details != null) {
            try {
                DebuggerExtender extender = details.extender;
                ExtenderBreakpoint extenderBreakpoint = details.extenderBreakpoint;
                ExtenderCallback callback = details.callback;
                switch (action) {
                    case SHOW_BREAKPOINT_LOCATION: {
                        return extender.showBreakpointLocation(context, (DebuggerBreakpoint)extenderBreakpoint);
                    }
                    case CAN_SHOW_BREAKPOINT_LOCATION: {
                        return extender.canShowBreakpointLocation(context, (DebuggerBreakpoint)extenderBreakpoint);
                    }
                    case BREAKPOINT_DELETED: {
                        callback.deleteExtenderBreakpoint(extenderBreakpoint);
                        extender.breakpointDeleted((DebuggerBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case IS_EXTENDER_BREAKPOINT: {
                        return true;
                    }
                    case UPDATE_BREAKPOINT_ICON: {
                        extender.updateBreakpointIcon((DebuggerBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case SHOW_BREAKPOINT_ICON: {
                        extender.breakpointInScope((DebuggerBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case HIDE_BREAKPOINT_ICON: {
                        extender.breakpointOutOfScope((DebuggerBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case BREAKPOINT_MOVED: {
                        extender.breakpointChanged((DebuggerBreakpoint)extenderBreakpoint, DebuggerBreakpoint.BreakpointState.MOVED);
                        return true;
                    }
                    case BREAKPOINT_REFACTORED: {
                        extender.breakpointChanged((DebuggerBreakpoint)extenderBreakpoint, DebuggerBreakpoint.BreakpointState.REFACTORED);
                        return true;
                    }
                    case BREAKPOINT_EDITED: {
                        extender.breakpointChanged((DebuggerBreakpoint)extenderBreakpoint, DebuggerBreakpoint.BreakpointState.EDITED);
                        return true;
                    }
                    case BREAKPOINT_ADDED: {
                        extender.breakpointAdded((DebuggerBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case BREAKPOINT_SCOPE_CHANGED: {
                        extender.breakpointChanged((DebuggerBreakpoint)extenderBreakpoint, DebuggerBreakpoint.BreakpointState.SCOPE_CHANGED);
                        return true;
                    }
                }
                throw new Exception();
            }
            catch (VMDisconnectedException extender) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callAllExtenders(ExtenderAction action, Context context) {
        ArrayList<ExtenderCallback> callbacks = new ArrayList<ExtenderCallback>();
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            for (ExtenderCallback callback2 : this.extenderMap.values()) {
                callbacks.add(callback2);
            }
        }
        for (ExtenderCallback callback : callbacks) {
            try {
                switch (action) {
                    case NEW_DEBUG_SESSION: {
                        callback.getExtender().newDebugSession(context);
                        break;
                    }
                    case BREAKPOINTS_LOADED: {
                        callback.getExtender().breakpointsLoaded();
                        break;
                    }
                    default: {
                        throw new Exception();
                    }
                }
            }
            catch (VMDisconnectedException callback2) {
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    private ExtenderActionDetails getExtenderActionDetails(Breakpoint breakpoint, boolean forceLoadingOfExtender) {
        ExtenderBreakpoint extenderBreakpoint;
        if (breakpoint == null) {
            return null;
        }
        ExtenderCallback callback = this.getCallbackFromId(breakpoint.getDebuggerExtenderID(), forceLoadingOfExtender);
        if (callback != null && (extenderBreakpoint = callback.getExtenderBreakpoint(breakpoint)) != null) {
            return new ExtenderActionDetails(callback, extenderBreakpoint);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtenderCallback getCallbackFromId(String id, boolean forceLoadingOfExtender) {
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            if (this.hasExtender(id)) {
                return this.extenderMap.get(id);
            }
            if (forceLoadingOfExtender) {
                return this.addExtender(id);
            }
            return null;
        }
    }

    private DebuggerExtender2 getExtenderForLocation(DebugLocation debugLocation) {
        String sourceFileName = debugLocation.getFilename();
        if (sourceFileName == null || sourceFileName.indexOf(46) == -1) {
            return null;
        }
        String extension = sourceFileName.substring(sourceFileName.lastIndexOf(46) + 1);
        String extenderId = this.sourceExtensionToDebuggerExtenderMap.get(extension);
        if (extenderId == null) {
            return null;
        }
        ExtenderCallback callback = this.extenderMap.get(extenderId);
        if (callback == null) {
            return null;
        }
        return (DebuggerExtender2)callback.getExtender();
    }

    static enum ExtenderAction {
        CAN_SHOW_IP_LOCATION,
        SHOW_IP_LOCATION,
        CAN_SHOW_BREAKPOINT_LOCATION,
        SHOW_BREAKPOINT_LOCATION,
        BREAKPOINT_DELETED,
        IS_EXTENDER_BREAKPOINT,
        STEP_OVER,
        STEP_INTO,
        RUN_TO_CURSOR,
        STEP_OUT,
        STEP_TO_END_OF_METHOD,
        SHOW_BREAKPOINT_ICON,
        HIDE_BREAKPOINT_ICON,
        UPDATE_BREAKPOINT_ICON,
        BREAKPOINTS_LOADED,
        NEW_DEBUG_SESSION,
        BREAKPOINT_MOVED,
        BREAKPOINT_REFACTORED,
        BREAKPOINT_EDITED,
        BREAKPOINT_ADDED,
        BREAKPOINT_SCOPE_CHANGED;

    }

    private class ExtenderActionDetails {
        private DebuggerExtender extender;
        private ExtenderBreakpoint extenderBreakpoint;
        private ExtenderCallback callback;

        ExtenderActionDetails(ExtenderCallback callback, ExtenderBreakpoint breakpoint) {
            this.callback = callback;
            this.extender = callback.getExtender();
            this.extenderBreakpoint = breakpoint;
        }
    }
}

