/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.runner.DebuggerLocation;
import oracle.ideimpl.runner.ETTriggerLocationFileLine;
import oracle.ideimpl.runner.ExecutionEventType;
import oracle.ideimpl.runner.ExecutionTrackingTrigger;
import oracle.ideimpl.runner.MethodDescriptor;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.ExecutionTrackerForVirtualMachine;
import oracle.jdevimpl.runner.debug.ExecutionTrackingInfoImpl;
import oracle.jdevimpl.runner.debug.ExecutionTrackingVM;
import oracle.jdevimpl.runner.debug.VMExecutionEvent;
import oracle.jdevimpl.runner.debug.VMExecutionListener;

public final class ExecutionTrackerImplForVirtualMachine
implements ExecutionTrackerForVirtualMachine {
    private DebugLocation currentLocation;
    private List<VMExecutionListener> listeners = new ArrayList<VMExecutionListener>();
    private DebugThreadInfo threadToTrack;
    private DebugVirtualMachine vm;
    private int depthWhereStarted;
    private boolean isActive = false;
    private List<ExecutionTrackingTrigger> locationTriggers = new ArrayList<ExecutionTrackingTrigger>();

    public ExecutionTrackerImplForVirtualMachine(DebugVirtualMachine vm) {
        this.vm = vm;
        if (vm != null && vm instanceof ExecutionTrackingVM) {
            ((ExecutionTrackingVM)((Object)vm)).setExecutionTracker(this);
        }
    }

    @Override
    public void addVMExecutionListener(VMExecutionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeVMExecutionListener(VMExecutionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isTrackingThread(long threadId) {
        return this.threadToTrack.getThreadId() == threadId;
    }

    @Override
    public void trackBackgroundStep(DebuggerLocation location) {
        boolean background = true;
        this.currentLocation = (DebugLocation)location;
        ExecutionTrackingInfoImpl info = new ExecutionTrackingInfoImpl(this.currentLocation, background);
        VMExecutionEvent event = new VMExecutionEvent(info, ExecutionEventType.DEBUGGER_STOPPING);
        this.fireEvent(event);
        this.checkLocationTriggers();
        int currentDepth = this.vm.getCurrentThread().getStackFrameCount();
        if (currentDepth < this.depthWhereStarted) {
            VMExecutionEvent event2 = new VMExecutionEvent(info, ExecutionEventType.BACKGROUND_STEP_REACHED_BACKSTOP);
            this.fireEvent(event2);
            this.stopBackgroundStepping();
        }
    }

    @Override
    public void trackBackgroundResume(DebuggerLocation location) {
        boolean background = true;
        this.currentLocation = (DebugLocation)location;
        ExecutionTrackingInfoImpl info = new ExecutionTrackingInfoImpl(this.currentLocation, background);
        VMExecutionEvent event = new VMExecutionEvent(info, ExecutionEventType.DEBUGGER_RESUMING);
        this.fireEvent(event);
    }

    private void fireEvent(VMExecutionEvent event) {
        for (VMExecutionListener l : this.listeners) {
            l.vmExecutionEvent(event);
        }
    }

    @Override
    public DebugThreadInfo getThreadToTrack() {
        return this.threadToTrack;
    }

    public void startBackgroundStepping() {
        this.threadToTrack = this.vm.getCurrentThread();
        this.depthWhereStarted = this.threadToTrack.getStackFrameCount();
        this.isActive = true;
        ExecutionTrackingInfoImpl info = new ExecutionTrackingInfoImpl(this.currentLocation, false);
        VMExecutionEvent trackingStarted = new VMExecutionEvent(info, ExecutionEventType.BACKGROUND_STEPPING_STARTED);
        this.fireEvent(trackingStarted);
    }

    public void stopBackgroundStepping() {
        ExecutionTrackingInfoImpl info = new ExecutionTrackingInfoImpl(this.currentLocation, false);
        VMExecutionEvent trackingStopped = new VMExecutionEvent(info, ExecutionEventType.BACKGROUND_STEPPING_STOPPED);
        this.fireEvent(trackingStopped);
        this.isActive = false;
    }

    public boolean isBackgroundStepping() {
        return this.isActive;
    }

    public void addTrigger(ExecutionTrackingTrigger trigger) {
        if (trigger.getTriggerType() != ExecutionTrackingTrigger.TriggerType.LOCATION) {
            throw new IllegalArgumentException("Unsupported trigger type " + trigger.getTriggerType());
        }
        this.locationTriggers.add(trigger);
    }

    public void removeTrigger(ExecutionTrackingTrigger trigger) {
        if (trigger.getTriggerType() == ExecutionTrackingTrigger.TriggerType.LOCATION) {
            this.locationTriggers.remove(trigger);
        }
    }

    private void checkLocationTriggers() {
        String reachedFilename = this.currentLocation.getFilename().replaceAll(".java", "");
        for (ExecutionTrackingTrigger trigger : this.locationTriggers) {
            ETTriggerLocationFileLine triggerLocation;
            if (!(trigger.getTriggerLocation() instanceof ETTriggerLocationFileLine) || !(triggerLocation = (ETTriggerLocationFileLine)trigger.getTriggerLocation()).getFilename().equals(reachedFilename) || triggerLocation.getLine() != this.currentLocation.getLine()) continue;
            ExecutionTrackingInfoImpl info = new ExecutionTrackingInfoImpl(this.currentLocation, false);
            VMExecutionEvent event = new VMExecutionEvent(info, ExecutionEventType.LOCATION_TRIGGER_HIT);
            this.fireEvent(event);
            switch (trigger.getAction()) {
                case START_BACKGROUND_STEPPING: {
                    this.startBackgroundStepping();
                    break;
                }
                case STOP_BACKGROUND_STEPPING: {
                    this.stopBackgroundStepping();
                }
            }
        }
    }

    @Override
    public void trackClassRedefinition(DebugClassInfo clazz) {
        ExecutionTrackingInfoImpl info = new ExecutionTrackingInfoImpl(clazz);
        VMExecutionEvent classRedefined = new VMExecutionEvent(info, ExecutionEventType.CLASS_REDEFINED);
        this.fireEvent(classRedefined);
    }

    @Override
    public void trackMethodEntry(DebuggerLocation location, MethodDescriptor method, int invocationCount) {
        this.currentLocation = (DebugLocation)location;
        ExecutionTrackingInfoImpl info = new ExecutionTrackingInfoImpl(this.currentLocation, false);
        info.setMethodDescriptor(method);
        VMExecutionEvent methodEntered = new VMExecutionEvent(info, ExecutionEventType.METHOD_ENTERED);
        this.fireEvent(methodEntered);
    }
}

