/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.jdevimpl.debugger.Breakpoint;
import oracle.jdevimpl.debugger.BreakpointConditionEvaluationResult;
import oracle.jdevimpl.debugger.SingleConditionEvaluationResult;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointCondition;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.BreakpointRuntimeSupport;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.Evaluator;

class DebugBreakpointConditionImpl
implements DebugBreakpointCondition {
    private Breakpoint breakpoint;

    DebugBreakpointConditionImpl(Breakpoint breakpoint) {
        this.breakpoint = breakpoint;
    }

    @Override
    public boolean checkBreakpointCondition(DebugBreakpoint bp, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        block11: {
            BreakpointConditionEvaluationResult resultReporter = null;
            if (bp instanceof BreakpointConditionEvaluationResult) {
                resultReporter = (BreakpointConditionEvaluationResult)bp;
            }
            try {
                if (stack.length > 0) {
                    BreakpointConditionEvaluationResult.ResultType rt;
                    String condition = this.getConditionText();
                    Evaluator evaluator = new Evaluator(true);
                    evaluator.setDebugContext(vm, thread, stack[0]);
                    SingleConditionEvaluationResult result = evaluator.evaluateCondition(condition);
                    if (resultReporter != null) {
                        resultReporter.addResult(thread.getThreadId(), result);
                    }
                    if ((rt = result.getResultType()) == BreakpointConditionEvaluationResult.ResultType.RETRIABLE_EXCEPTION) {
                        return true;
                    }
                    if (rt == BreakpointConditionEvaluationResult.ResultType.COULD_NOT_EVALUATE || rt == BreakpointConditionEvaluationResult.ResultType.NOT_BOOLEAN) {
                        String msg = result.getMessage();
                        DebuggingProcess debuggingProcess = BreakpointRuntimeSupport.getDebugginProcess(this.breakpoint, bp);
                        debuggingProcess.addMessage(msg);
                        return true;
                    }
                    if (rt == BreakpointConditionEvaluationResult.ResultType.NOT_BOOLEAN) {
                        String msg = result.getMessage();
                        DebuggingProcess debuggingProcess = BreakpointRuntimeSupport.getDebugginProcess(this.breakpoint, bp);
                        debuggingProcess.addMessage(msg);
                    } else {
                        if (rt == BreakpointConditionEvaluationResult.ResultType.FALSE) {
                            return false;
                        }
                        if (rt == BreakpointConditionEvaluationResult.ResultType.TRUE) {
                            return true;
                        }
                    }
                }
            }
            catch (Throwable e) {
                if (!(e instanceof ThreadDeath)) break block11;
                throw (ThreadDeath)e;
            }
        }
        return false;
    }

    @Override
    public String getConditionText() {
        String condition = this.breakpoint.getCondition();
        String hiddenCondition = this.breakpoint.getHiddenCondition();
        if (hiddenCondition.length() == 0) {
            return condition;
        }
        if (condition.length() == 0) {
            return hiddenCondition;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("((");
        buf.append(hiddenCondition);
        buf.append(") && (");
        buf.append(condition);
        buf.append("))");
        return buf.toString();
    }
}

