/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

class DataTableMouseAdapter
extends MouseAdapter {
    private JTable table;
    private DataPanel dataPanel;

    public DataTableMouseAdapter(JTable table, DataPanel dataPanel) {
        this.table = table;
        this.dataPanel = dataPanel;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int col = this.table.convertColumnIndexToView(1);
        Rectangle rect = this.table.getCellRect(0, col, true);
        rect.height = this.table.getHeight();
        this.table.repaint(rect);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        int col = this.table.convertColumnIndexToView(1);
        Rectangle rect = this.table.getCellRect(0, col, true);
        rect.height = this.table.getHeight();
        this.table.repaint(rect);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.dataPanel.showPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.dataPanel.showPopup(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.dataPanel.getDebuggingProcess() == null || !this.dataPanel.getDebuggingProcess().isStopped()) {
            Toolkit.getDefaultToolkit().beep();
            DebuggingProcess.showStatus(DbgArb.format(310, this.dataPanel.getTitle()));
        }
        int columnAtX = this.table.getColumnModel().getColumnIndexAtX(e.getX());
        int column = this.table.convertColumnIndexToModel(columnAtX);
        if (e.getClickCount() == 2) {
            this.dataPanel.getController().handleDoubleClickOrEnter(e, column);
        }
    }

    protected DataItem getDataItemUnderMouse(MouseEvent e) {
        int rowAtY = this.table.rowAtPoint(new Point(e.getX(), e.getY()));
        if (rowAtY != -1) {
            int row = this.table.convertRowIndexToModel(rowAtY);
            return this.dataPanel.getDataItemForRow(row);
        }
        return null;
    }
}

