/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.macros.MacroUtils;
import oracle.ideimpl.macros.ui.MacroCompletionProvider;
import oracle.ideimpl.macros.ui.MacroDialogOptions;
import oracle.ideimpl.macros.ui.MacroSelectionDialog;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.completion.CompletionPopupHandler;
import oracle.javatools.ui.completion.CompletionProvider;
import oracle.javatools.ui.completion.CompletionTextField;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurationEditorUtil;
import oracle.jdeveloper.runner.RunningProcess;
import oracle.jdevimpl.runner.DefaultRunnablePanel;
import oracle.jdevimpl.runner.RunMgrArb;

public class RunConfigurationLaunchPanel
extends DefaultTraversablePanel {
    private DefaultRunnablePanel defaultRunnablePanel = new DefaultRunnablePanel();
    private final JComboBox vmComboBox;
    private final CompletionTextField javaOptionsTextField;
    private final CompletionTextField programArgsTextField;
    private final URLTextField runDirTextField;
    private final JButton runDirButton;
    private final JButton macroRunDirButton;
    private final JCheckBox remoteDebuggingProfilingCheckBox;
    private String pathMacroSelection;

    RunConfigurationLaunchPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_run_projset_runnerpanel_html");
        JLabel vmLabel = new JLabel();
        this.vmComboBox = new JComboBox();
        JLabel javaOptionsLabel = new JLabel();
        this.javaOptionsTextField = new CompletionTextField();
        CompletionPopupHandler popupHandler = this.javaOptionsTextField.getPopupHandler();
        final Context context = Context.newIdeContext();
        MacroCompletionProvider macroCompletionProvider = new MacroCompletionProvider(context);
        popupHandler.registerInsightProvider((CompletionProvider)macroCompletionProvider);
        JLabel programArgsLabel = new JLabel();
        this.programArgsTextField = new CompletionTextField();
        popupHandler = this.programArgsTextField.getPopupHandler();
        popupHandler.registerInsightProvider((CompletionProvider)macroCompletionProvider);
        JLabel runDirLabel = new JLabel();
        this.runDirTextField = new URLTextField(null, true, false);
        this.runDirButton = new JButton();
        this.remoteDebuggingProfilingCheckBox = new JCheckBox();
        this.macroRunDirButton = new JButton();
        ResourceUtils.resLabel((JLabel)vmLabel, (Component)this.vmComboBox, (String)RunMgrArb.getString(28));
        ResourceUtils.resLabel((JLabel)javaOptionsLabel, (Component)this.javaOptionsTextField, (String)RunMgrArb.getString(29));
        ResourceUtils.resLabel((JLabel)programArgsLabel, (Component)this.programArgsTextField, (String)RunMgrArb.getString(30));
        ResourceUtils.resLabel((JLabel)runDirLabel, (Component)this.runDirTextField, (String)RunMgrArb.getString(31));
        ResourceUtils.resButton((AbstractButton)this.runDirButton, (String)RunMgrArb.getString(32));
        ResourceUtils.resButton((AbstractButton)this.macroRunDirButton, (String)RunMgrArb.getString(105));
        this.runDirTextField.setDialogTitle(RunMgrArb.getString(33));
        this.runDirButton.addActionListener((ActionListener)this.runDirTextField);
        ResourceUtils.resButton((AbstractButton)this.remoteDebuggingProfilingCheckBox, (String)RunMgrArb.getString(34));
        this.macroRunDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MacroDialogOptions options = new MacroDialogOptions();
                options.setDialogTitle(RunMgrArb.getString(107));
                options.setEnableFiltering(true);
                options.setRestrictToLocationMacros(true);
                if (MacroSelectionDialog.showDialog((MacroDialogOptions)options, (Context)context)) {
                    RunConfigurationLaunchPanel.this.pathMacroSelection = MacroSelectionDialog.getSelection();
                    if (RunConfigurationLaunchPanel.this.pathMacroSelection != null) {
                        RunConfigurationLaunchPanel.this.runDirTextField.setText(RunConfigurationLaunchPanel.this.pathMacroSelection);
                        RunConfigurationLaunchPanel.this.runDirTextField.setActiveMacro(RunConfigurationLaunchPanel.this.pathMacroSelection, MacroUtils.getValue((Context)context, (String)RunConfigurationLaunchPanel.this.pathMacroSelection));
                    }
                }
            }
        });
        JPanel vmPanel = this.makeVMPanel(vmLabel, javaOptionsLabel);
        JPanel programArgsPanel = this.makeProgramArgsPanel(programArgsLabel);
        JPanel runDirPanel = this.makeRunDirPanel(runDirLabel);
        int y = 0;
        this.setLayout(new GridBagLayout());
        this.add(this.defaultRunnablePanel, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(vmPanel, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(programArgsPanel, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
        this.add(runDirPanel, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(this.remoteDebuggingProfilingCheckBox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel makeVMPanel(JLabel vmLabel, JLabel javaOptionsLabel) {
        JPanel vmPanel = new JPanel(new GridBagLayout());
        int y = 0;
        vmPanel.add((Component)vmLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 20), 0, 0));
        vmPanel.add((Component)javaOptionsLabel, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        vmPanel.add((Component)this.vmComboBox, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 20), 0, 0));
        vmPanel.add((Component)this.javaOptionsTextField, new GridBagConstraints(1, y, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        return vmPanel;
    }

    private JPanel makeProgramArgsPanel(JLabel programArgsLabel) {
        JPanel programArgsPanel = new JPanel(new GridBagLayout());
        int y = 0;
        programArgsPanel.add((Component)programArgsLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        programArgsPanel.add((Component)this.programArgsTextField, new GridBagConstraints(0, y, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return programArgsPanel;
    }

    private JPanel makeRunDirPanel(JLabel runDirLabel) {
        JPanel runDirPanel = new JPanel(new GridBagLayout());
        int y = 0;
        runDirPanel.add((Component)runDirLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        runDirPanel.add((Component)this.runDirTextField, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        runDirPanel.add((Component)this.macroRunDirButton, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        runDirPanel.add((Component)this.runDirButton, new GridBagConstraints(2, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        return runDirPanel;
    }

    public void onEntry(TraversableContext tc) {
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)tc);
        this.loadFrom(runConfiguration);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)tc);
        this.commitTo(runConfiguration);
    }

    private void loadFrom(RunConfiguration runConfiguration) {
        Project activeProject = Ide.getActiveProject();
        JDK jdkDefinition = JProjectLibraries.getInstance((PropertyStorage)activeProject).getJDK();
        this.setupVMComboBox(runConfiguration, jdkDefinition);
        this.defaultRunnablePanel.loadFrom(runConfiguration, activeProject);
        this.javaOptionsTextField.setText(runConfiguration.getJavaOptions(false));
        this.programArgsTextField.setText(runConfiguration.getProgramArguments(false));
        URL runDir = runConfiguration.getRunDirectoryURL(false);
        this.runDirTextField.setURL(runDir);
        this.remoteDebuggingProfilingCheckBox.setSelected(runConfiguration.isRemoteDebuggingProfiling());
    }

    private void commitTo(RunConfiguration runConfiguration) throws TraversalException {
        String vm = (String)this.vmComboBox.getSelectedItem();
        if (vm == null) {
            throw new TraversalException(RunMgrArb.getString(35));
        }
        runConfiguration.setVMName(vm);
        Project activeProject = Ide.getActiveProject();
        Context context = Context.newIdeContext((Node)activeProject);
        context.setWorkspace(Ide.getActiveWorkspace());
        context.setProject(activeProject);
        RunningProcess jrunProcess = new RunningProcess(context);
        if (!this.defaultRunnablePanel.validateDefaultRunTarget(jrunProcess)) {
            throw new TraversalException(null);
        }
        this.defaultRunnablePanel.commitTo(runConfiguration);
        runConfiguration.setJavaOptions(this.javaOptionsTextField.getText());
        runConfiguration.setProgramArguments(this.programArgsTextField.getText());
        String text = this.runDirTextField.getText();
        URL url = this.runDirTextField.getURL(false);
        if (url == null) {
            if (!text.startsWith("${")) {
                url = URLFactory.newDirURL((String)context.getProject().getBaseDirectory());
                url = URLFactory.newURL((URL)url, (String)text);
            } else {
                url = URLFactory.newDirURL((String)".");
                url = URLFactory.replacePathPart((URL)url, (String)text);
            }
            URLFileSystem.canonicalize((URL)url);
        }
        runConfiguration.setRunDirectoryURL(url);
        runConfiguration.setRemoteDebuggingProfiling(this.remoteDebuggingProfilingCheckBox.isSelected());
    }

    private void setupVMComboBox(RunConfiguration runConfiguration, JDK jdkDefinition) {
        Object[] vmChoices = jdkDefinition.getInstalledVMs();
        if (vmChoices == null || vmChoices.length == 0) {
            vmChoices = new String[]{""};
        }
        this.vmComboBox.setModel(new NonNullableComboBoxModel(vmChoices));
        String vmName = runConfiguration.getVMName(jdkDefinition);
        if (vmName == null) {
            vmName = "";
        }
        this.vmComboBox.setSelectedItem(vmName);
    }

    public static boolean showTargetDialog(Project project) {
        return RunConfigurationLaunchPanel.showTargetDialog(project, null);
    }

    public static boolean showTargetDialog(Project project, final JRunProcess jrunProcess) {
        RunConfiguration runConfiguration = RunConfiguration.getInstance((PropertyStorage)project);
        JLabel messageLabel = new JLabel();
        messageLabel.setText(RunMgrArb.getString(21));
        final DefaultRunnablePanel defaultRunnablePanel = new DefaultRunnablePanel();
        JPanel panel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(5);
        panel.setLayout(borderLayout);
        panel.add((Component)messageLabel, "North");
        panel.add((Component)defaultRunnablePanel, "Center");
        String title = RunMgrArb.getString(20);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)defaultRunnablePanel.getInitialFocus(), (String)title);
        dlg.setResizable(true);
        defaultRunnablePanel.setJEWTDialog(dlg);
        defaultRunnablePanel.loadFrom(runConfiguration, project);
        dlg.setOKButtonEnabled(defaultRunnablePanel.canOk());
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_run_runtargetdialog_html");
        if (jrunProcess != null) {
            dlg.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && !defaultRunnablePanel.validateDefaultRunTarget(jrunProcess)) {
                        throw new PropertyVetoException("no", evt);
                    }
                }
            });
        }
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            defaultRunnablePanel.commitTo(runConfiguration);
            project.markDirty(true);
            return true;
        }
        return false;
    }
}

