/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.SharedPropertiesAdapter;
import oracle.ide.model.SharedPropertiesManager;
import oracle.ide.model.Workspace;
import oracle.ideimpl.macros.MacroUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdeveloper.runner.RunMgrArb;
import oracle.jdevimpl.runner.EnvironmentVariable;
import oracle.jdevimpl.runner.debug.DebugConfigurationAccessor;

public class RunConfiguration
extends SharedPropertiesAdapter
implements PropertyStorage {
    public static final String RUN_CONFIGURATION_NAME = "name";
    public static final String REMOTE_DEBUGGING_PROFILING = "remoteDebuggingProfiling";
    private Context context;
    private static final SharedPropertiesManager sharedPropertiesManager = SharedPropertiesManager.get();
    public static final String NAME = "name";
    public static final String CUSTOM = "custom";
    public static final String RUN_DIRECTORY_URL = "runDirectoryURL";
    public static final String VM_NAME = "VMName";
    public static final String JAVA_OPTIONS = "javaOptions";
    public static final String TARGET_URL = "targetURL";
    public static final String RUN_ACTIVE_FILE = "runActiveFile";
    public static final String PROGRAM_ARGUMENTS = "programArguments";
    public static final String CONNECTION_NAME = "connectionName";
    public static final String COMPILE_BEFORE_RUN = "compileBeforeRun";
    public static final String COMPILE_PROJECT_ONLY_BEFORE_RUN = "compileProjectOnlyBeforeRun";
    public static final String RUN_ANT_BEFORE_RUN = "runAntBeforeRun";
    public static final String RUN_ANT_BEFORE_COMPILE = "runAntBeforeCompile";
    public static final String CLEAR_LOG_BEFORE_RUN = "clearLogBeforeRun";
    public static final String SAVE_ALL_BEFORE_RUN = "saveAllBeforeRun";
    public static final String LOG_COMMAND = "logCommand";
    public static final String LOG_OUTPUT = "logOutput";
    public static final String LOG_ERROR = "logError";
    public static final String ALLOW_INPUT = "allowInput";
    public static final String LOG_EXIT = "logExit";
    public static final String USE_PROXY = "useProxy";
    public static final String ENV_VARIABLES = "EnvironmentVariables";

    public RunConfiguration(HashStructure hash) {
        super(hash);
    }

    public RunConfiguration() {
        super(HashStructure.newInstance());
    }

    public RunConfiguration(RunConfiguration copyFrom, String name, boolean custom) {
        super(HashStructure.newInstance());
        if (copyFrom != null) {
            copyFrom.getProperties().copyTo(this._hash);
        }
        this.setName(name);
        this.setCustom(custom);
    }

    public static RunConfiguration getInstance(PropertyStorage propertyStorage) {
        if (propertyStorage instanceof Project) {
            Project project = (Project)propertyStorage;
            Workspace workspace = project.getWorkspace();
            if (workspace == null) {
                workspace = Ide.getActiveWorkspace();
            }
            Context rcContext = new Context(project.getWorkspace(), project);
            RunConfiguration instance = RunConfigurations.getActiveRunConfiguration(project, workspace, false);
            instance.context = rcContext;
            return instance;
        }
        if (propertyStorage instanceof Workspace) {
            Workspace workspace = (Workspace)propertyStorage;
            Project project = Ide.getActiveProject();
            Context rcContext = new Context(workspace, null);
            RunConfiguration instance = RunConfigurations.getActiveRunConfiguration(project, workspace, true);
            instance.context = rcContext;
            return instance;
        }
        return null;
    }

    @Deprecated
    public static RunConfiguration getRunConfiguration(Project project, String configName) {
        return RunConfiguration.getInstance((PropertyStorage)project);
    }

    public static RunConfiguration createNewInstance(HashStructure hash, String name, boolean isCustom, boolean useWorkspacePropertyStorage) {
        RunConfiguration runConfig;
        RunConfiguration runConfiguration = runConfig = hash == null ? new RunConfiguration() : new RunConfiguration(hash);
        if (name != null) {
            runConfig.setName(name);
        } else if (useWorkspacePropertyStorage) {
            runConfig.setName(RunMgrArb.getString(2));
        } else {
            runConfig.setName(isCustom ? RunMgrArb.getString(1) : RunMgrArb.getString(0));
        }
        runConfig.setCustom(isCustom);
        return runConfig;
    }

    @Deprecated
    public static String getDefaultName() {
        Project project = Ide.getActiveProject();
        if (project == null) {
            project = Ide.getDefaultProject();
        }
        return RunConfiguration.getDefaultName(project);
    }

    public static String getDefaultName(Project project) {
        if (sharedPropertiesManager.isUsingSharedProperties(project, "oracle.jdeveloper.runner.RunConfigurations")) {
            return RunMgrArb.getString(2);
        }
        return RunMgrArb.getString(0);
    }

    public String toString() {
        return this.getName();
    }

    public HashStructure getProperties() {
        return this.getHashStructure();
    }

    public void restoreDefaults() {
        String name = this.getName();
        boolean custom = this.isCustom();
        this.getHashStructure().clear();
        this.setName(name);
        this.setCustom(custom);
    }

    public String getName() {
        return this.getHashStructure().getString("name", "");
    }

    public void setName(String name) {
        if (name == null) {
            name = "";
        }
        this.getHashStructure().putString("name", name);
    }

    public boolean isCustom() {
        return this.getHashStructure().getBoolean(CUSTOM, false);
    }

    public void setCustom(boolean custom) {
        this.getHashStructure().putBoolean(CUSTOM, custom);
    }

    public URL getRunDirectoryURL(boolean expandMacros) {
        if (!expandMacros) {
            return this.getHashStructure().getURL(RUN_DIRECTORY_URL, null);
        }
        String asStored = this._hash.getString(RUN_DIRECTORY_URL, null);
        if (asStored != null && MacroUtils.isMacroExpression((String)asStored)) {
            return MacroUtils.expandAndMakeURL((Context)this.context, (String)asStored);
        }
        return this.getHashStructure().getURL(RUN_DIRECTORY_URL, null);
    }

    public URL getRunDirectoryURL() {
        return this.getRunDirectoryURL(true);
    }

    public void setRunDirectoryURL(URL runDirectoryURL) {
        if (runDirectoryURL == null || runDirectoryURL.getProtocol().equals("file") || runDirectoryURL.getProtocol().equals("macro")) {
            this.getHashStructure().putURL(RUN_DIRECTORY_URL, runDirectoryURL);
        }
    }

    private String getVMName(String defaultValue) {
        return this.getHashStructure().getString(VM_NAME, defaultValue);
    }

    public void setVMName(String vmName) {
        this.getHashStructure().putString(VM_NAME, vmName);
    }

    public String getJavaOptions(boolean expandMacros) {
        String asStored = this.getHashStructure().getString(JAVA_OPTIONS, "");
        if (!expandMacros) {
            return asStored;
        }
        return MacroUtils.expand((Context)this.context, (String)asStored);
    }

    public String getJavaOptions() {
        return this.getJavaOptions(true);
    }

    public void setJavaOptions(String javaOptions) {
        if (javaOptions == null) {
            javaOptions = "";
        }
        this.getHashStructure().putString(JAVA_OPTIONS, javaOptions);
    }

    public URL getTargetURL(boolean expandMacros) {
        if (!expandMacros) {
            return this.getHashStructure().getURL(TARGET_URL);
        }
        String asStored = this.getHashStructure().getString(TARGET_URL);
        if (asStored != null && MacroUtils.isMacroExpression((String)asStored)) {
            return MacroUtils.expandAndMakeURL((Context)this.context, (String)asStored);
        }
        return this.getHashStructure().getURL(TARGET_URL);
    }

    public URL getTargetURL() {
        return this.getTargetURL(true);
    }

    public void setTargetURL(URL targetURL) {
        this.getHashStructure().putURL(TARGET_URL, targetURL);
    }

    public boolean isRunActiveFile() {
        return this.getHashStructure().getBoolean(RUN_ACTIVE_FILE, true);
    }

    public void setRunActiveFile(boolean runActiveFile) {
        this.getHashStructure().putBoolean(RUN_ACTIVE_FILE, runActiveFile);
    }

    public String getProgramArguments(boolean expandMacros) {
        String asStored = this.getHashStructure().getString(PROGRAM_ARGUMENTS, "");
        if (!expandMacros) {
            return asStored;
        }
        return MacroUtils.expand((Context)this.context, (String)asStored);
    }

    public String getProgramArguments() {
        return this.getProgramArguments(true);
    }

    public void setProgramArguments(String programArguments) {
        if (programArguments == null) {
            programArguments = "";
        }
        this.getHashStructure().putString(PROGRAM_ARGUMENTS, programArguments);
    }

    public boolean isRemoteDebuggingProfiling() {
        return this.getHashStructure().getBoolean(REMOTE_DEBUGGING_PROFILING, false);
    }

    public void setRemoteDebuggingProfiling(boolean remoteDebuggingProfiling) {
        this.getHashStructure().putBoolean(REMOTE_DEBUGGING_PROFILING, remoteDebuggingProfiling);
    }

    public String getConnectionName() {
        return this.getHashStructure().getString(CONNECTION_NAME, null);
    }

    public void setConnectionName(String connectionName) {
        this.getHashStructure().putString(CONNECTION_NAME, connectionName);
    }

    public boolean isCompileBeforeRun() {
        return this.getHashStructure().getBoolean(COMPILE_BEFORE_RUN, true);
    }

    public void setCompileBeforeRun(boolean compileBeforeRun) {
        this.getHashStructure().putBoolean(COMPILE_BEFORE_RUN, compileBeforeRun);
    }

    public boolean isCompileProjectOnlyBeforeRun() {
        return this.getHashStructure().getBoolean(COMPILE_PROJECT_ONLY_BEFORE_RUN, false);
    }

    public void setCompileProjectOnlyBeforeRun(boolean compileProjectOnlyBeforeRun) {
        this.getHashStructure().putBoolean(COMPILE_PROJECT_ONLY_BEFORE_RUN, compileProjectOnlyBeforeRun);
    }

    public boolean isRunAntBeforeRun() {
        return this.getHashStructure().getBoolean(RUN_ANT_BEFORE_RUN, false);
    }

    public void setRunAntBeforeRun(boolean runAntBeforeRun) {
        this.getHashStructure().putBoolean(RUN_ANT_BEFORE_RUN, runAntBeforeRun);
    }

    public boolean isRunAntBeforeCompile() {
        return this.getHashStructure().getBoolean(RUN_ANT_BEFORE_COMPILE, true);
    }

    public void setRunAntBeforeCompile(boolean runAntBeforeCompile) {
        this.getHashStructure().putBoolean(RUN_ANT_BEFORE_COMPILE, runAntBeforeCompile);
    }

    public boolean isClearLogBeforeRun() {
        return this.getHashStructure().getBoolean(CLEAR_LOG_BEFORE_RUN, true);
    }

    public void setClearLogBeforeRun(boolean clearLogBeforeRun) {
        this.getHashStructure().putBoolean(CLEAR_LOG_BEFORE_RUN, clearLogBeforeRun);
    }

    public boolean isSaveAllBeforeRun() {
        return this.getHashStructure().getBoolean(SAVE_ALL_BEFORE_RUN, false);
    }

    public void setSaveAllBeforeRun(boolean saveAllBeforeRun) {
        this.getHashStructure().putBoolean(SAVE_ALL_BEFORE_RUN, saveAllBeforeRun);
    }

    public boolean isLogCommand() {
        return this.getHashStructure().getBoolean(LOG_COMMAND, true);
    }

    public void setLogCommand(boolean logCommand) {
        this.getHashStructure().putBoolean(LOG_COMMAND, logCommand);
    }

    public boolean isLogOutput() {
        return this.getHashStructure().getBoolean(LOG_OUTPUT, true);
    }

    public void setLogOutput(boolean logOutput) {
        this.getHashStructure().putBoolean(LOG_OUTPUT, logOutput);
    }

    public boolean isLogError() {
        return this.getHashStructure().getBoolean(LOG_ERROR, true);
    }

    public void setLogError(boolean logError) {
        this.getHashStructure().putBoolean(LOG_ERROR, logError);
    }

    public boolean isAllowInput() {
        return this.getHashStructure().getBoolean(ALLOW_INPUT, false);
    }

    public void setAllowInput(boolean allowInput) {
        this.getHashStructure().putBoolean(ALLOW_INPUT, allowInput);
    }

    public boolean isLogExit() {
        return this.getHashStructure().getBoolean(LOG_EXIT, true);
    }

    public void setLogExit(boolean logExit) {
        this.getHashStructure().putBoolean(LOG_EXIT, logExit);
    }

    public boolean isUseProxy() {
        return this.getHashStructure().getBoolean(USE_PROXY, true);
    }

    public void setUseProxy(boolean useProxy) {
        this.getHashStructure().putBoolean(USE_PROXY, useProxy);
    }

    public String getVMName(JDK jdk) {
        String vmName = null;
        if (jdk != null) {
            int length;
            boolean found = false;
            String defaultVM = null;
            String[] vmChoices = jdk.getInstalledVMs();
            if (vmChoices != null && (length = vmChoices.length) > 0 && (vmName = this.getVMName(defaultVM = vmChoices[0])) != null) {
                for (int i = 0; i < length; ++i) {
                    if (!vmName.equals(vmChoices[i])) continue;
                    found = true;
                    break;
                }
            }
            if (!found && defaultVM != null) {
                return defaultVM;
            }
        }
        if (vmName == null) {
            vmName = this.getVMName("client");
        }
        return vmName;
    }

    public boolean usingOJVM(JDK jdk) {
        String vmName = this.getVMName(jdk);
        return vmName != null && vmName.startsWith("ojvm");
    }

    public boolean usingMinimal(JDK jdk) {
        String vmName = this.getVMName(jdk);
        return vmName != null && vmName.equals("minimal");
    }

    public boolean usingVanilla(JDK jdk) {
        String vmName = this.getVMName(jdk);
        return vmName != null && vmName.equals("vanilla");
    }

    public boolean usingClassic(JDK jdk) {
        String vmName = this.getVMName(jdk);
        return vmName != null && vmName.equals("classic");
    }

    private ListStructure getEnvironmentVariablesAsListStructure() {
        return this.getHashStructure().getListStructure(ENV_VARIABLES);
    }

    public void setEnvironmentVariables(ListStructure envVars) {
        this.getHashStructure().putListStructure(ENV_VARIABLES, envVars);
    }

    public List<EnvironmentVariable> getEnvironmentVariables() {
        ListStructure list = this.getEnvironmentVariablesAsListStructure();
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<EnvironmentVariable> evs = new ArrayList<EnvironmentVariable>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            EnvironmentVariable ev = new EnvironmentVariable((HashStructure)list.get(i));
            evs.add(ev);
        }
        return evs;
    }

    public Context getContext() {
        return this.context;
    }

    public String getJavaRemoteDebugPort() {
        DebugConfigurationAccessor debugConfig = DebugConfigurationAccessor.getInstance(this);
        return debugConfig.getJavaRemoteDebugPort();
    }

    public void setJavaRemoteDebugPort(String port) {
        DebugConfigurationAccessor debugConfig = DebugConfigurationAccessor.getInstance(this);
        debugConfig.setJavaRemoteDebugPort(port);
    }
}

