/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import oracle.ide.runner.DebuggerLocation;
import oracle.ideimpl.runner.MethodDescriptor;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointMethodSignature;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataPrimitiveInfo;
import oracle.jdevimpl.debugger.support.CodeExecutionBreakpoint;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.ExecutionTrackerForVirtualMachine;
import oracle.jdevimpl.runner.debug.ExpressionEvaluationException;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.ValueExpressionHelper;

public class DebugJDIExecutionTrackingBreakpointMethod
extends DebugJDIBreakpointMethodSignature
implements CodeExecutionBreakpoint {
    private int invocationCounter;
    private ExecutionTrackerForVirtualMachine executionTracker;

    DebugJDIExecutionTrackingBreakpointMethod(DebugJDI debugJDI, MethodDescriptor method) {
        super(debugJDI, method);
        this.setStop(false);
        this.executionTracker = debugJDI.getExecutionTracker(true);
    }

    public void executeAfterStop() {
        DebugThreadInfo thread = this.dj.getCurrentThread();
        DebugStackFrameInfo frame = thread.getStackFrame(0);
        DebugLocation location = frame.getLocation();
        Evaluator evaluator = new Evaluator(true);
        evaluator.setDebugContext((DebugVirtualMachine)this.dj, thread, frame);
        for (MethodDescriptor.Argument argument : this.getMethodDescriptor().getArguments()) {
            Object info = evaluator.evaluate(argument.getName());
            if (info instanceof DebugVariableInfo) {
                DebugVariableInfo dvi = (DebugVariableInfo)info;
                DebugDataInfo data = dvi.getDataInfo();
                if (data instanceof DebugJDIDataPrimitiveInfo) {
                    argument.setValue((Object)data.getValue());
                    continue;
                }
                if (data instanceof DebugDataObjectInfo) {
                    DebugDataObjectInfo ddoi = (DebugDataObjectInfo)data;
                    String expression = ValueExpressionHelper.getValueExpression((DebugDataObjectInfo)ddoi);
                    if (expression == null) {
                        argument.setValue((Object)"");
                        continue;
                    }
                    Object result = evaluator.evaluate(expression);
                    String resultString = result == null ? "null" : result.toString();
                    argument.setValue((Object)resultString);
                    continue;
                }
                if (data instanceof DebugDataArrayInfo) {
                    DebugDataArrayInfo ddai = (DebugDataArrayInfo)info;
                    DebugClassInfo cinfo = ddai.getArrayElementClassInfo();
                    argument.setValue((Object)(cinfo.getName() + "[" + ddai.getArrayCount() + "]"));
                    continue;
                }
                JDebugger.logger.trace("DebugJDIExecutionTrackingBreakpointMethod.executeAfterStop, eval arg doesn't know what to do with " + data);
                continue;
            }
            if (info instanceof ExpressionEvaluationException) {
                JDebugger.logger.trace(((ExpressionEvaluationException)info).getMessage());
                continue;
            }
            if (info != null) continue;
            argument.setValue(null);
        }
        this.executionTracker.trackMethodEntry((DebuggerLocation)location, this.getMethodDescriptor(), this.invocationCounter++);
        this.executionTracker.startBackgroundStepping();
    }
}

