/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.javatools.util.Log;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.JDebugger;

class DebugJDIAnnotationInfo
extends JDIInformationProvider
implements DebugAnnotationInfo {
    DebugJDI dj;
    int stoppedCount;
    ObjectReference orAnnotation;
    Map<String, DebugDataInfo> properties;

    DebugJDIAnnotationInfo(DebugJDI dj, ObjectReference orAnnotation) {
        this.dj = dj;
        this.stoppedCount = dj.stoppedCount;
        this.orAnnotation = orAnnotation;
    }

    public boolean hasExpired() {
        return this.dj.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new DataExpiredException();
        }
    }

    public DebugDataInfo getDataInfo() {
        this.throwIfExpired();
        return this.dj.makeData(this.orAnnotation, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DebugClassInfo getClassInfo() {
        this.throwIfExpired();
        try {
            ClassType ctAnnotation = (ClassType)this.orAnnotation.referenceType();
            Method mAnnotationType = ctAnnotation.concreteMethodByName("annotationType", "()Ljava/lang/Class;");
            if (mAnnotationType == null) return null;
            Object object = this.dj.methodCallLock;
            synchronized (object) {
                List prev = this.dj.tempDisableRequests();
                try {
                    ClassObjectReference corAnnotationType = null;
                    DebugWindowSettings dbgSettings = DebugWindowSettings.getInstance();
                    if (dbgSettings.isDetectMethodEvalDeadlocks()) {
                        this.dj.startMethodEvaluationWorker();
                        DebugJDI.MethodEvaluationWorker worker = this.dj.methodEvaluationWorker;
                        worker.or = this.orAnnotation;
                        worker.methodEvaluationType = DebugJDI.MethodEvaluationType.VIRTUAL_CALL;
                        worker.dj = this.dj;
                        worker.m = mAnnotationType;
                        worker.argList = Collections.EMPTY_LIST;
                        try {
                            corAnnotationType = (ClassObjectReference)this.dj.evaluateMethodCheckForHang();
                        }
                        catch (Exception exception) {}
                    } else {
                        Log logger = JDebugger.logger;
                        if (logger.isEnabled()) {
                            ClassType ctClass = (ClassType)this.orAnnotation.referenceType();
                            logger.trace("Invoking method: {0}.{1}", (Object)(ctClass != null ? ctClass.name() : "<unknown>"), (Object)mAnnotationType.name());
                        }
                        int flag = DebugJDI.MULTI_THREADED_METHOD_EVALUATIONS ? 0 : 1;
                        corAnnotationType = (ClassObjectReference)this.orAnnotation.invokeMethod(this.dj.eventThread, mAnnotationType, Collections.EMPTY_LIST, flag);
                        if (logger.isEnabled()) {
                            logger.trace("Method return is {0}", (Object)(corAnnotationType == null ? "null" : "not null"));
                        }
                    }
                    if (corAnnotationType == null) return null;
                    ReferenceType rtAnnotationType = corAnnotationType.reflectedType();
                    DebugJDIClassInfo c = this.dj.findClassByType(rtAnnotationType);
                    if (c == null) return null;
                    DebugJDIClassInfo debugJDIClassInfo = c;
                    return debugJDIClassInfo;
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this.dj);
                    this.dj.tempReenableRequests(prev);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, DebugDataInfo> getProperties() {
        this.throwIfExpired();
        try {
            if (this.properties != null) return this.properties;
            this.properties = new TreeMap<String, DebugDataInfo>();
            if (this.dj.eventThread == null) return this.properties;
            ClassType ctAnnotation = (ClassType)this.orAnnotation.referenceType();
            Method mAnnotationType = ctAnnotation.concreteMethodByName("annotationType", "()Ljava/lang/Class;");
            if (mAnnotationType == null) return this.properties;
            Object object = this.dj.methodCallLock;
            synchronized (object) {
                List prev = this.dj.tempDisableRequests();
                DebugWindowSettings dbgSettings = DebugWindowSettings.getInstance();
                try {
                    Object ctClass;
                    Log logger = JDebugger.logger;
                    int flag = DebugJDI.MULTI_THREADED_METHOD_EVALUATIONS ? 0 : 1;
                    ClassObjectReference corAnnotationType = null;
                    if (dbgSettings.isDetectMethodEvalDeadlocks()) {
                        this.dj.startMethodEvaluationWorker();
                        DebugJDI.MethodEvaluationWorker worker = this.dj.methodEvaluationWorker;
                        worker.or = this.orAnnotation;
                        worker.methodEvaluationType = DebugJDI.MethodEvaluationType.VIRTUAL_CALL;
                        worker.dj = this.dj;
                        worker.m = mAnnotationType;
                        worker.argList = Collections.EMPTY_LIST;
                        try {
                            corAnnotationType = (ClassObjectReference)this.dj.evaluateMethodCheckForHang();
                        }
                        catch (Exception exception) {}
                    } else {
                        if (logger.isEnabled()) {
                            ctClass = (ClassType)this.orAnnotation.referenceType();
                            logger.trace("Invoking method: {0}.{1}", (Object)(ctClass != null ? ctClass.name() : "<unknown>"), (Object)mAnnotationType.name());
                        }
                        corAnnotationType = (ClassObjectReference)this.orAnnotation.invokeMethod(this.dj.eventThread, mAnnotationType, Collections.EMPTY_LIST, flag);
                        if (logger.isEnabled()) {
                            logger.trace("Method return is {0}", (Object)(corAnnotationType == null ? "null" : "not null"));
                        }
                    }
                    if (corAnnotationType == null) {
                        ctClass = this.properties;
                        return ctClass;
                    }
                    ReferenceType rtAnnotationType = corAnnotationType.reflectedType();
                    List<Method> methods = rtAnnotationType.methods();
                    List arguments = Collections.emptyList();
                    Iterator<Method> iterator = methods.iterator();
                    while (iterator.hasNext()) {
                        Method m = iterator.next();
                        if (!m.signature().startsWith("()")) continue;
                        Value value = null;
                        String name = m.name();
                        if (dbgSettings.isDetectMethodEvalDeadlocks()) {
                            this.dj.startMethodEvaluationWorker();
                            DebugJDI.MethodEvaluationWorker worker = this.dj.methodEvaluationWorker;
                            worker.or = this.orAnnotation;
                            worker.methodEvaluationType = DebugJDI.MethodEvaluationType.VIRTUAL_CALL;
                            worker.dj = this.dj;
                            worker.m = m;
                            worker.argList = arguments;
                            try {
                                value = this.dj.evaluateMethodCheckForHang();
                            }
                            catch (Exception exception) {}
                        } else {
                            if (logger.isEnabled()) {
                                ClassType ctClass2 = (ClassType)this.orAnnotation.referenceType();
                                logger.trace("Invoking method: {0}.{1}", (Object)(ctClass2 != null ? ctClass2.name() : "<unknown>"), (Object)m.name());
                            }
                            value = this.orAnnotation.invokeMethod(this.dj.eventThread, m, arguments, flag);
                            if (logger.isEnabled()) {
                                logger.trace("Method return is {0}", (Object)(value == null ? "null" : "not null"));
                            }
                        }
                        DebugJDIDataInfo data = null;
                        if (value != null) {
                            data = this.dj.makeData(value, null);
                        } else {
                            DebugJDIClassInfo dataClass = this.dj.findClassByType(m.returnType());
                            if (dataClass != null) {
                                data = this.dj.makeNullData(dataClass, null);
                            }
                        }
                        if (data == null) continue;
                        this.properties.put(name, data);
                    }
                    return this.properties;
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this.dj);
                    this.dj.tempReenableRequests(prev);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.properties;
    }

    public Value getJDIValue() {
        return this.orAnnotation;
    }
}

