/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.workbench.core.ui.DataMapPanel;

public final class ComboCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = 3953230538755610540L;
    private Map<DataTypeSpecification, List<DataTypeSpecification>> _sourceTargetMap;

    public ComboCellEditor(JComboBox jComboBox) {
        super(jComboBox);
    }

    public void setSourceTargetMap(Map<DataTypeSpecification, List<DataTypeSpecification>> map) {
        this._sourceTargetMap = map;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        JComboBox jComboBox = (JComboBox)super.getComponent();
        DataTypeSpecification dataTypeSpecification = (DataTypeSpecification)jTable.getValueAt(n, jTable.getColumnModel().getColumnIndex(DataMapPanel.SOURCE_DATA_TYPE));
        List<DataTypeSpecification> list = null;
        if (this._sourceTargetMap.containsKey(dataTypeSpecification)) {
            list = this._sourceTargetMap.get(dataTypeSpecification);
        } else {
            HashSet<DataTypeSpecification> hashSet = new HashSet<DataTypeSpecification>();
            for (List<DataTypeSpecification> list2 : this._sourceTargetMap.values()) {
                hashSet.addAll(list2);
            }
            list = new ArrayList<DataTypeSpecification>(hashSet);
        }
        if (!list.contains(object)) {
            list.add((DataTypeSpecification)object);
        }
        this.fillCombo(jComboBox, list);
        jComboBox.setSelectedItem(object);
        return this.editorComponent;
    }

    private void fillCombo(JComboBox jComboBox, List<DataTypeSpecification> list) {
        jComboBox.removeAllItems();
        for (DataTypeSpecification dataTypeSpecification : list) {
            jComboBox.addItem(dataTypeSpecification);
        }
    }
}

