/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline.streams;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.datamove.DataMoveDescriptor;
import oracle.dbtools.migration.datamove.offline.ClobToBlobHandler;
import oracle.dbtools.migration.datamove.offline.OfflineConstraintHandler;
import oracle.dbtools.migration.datamove.offline.OfflineTriggerHandler;
import oracle.dbtools.migration.datamove.offline.streams.MdColumnComparator;
import oracle.dbtools.migration.datamove.online.ConstraintHandler;
import oracle.dbtools.migration.datamove.online.IdentityHandler;
import oracle.dbtools.migration.datamove.online.TriggerHandler;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.preferences.MaskUtil;
import oracle.dbtools.raptor.utils.RaptorGroupLoader;
import org.antlr.stringtemplate.AttributeRenderer;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class ScriptFilesContentGenerator {
    private static final String TEMPLATEPATH = "oracle/dbtools/migration/datamove/offline/streams/templates";
    private StringTemplateGroup streamTemplateGroup;
    private StringTemplateGroup fileTemplateGroup;
    private StringTemplateGroup oracleTemplateGroup;
    private OfflineConstraintHandler constraintHandler;
    private ArrayList<ConstraintHandler.ConstraintDetail> constraintsOn;
    private ArrayList<ConstraintHandler.ConstraintDetail> constraintsOff;
    private OfflineTriggerHandler triggerHandler;
    private HashSet<TriggerHandler.TriggerInformation> triggers;
    private ClobToBlobHandler clobToBlobHandler;
    private IdentityHandler identityHandler;
    private static String FILE = "files";
    private static String ORACLE = "oracle";
    private String m_type;

    public ScriptFilesContentGenerator(String string) {
        this.setType(string);
        Thread.currentThread().setContextClassLoader(ScriptFilesContentGenerator.class.getClassLoader());
        if (this.streamTemplateGroup == null) {
            RaptorGroupLoader raptorGroupLoader = new RaptorGroupLoader(TEMPLATEPATH, this.getClass().getClassLoader());
            StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)raptorGroupLoader);
            StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
            this.streamTemplateGroup = StringTemplateGroup.loadGroup((String)string);
            this.fileTemplateGroup = StringTemplateGroup.loadGroup((String)FILE);
            this.oracleTemplateGroup = StringTemplateGroup.loadGroup((String)ORACLE);
        }
    }

    private String formatCol(MdColumn mdColumn, MdColumn mdColumn2, MigrationPlugin migrationPlugin) {
        String string = migrationPlugin.maybeQuoteSqlldrFieldReference(mdColumn, mdColumn2);
        String[] stringArray = MaskUtil.getMatchingRow(mdColumn.getColumnType());
        String string2 = null;
        string2 = stringArray != null ? "\"" + stringArray[0] + "(:" + mdColumn2.getColumnName() + ", '" + stringArray[1] + "')\"" : migrationPlugin.formatSQLLoaderColumn(mdColumn, mdColumn2);
        if (migrationPlugin.usesClobToBlob() && MigrationAddin.getMigrationConfig().getGenerateClobToBlob() && mdColumn2.getColumnType().toUpperCase().equals("BLOB")) {
            string = "SQLDEVELOPER_CLOB_" + mdColumn2.getColumnOrder();
        }
        return string + " " + string2;
    }

    public String getBody(String string, String string2, boolean bl) {
        StringTemplate stringTemplate = null;
        stringTemplate = bl ? this.fileTemplateGroup.getInstanceOf("windowsfile") : this.fileTemplateGroup.getInstanceOf("unixfile");
        stringTemplate.setAttribute("dir", (Object)string);
        stringTemplate.setAttribute("filename", (Object)string2);
        String string3 = stringTemplate.toString();
        return string3;
    }

    public String getConstraint(ArrayList<ConstraintHandler.ConstraintDetail> arrayList, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (arrayList != null && arrayList.size() > 0) {
            for (ConstraintHandler.ConstraintDetail constraintDetail : arrayList) {
                StringTemplate stringTemplate = null;
                stringTemplate = this.oracleTemplateGroup.getInstanceOf(string);
                stringTemplate.setAttribute("tableName", (Object)(constraintDetail.getSchemaName() + "." + constraintDetail.getTableName()));
                stringTemplate.setAttribute("constraintName", (Object)constraintDetail.getConstraintName());
                stringBuilder.append(stringTemplate.toString());
            }
        }
        return stringBuilder.toString();
    }

    public String getConstraintOff() {
        return this.getConstraint(this.constraintsOff, "constraintOff");
    }

    public String getConstraintOn() {
        return this.getConstraint(this.constraintsOn, "constraintOn");
    }

    public String getDisableTriggersForSchema() {
        Iterator<TriggerHandler.TriggerInformation> iterator = this.triggers.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            TriggerHandler.TriggerInformation triggerInformation = iterator.next();
            StringTemplate stringTemplate = null;
            stringTemplate = this.oracleTemplateGroup.getInstanceOf("triggerOff");
            stringTemplate.setAttribute("triggerName", (Object)(triggerInformation.getSchemaName() + "." + triggerInformation.getTriggerName()));
            stringBuilder.append(stringTemplate.toString());
        }
        return stringBuilder.toString();
    }

    public String getEnableIdentityForSchema() {
        return "--TODO - YOU NEED TO SORT IDENTITY COLUMNS";
    }

    public String getEnableTriggersForSchema() {
        Iterator<TriggerHandler.TriggerInformation> iterator = this.triggers.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            TriggerHandler.TriggerInformation triggerInformation = iterator.next();
            StringTemplate stringTemplate = null;
            stringTemplate = this.oracleTemplateGroup.getInstanceOf("triggerOn");
            stringTemplate.setAttribute("triggerName", (Object)(triggerInformation.getSchemaName() + "." + triggerInformation.getTriggerName()));
            stringBuilder.append(stringTemplate.toString());
        }
        return stringBuilder.toString();
    }

    public String getHeadScript(String string, boolean bl) {
        StringTemplate stringTemplate = null;
        String string2 = null;
        string2 = string.contains("_data") ? "servername" : "servicename";
        if (bl) {
            stringTemplate = this.fileTemplateGroup.getInstanceOf("windowsheader");
        } else {
            stringTemplate = this.fileTemplateGroup.getInstanceOf("unixheader");
            stringTemplate.setAttribute("filename", (Object)string);
            stringTemplate.setAttribute("sname", (Object)string2);
        }
        String string3 = stringTemplate.toString();
        return string3;
    }

    public String getSQLErrorStatement() {
        StringTemplate stringTemplate = null;
        stringTemplate = this.oracleTemplateGroup.getInstanceOf("wheneversqlerror");
        String string = stringTemplate.toString();
        return string;
    }

    public String getStreamBody(String string, String string2, boolean bl) {
        StringTemplate stringTemplate = null;
        stringTemplate = this.streamTemplateGroup.getInstanceOf("command");
        stringTemplate.setAttribute("fileName", (Object)string2);
        stringTemplate.setAttribute("platformWindows", (Object)bl);
        String string3 = stringTemplate.toString();
        return string3;
    }

    public String getStreamBodyHeader(boolean bl) {
        StringTemplate stringTemplate = null;
        try {
            stringTemplate = this.streamTemplateGroup.getInstanceOf("OracleHeader");
            stringTemplate.setAttribute("platformWindows", (Object)bl);
            stringTemplate.setAttribute("date", (Object)MigrationAddin.getMigrationConfig().getDateOfflineDateMask());
            return stringTemplate.toString();
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getStreamBodyFooter(boolean bl) {
        StringTemplate stringTemplate = null;
        try {
            stringTemplate = this.streamTemplateGroup.getInstanceOf("OracleFooter");
            stringTemplate.setAttribute("platformWindows", (Object)bl);
            return stringTemplate.toString();
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getTableCommand(DataMoveDescriptor dataMoveDescriptor, String string, String string2, MigrationPlugin migrationPlugin) {
        StringTemplate stringTemplate = null;
        MdColumn[] mdColumnArray = dataMoveDescriptor.getSourceColumns();
        MdColumn[] mdColumnArray2 = dataMoveDescriptor.getTargetColumns();
        Arrays.sort(mdColumnArray, new MdColumnComparator());
        Arrays.sort(mdColumnArray2, new MdColumnComparator());
        stringTemplate = this.streamTemplateGroup.getInstanceOf("statement");
        stringTemplate.setAttribute("infile", (Object)migrationPlugin.createDataFileName(dataMoveDescriptor.getTargetTableName(true), dataMoveDescriptor.getSourceTableName()));
        stringTemplate.setAttribute("rowDelimiter", (Object)migrationPlugin.getDataMoveRowDelimiter());
        stringTemplate.setAttribute("fieldTerminator", (Object)migrationPlugin.getDataMoveColumnDelimiter());
        if (this.m_type.startsWith("external")) {
            stringTemplate.setAttribute("table_name", (Object)string2);
            stringTemplate.setAttribute("table_name_ext", (Object)this.getExternalTableName(string2));
            Object[] objectArray = migrationPlugin.generateExternalTableColumnDefinitions(mdColumnArray, mdColumnArray2);
            if (objectArray == null) {
                objectArray = mdColumnArray2;
            }
            stringTemplate.setAttribute("colList", (Object)objectArray);
            String string3 = migrationPlugin.generateExternalColumnDefinitions(mdColumnArray, mdColumnArray2);
            if (string3 == null) {
                string3 = this.generateExternalColumnDefinitions(mdColumnArray, mdColumnArray2);
            }
            stringTemplate.setAttribute("column_definitions", (Object)string3);
            String string4 = migrationPlugin.generateExternalSelectColumnList(mdColumnArray, mdColumnArray2);
            stringTemplate.setAttribute("colList_ext", (Object)string4);
            this.streamTemplateGroup.registerRenderer(String.class, (Object)new BasicFormatRenderer());
        } else {
            stringTemplate.setAttribute("table_name", (Object)string2);
            stringTemplate.setAttribute("colList", (Object)this.processColumns(dataMoveDescriptor, migrationPlugin));
            stringTemplate.setAttribute("column_definitions", Arrays.asList(mdColumnArray2));
        }
        stringTemplate.setAttribute("schemaName", (Object)dataMoveDescriptor.getTargetSchema().getName());
        return stringTemplate.toString();
    }

    private String generateExternalColumnDefinitions(MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTemplate stringTemplate = null;
        Arrays.sort(mdColumnArray, new MdColumnComparator());
        Arrays.sort(mdColumnArray2, new MdColumnComparator());
        for (int i = 0; i < mdColumnArray2.length; ++i) {
            stringBuffer.append("\"" + mdColumnArray2[i].getColumnName().toUpperCase() + "\"");
            String string = mdColumnArray2[i].getColumnType().toUpperCase();
            if (string.equals("DATE") || string.equals("TIMESTAMP")) {
                String[] stringArray = MaskUtil.getMatchingRow(mdColumnArray[i].getColumnType());
                String string2 = null;
                string2 = stringArray != null ? stringArray[1] : MigrationAddin.getMigrationConfig().getTimeStampOfflineDateMask();
                stringTemplate = this.streamTemplateGroup.getInstanceOf("dateTimestampFormat");
                stringTemplate.setAttribute("datatype", (Object)"TIMESTAMP");
                stringTemplate.setAttribute("format", (Object)string2);
                stringBuffer.append(stringTemplate.toString());
                stringTemplate.reset();
            }
            if (i >= mdColumnArray2.length - 1) continue;
            stringBuffer.append(", \n");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public String getTailScript(String string, boolean bl) {
        StringTemplate stringTemplate = null;
        String string2 = null;
        string2 = string.contains("_data") ? "servername" : "servicename";
        if (bl) {
            stringTemplate = this.fileTemplateGroup.getInstanceOf("windowstail");
            stringTemplate.setAttribute("filename", (Object)string);
            stringTemplate.setAttribute("sname", (Object)string2);
        }
        if (stringTemplate != null) {
            String string3 = stringTemplate.toString();
            return string3;
        }
        return "";
    }

    public String getTruncStatement(String string) {
        StringTemplate stringTemplate = null;
        stringTemplate = this.streamTemplateGroup.getInstanceOf("truncateStatement");
        stringTemplate.setAttribute("tableName", (Object)string);
        String string2 = stringTemplate.toString();
        return string2;
    }

    private String[] processColumns(DataMoveDescriptor dataMoveDescriptor, MigrationPlugin migrationPlugin) {
        MdColumn[] mdColumnArray = dataMoveDescriptor.getSourceColumns();
        MdColumn[] mdColumnArray2 = dataMoveDescriptor.getTargetColumns();
        Arrays.sort(mdColumnArray, new MdColumnComparator());
        Arrays.sort(mdColumnArray2, new MdColumnComparator());
        String[] stringArray = new String[mdColumnArray2.length];
        for (int i = 0; i < mdColumnArray2.length; ++i) {
            stringArray[i] = this.formatCol(mdColumnArray[i], mdColumnArray2[i], migrationPlugin);
        }
        return stringArray;
    }

    public void setSchema(String string, String string2) {
        this.constraintsOff = this.constraintHandler.getConstraints(string, string2, "CONSTRAINTS_OFF");
        this.constraintsOn = this.constraintHandler.getConstraints(string, string2, "CONSTRAINTS_ON");
        this.triggers = this.triggerHandler.getTriggers(string, string2);
    }

    public void start(MdConnection mdConnection, PersistenceManager persistenceManager) {
        this.constraintHandler = new OfflineConstraintHandler(mdConnection.getKey(), persistenceManager);
        this.triggerHandler = new OfflineTriggerHandler(mdConnection.getKey(), persistenceManager);
        this.clobToBlobHandler = new ClobToBlobHandler(mdConnection.getKey(), persistenceManager);
        this.identityHandler = new IdentityHandler(mdConnection.getKey(), persistenceManager);
    }

    public String alterTableClob(String string, DataMoveDescriptor dataMoveDescriptor, MigrationPlugin migrationPlugin) {
        if (!this.m_type.startsWith("external") && migrationPlugin.usesClobToBlob() && MigrationAddin.getMigrationConfig().getGenerateClobToBlob()) {
            return this.clobToBlobHandler.writeAddAndModify(string, dataMoveDescriptor.getTargetSchema().getName());
        }
        return "";
    }

    public String callBlobToClob(String string, DataMoveDescriptor dataMoveDescriptor, MigrationPlugin migrationPlugin) {
        if (!this.m_type.startsWith("external") && migrationPlugin.usesClobToBlob() && MigrationAddin.getMigrationConfig().getGenerateClobToBlob()) {
            return this.clobToBlobHandler.writeProcedureCallAndNotNull(string, dataMoveDescriptor.getTargetSchema().getName());
        }
        return "";
    }

    public String generateDirectoryObject(String string, String string2) {
        if (this.m_type.startsWith("external")) {
            StringTemplate stringTemplate = null;
            stringTemplate = this.streamTemplateGroup.getInstanceOf("generateDirectory");
            stringTemplate.setAttribute("directory", (Object)string);
            stringTemplate.setAttribute("schemaName", (Object)string2);
            stringTemplate.setAttribute("separator", (Object)File.separator);
            return stringTemplate.toString();
        }
        return "";
    }

    public String dropDirectoryObject(String string) {
        if (this.m_type.startsWith("external")) {
            StringTemplate stringTemplate = null;
            stringTemplate = this.streamTemplateGroup.getInstanceOf("dropDirectory");
            stringTemplate.setAttribute("schemaName", (Object)string);
            return stringTemplate.toString();
        }
        return "";
    }

    public void setType(String string) {
        this.m_type = string;
    }

    private String getExternalTableName(String string) {
        String string2 = null;
        int n = string.indexOf(".");
        if (n > 0) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1, string.length());
        }
        if (string.length() > 26) {
            string = string.substring(0, 26);
        }
        string = string + "_ext";
        if (n > 0) {
            return string2 + "." + string;
        }
        return string;
    }

    public class BasicFormatRenderer
    implements AttributeRenderer {
        public String toString(Object object) {
            return object.toString();
        }

        public String toString(Object object, String string) {
            if (string.equals("toUpper")) {
                return object.toString().toUpperCase();
            }
            if (string.equals("toLower")) {
                return object.toString().toLowerCase();
            }
            if (string.equals("toUpperQuoted")) {
                return "\"" + object.toString().toUpperCase() + "\"";
            }
            throw new IllegalArgumentException("Unsupported format name");
        }
    }
}

