/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.capture;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.capture.CaptureCmd;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.PlatformDatabaseListProvider;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class TeradataDatabaseListProvider
implements PlatformDatabaseListProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<String> getAvailableOfflineDatabaseList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Properties properties = new Properties();
        File file = null;
        String string2 = null;
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            Object object;
            Object object2;
            String string3;
            file = new File(string);
            if (file != null && file.canRead()) {
                fileInputStream = new FileInputStream(file);
                string2 = file.getParent();
                properties.load(fileInputStream);
            }
            if ((string3 = properties.getProperty("SCHEMAS_FILE")) != null && ((File)(object2 = new File(string2, string3 = string3.trim()))).exists() && ((File)object2).canRead()) {
                object = new FileReader((File)object2);
                bufferedReader = new LineNumberReader((Reader)object);
            }
            if (bufferedReader != null) {
                object2 = new TeraDataFileReader((LineNumberReader)bufferedReader);
                while (((TeraDataFileReader)object2).next()) {
                    object = ((TeraDataFileReader)object2).get("DBNAME");
                    if (object == null) continue;
                    arrayList.add((String)object);
                }
            }
        }
        catch (SecurityException securityException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string4 = MigrationAddinArb.format("ERR_FILE_MISSING", file.getName());
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)MigrationAddinArb.getString("TITLE_FILE_MISSING"), (String)"help_file_missing");
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
        return arrayList;
    }

    public ArrayList<String> getAvailableOnlineDatabaseList1(String string) {
        return this.getOnlineDatabaseNames(string);
    }

    @Override
    public ArrayList<String> getAvailableOnlineDatabaseList(String string) {
        boolean bl = this.isClassicMigration(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!bl) {
            CaptureCmd captureCmd = new CaptureCmd();
            return captureCmd.getListOfOnlineSourceDatabases(string);
        }
        try {
            String string2 = Connections.getInstance().getConnection(string).getMetaData().getURL();
            String string3 = string2.substring(string2.lastIndexOf(47) + 1, string2.length());
            arrayList.add(string3);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return arrayList;
    }

    private ArrayList<String> getOnlineDatabaseNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Connection connection = Connections.getInstance().getConnection(string);
            PreparedStatement preparedStatement = connection.prepareStatement("select DatabaseNameI from dbc.dbase where DatabaseNameI NOT IN ('TDPUSER', 'TDUSER', 'TWM', 'SQLJ','SYSTEMFE','DEFAULT','SYSSPATIAL','CRASHDUMPS','SYSLIB');");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                if (string2 == null) continue;
                arrayList.add(string2);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return arrayList;
    }

    private boolean isClassicMigration(String string) {
        boolean bl = false;
        String string2 = null;
        try {
            Connection connection = Connections.getInstance().getConnection(string);
            string2 = connection.getMetaData().getDatabaseProductVersion();
            if (string2.startsWith("07.") || string2.startsWith("7.") || string2.startsWith("08.") || string2.startsWith("8.")) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isSystemDatabase(String string) {
        return false;
    }

    private class TeraDataFileReader {
        private Map<String, Integer> columnStartPosMap = new Hashtable<String, Integer>();
        private Map<String, Integer> columnEndPosMap = new Hashtable<String, Integer>();
        private String headerLine;
        private String nextLine;
        private LineNumberReader lnr;
        private String[] columnNames;
        private int recordNo;

        public TeraDataFileReader(LineNumberReader lineNumberReader) throws IOException {
            this.lnr = lineNumberReader;
            this.headerLine = lineNumberReader.readLine();
            if (this.headerLine != null) {
                this.columnNames = this.headerLine.split("[  |]+");
                int n = 0;
                this.columnStartPosMap.put(this.columnNames[0], n);
                for (int i = 1; i < this.columnNames.length; ++i) {
                    if ((n = this.headerLine.indexOf(124, n)) < 0) continue;
                    this.columnEndPosMap.put(this.columnNames[i - 1], n);
                    this.columnStartPosMap.put(this.columnNames[i], ++n);
                }
                this.nextLine = null;
            }
        }

        public boolean next() throws IOException {
            this.nextLine = this.lnr.readLine();
            this.recordNo = this.lnr.getLineNumber();
            return this.nextLine != null;
        }

        public String get(String string) {
            String string2 = null;
            Integer n = this.columnStartPosMap.get(string);
            Integer n2 = this.columnEndPosMap.get(string);
            if (n != null) {
                string2 = n2 == null ? this.nextLine.substring(n) : this.nextLine.substring(n, n2);
            }
            return string2 != null ? string2.trim() : null;
        }
    }
}

